/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import kotlinx.serialization.json.JsonArray;
import org.jetbrains.annotations.NotNull;
import org.rubyforge.debugcommons.ICommandFactory;
import org.rubyforge.debugcommons.model.IRubyExceptionBreakpoint;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyDebugCommandFactory
implements ICommandFactory {
    private final boolean readFramesForNonSuspendedThreads;

    public RubyDebugCommandFactory(boolean readFramesForNonSuspendedThreads) {
        this.readFramesForNonSuspendedThreads = readFramesForNonSuspendedThreads;
    }

    private String switchThreadContext(RubyThread thread) {
        return this.readFramesForNonSuspendedThreads ? "th in " + thread.getId() + "; " : "";
    }

    private String switchThreadAndFrameContext(RubyFrame frame) {
        return this.switchThreadContext(frame.getThread()) + "frame " + frame.getIndex() + "; ";
    }

    @Override
    public String createReadFrames(RubyThread thread) {
        return this.switchThreadContext(thread) + "w";
    }

    @Override
    public String createReadLocalVariables(RubyFrame frame) {
        return this.switchThreadAndFrameContext(frame) + "v l";
    }

    @Override
    public String createReadReceiver(@NotNull RubyFrame frame) {
        if (frame == null) {
            RubyDebugCommandFactory.$$$reportNull$$$0(0);
        }
        return this.switchThreadAndFrameContext(frame) + "v r";
    }

    @Override
    public String createReadReturnValue(@NotNull RubyFrame frame) {
        if (frame == null) {
            RubyDebugCommandFactory.$$$reportNull$$$0(1);
        }
        return this.switchThreadAndFrameContext(frame) + "v ret";
    }

    @Override
    public String createReadGlobalVariables() {
        return "v g";
    }

    @Override
    public String createReadInstanceVariable(RubyVariable variable) {
        StringBuilder command = new StringBuilder();
        RubyFrame frame = variable.getFrame();
        if (!variable.isGlobal() && frame != null) {
            command.append(this.switchThreadAndFrameContext(frame));
        }
        return command.append("v i ").append(variable.getObjectId()).toString();
    }

    @Override
    public String createReadInstanceVariablesRange(RubyVariable variable, int startPosition, int limit) {
        StringBuilder command = new StringBuilder();
        RubyFrame frame = variable.getFrame();
        if (!variable.isGlobal() && frame != null) {
            command.append(this.switchThreadAndFrameContext(frame));
        }
        return command.append("v il").append(startPosition).append(":").append(limit).append(" ").append(variable.getObjectId()).append(" ").toString();
    }

    @Override
    public String createStepOver(RubyFrame frame) {
        return this.switchThreadAndFrameContext(frame) + "next";
    }

    @Override
    public String createForcedStepOver(RubyFrame frame) {
        return this.switchThreadAndFrameContext(frame) + "next+";
    }

    @Override
    public String createStepReturn(RubyFrame frame) {
        return this.switchThreadAndFrameContext(frame) + "finish";
    }

    @Override
    public String createStepInto(RubyFrame frame) {
        return this.switchThreadAndFrameContext(frame) + "step";
    }

    @Override
    public String createForcedStepInto(RubyFrame frame) {
        return this.switchThreadAndFrameContext(frame) + "step+";
    }

    @Override
    public String createReadThreads() {
        return "th l";
    }

    @Override
    public String createReadSmartStepIntoVariants() {
        return "sv";
    }

    @Override
    public String createSmartStepInto(int id) {
        return "ss " + id;
    }

    @Override
    public String createSuspensionLocation(RubyFrame frame) {
        return this.switchThreadAndFrameContext(frame) + "l " + frame.getIndex();
    }

    @Override
    public String createLoad(String filename) {
        return "load " + filename;
    }

    @Override
    public String createInspect(RubyFrame frame, String expression) {
        return this.switchThreadAndFrameContext(frame) + "v inspect " + expression.replaceAll(";", "\\\\;");
    }

    @Override
    public String createLoadFullValue(RubyFrame frame, boolean unlimited, String expression) {
        String key = unlimited ? " -unlimited " : "";
        return this.switchThreadAndFrameContext(frame) + "v load_full_value " + key + expression.replaceAll(";", "\\\\;");
    }

    @Override
    public String createExpressionInfo(RubyFrame frame, String expression) {
        return "expression_info " + expression.replaceAll(";", "\\\\;");
    }

    @Override
    public String createResume(RubyThread thread) {
        return "cont";
    }

    @Override
    public String createAddBreakpoint(String file, int line, boolean isAllSuspensions) {
        return (isAllSuspensions ? "ba " : "b ") + file + ":" + line;
    }

    @Override
    public String createAddBlockBreakpoint(String file, int line, int blockIndex) {
        return "bb " + file + ":" + line + ":" + blockIndex;
    }

    @Override
    public String createEnableBreakpoint(int index) {
        return "enable " + index;
    }

    @Override
    public String createDisableBreakpoint(int index) {
        return "disable " + index;
    }

    @Override
    public String createRemoveBreakpoint(int index) {
        return "delete " + index;
    }

    @Override
    public String createCatchOff() {
        return "catch off";
    }

    @Override
    public String createCatchOn(IRubyExceptionBreakpoint breakpoint) {
        return "catch " + breakpoint.getException();
    }

    @Override
    public String createCatchOff(IRubyExceptionBreakpoint breakpoint) {
        return "catch " + breakpoint.getException() + " off";
    }

    @Override
    public String createSetCondition(int bpNum, String condition) {
        return "condition " + bpNum + " " + condition;
    }

    @Override
    @NotNull
    public String createSetRenderers(@NotNull JsonArray typeRenderers) {
        if (typeRenderers == null) {
            RubyDebugCommandFactory.$$$reportNull$$$0(2);
        }
        String string = "renderers " + String.valueOf(typeRenderers);
        if (string == null) {
            RubyDebugCommandFactory.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRenderers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/RubyDebugCommandFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/RubyDebugCommandFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetRenderers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReadReceiver";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createReadReturnValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createSetRenderers";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

