/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ThreeState;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.Util;
import org.rubyforge.debugcommons.model.ExpressionInfo;
import org.rubyforge.debugcommons.model.Message;
import org.rubyforge.debugcommons.model.RubyDebugTarget;
import org.rubyforge.debugcommons.model.RubyFrameInfo;
import org.rubyforge.debugcommons.model.RubyFullValueInfo;
import org.rubyforge.debugcommons.model.RubyRenderersStatusInfo;
import org.rubyforge.debugcommons.model.RubyStepVariant;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;
import org.rubyforge.debugcommons.model.RubyThreadInfo;
import org.rubyforge.debugcommons.model.RubyVariableInfo;
import org.rubyforge.debugcommons.model.SuspensionPoint;
import org.rubyforge.debugcommons.reader.BreakpointAddedReader;
import org.rubyforge.debugcommons.reader.BreakpointDeletedReader;
import org.rubyforge.debugcommons.reader.BreakpointDisabledReader;
import org.rubyforge.debugcommons.reader.BreakpointEnabledReader;
import org.rubyforge.debugcommons.reader.CatchpointSetReader;
import org.rubyforge.debugcommons.reader.ConditionSetReader;
import org.rubyforge.debugcommons.reader.ErrorReader;
import org.rubyforge.debugcommons.reader.ExpressionInfoReader;
import org.rubyforge.debugcommons.reader.FramesReader;
import org.rubyforge.debugcommons.reader.FullValueReader;
import org.rubyforge.debugcommons.reader.RenderersStatusReader;
import org.rubyforge.debugcommons.reader.RubyBreakpointStateChangedReader;
import org.rubyforge.debugcommons.reader.SpecialVariableReader;
import org.rubyforge.debugcommons.reader.StepVariantsReader;
import org.rubyforge.debugcommons.reader.SuspensionLocationReader;
import org.rubyforge.debugcommons.reader.SuspensionReader;
import org.rubyforge.debugcommons.reader.ThreadInfoReader;
import org.rubyforge.debugcommons.reader.VariablesReader;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

final class ReadersSupport {
    private static final Logger LOG = Logger.getInstance(ReadersSupport.class);
    private static final long QUEUE_POLLING_TIME_MS = 10L;
    private static final String BREAKPOINT_ELEMENT = "breakpoint";
    private static final String SUSPENDED_ELEMENT = "suspended";
    private static final String UNABLE_ELEMENT = "unable";
    private static final String EXCEPTION_ELEMENT = "exception";
    private static final String BREAKPOINT_ADDED_ELEMENT = "breakpointAdded";
    private static final String BREAKPOINT_DELETED_ELEMENT = "breakpointDeleted";
    private static final String SMART_STEP_VARIANTS_ELEMENT = "variants";
    private static final String BREAKPOINT_ENABLED_ELEMENT = "breakpointEnabled";
    private static final String BREAKPOINT_DISABLED_ELEMENT = "breakpointDisabled";
    private static final String BREAKPOINT_STATE_CHANGED_ELEMENT = "breakpointStateChanged";
    private static final String CONDITION_SET_ELEMENT = "conditionSet";
    private static final String CATCHPOINT_SET_ELEMENT = "catchpointSet";
    private static final String CATCHPOINT_DELETED_ELEMENT = "catchpointDeleted";
    private static final String SUSPENSION_LOCATION_ELEMENT = "location";
    private static final String THREADS_ELEMENT = "threads";
    private static final String FRAMES_ELEMENT = "frames";
    private static final String FRAME_ELEMENT = "frame";
    private static final String RECEIVER_ELEMENT = "receiver";
    private static final String RETURN_VALUE_ELEMENT = "returnValue";
    private static final String VARIABLES_ELEMENT = "variables";
    private static final String FULL_VALUE_ELEMENT = "fullValue";
    private static final String RENDERERS_STATUS_ELEMENT = "renderersStatus";
    private static final String PROCESSING_EXCEPTION_ELEMENT = "processingException";
    private static final String EXPRESSION_INFO_ELEMENT = "expressionInfo";
    private static final String FILE_INCLUDED = "fileIncluded";
    private static final String FILE_EXCLUDED = "fileExcluded";
    private static final String FILE_FILTER = "fileFilter";
    private static final String RUBY_DEBUG_PROMPT = "PROMPT";
    private static final String FINISHED = "finished";
    private final long myTimeout;
    private final AtomicBoolean myTerminated;
    private XPPLoop myLoopThread;
    private final BlockingQueue<RubyThreadInfo[]> threads;
    private final BlockingQueue<RubyFrameInfo[]> frames;
    private final BlockingQueue<RubyStepVariant[]> smartStepIntoVariants;
    private final BlockingQueue<RubyVariableInfo[]> variables;
    private final BlockingQueue<RubyVariableInfo> receivers;
    private final BlockingQueue<RubyVariableInfo> returnValues;
    private final BlockingQueue<RubyFullValueInfo> fullValues;
    private final BlockingQueue<RubyRenderersStatusInfo> renderersStatuses;
    private final BlockingQueue<SuspensionPoint> suspensions;
    private InputStream myInputStream;
    private final BlockingQueue<@NotNull Pair<@NotNull Integer, @NotNull ThreeState>> addedBreakpoints;
    private final BlockingQueue<Integer> removedBreakpoints;
    private final BlockingQueue<Integer> enabledBreakpoints;
    private final BlockingQueue<Integer> disabledBreakpoints;
    private final BlockingQueue<@NotNull Pair<@NotNull Integer, @NotNull ThreeState>> breakpointStateChanges;
    private final BlockingQueue<Integer> conditionSets;
    private final BlockingQueue<String> catchpointSets;
    private final BlockingQueue<String> deletedCatchpoints;
    private final BlockingQueue<ExpressionInfo> expressionInfos;
    private final BlockingQueue<RubySuspensionLocation> suspensionLocations;
    private final RubyDebuggerProxy myProxy;
    private boolean finished;
    private boolean unexpectedFail;

    /*
     * WARNING - void declaration
     */
    ReadersSupport(long timeout, @NotNull RubyDebuggerProxy rubyDebuggerProxy) {
        void proxy;
        if (rubyDebuggerProxy == null) {
            ReadersSupport.$$$reportNull$$$0(0);
        }
        this.myTerminated = new AtomicBoolean(false);
        this.myProxy = proxy;
        this.myTimeout = 2L * Math.max(10L, timeout);
        this.threads = new LinkedBlockingQueue<RubyThreadInfo[]>();
        this.frames = new LinkedBlockingQueue<RubyFrameInfo[]>();
        this.smartStepIntoVariants = new LinkedBlockingQueue<RubyStepVariant[]>();
        this.variables = new LinkedBlockingQueue<RubyVariableInfo[]>();
        this.receivers = new LinkedBlockingQueue<RubyVariableInfo>();
        this.returnValues = new LinkedBlockingQueue<RubyVariableInfo>();
        this.fullValues = new LinkedBlockingQueue<RubyFullValueInfo>();
        this.renderersStatuses = new LinkedBlockingQueue<RubyRenderersStatusInfo>();
        this.suspensions = new LinkedBlockingQueue<SuspensionPoint>();
        this.addedBreakpoints = new LinkedBlockingQueue<Pair<Integer, ThreeState>>();
        this.removedBreakpoints = new LinkedBlockingQueue<Integer>();
        this.enabledBreakpoints = new LinkedBlockingQueue<Integer>();
        this.disabledBreakpoints = new LinkedBlockingQueue<Integer>();
        this.breakpointStateChanges = new LinkedBlockingQueue<Pair<Integer, ThreeState>>();
        this.conditionSets = new LinkedBlockingQueue<Integer>();
        this.catchpointSets = new LinkedBlockingQueue<String>();
        this.deletedCatchpoints = new LinkedBlockingQueue<String>();
        this.expressionInfos = new LinkedBlockingQueue<ExpressionInfo>();
        this.suspensionLocations = new LinkedBlockingQueue<RubySuspensionLocation>();
    }

    synchronized boolean startCommandLoop(InputStream is) throws RubyDebuggerException {
        if (this.myInputStream != null) {
            LOG.warn("Command loop already started for the reader");
            return false;
        }
        LOG.debug("Creating a command loop for input stream: ", new Object[]{is});
        try {
            if (this.myLoopThread != null) {
                LOG.error("There is a loop thread already");
            }
            this.myLoopThread = new XPPLoop(is, String.valueOf(ReadersSupport.class) + " command loop");
            this.myLoopThread.start();
            this.myInputStream = is;
            return true;
        }
        catch (IOException | XmlPullParserException e) {
            throw new RubyDebuggerException(e);
        }
    }

    private void readingLoop(XmlPullParser xpp) throws XmlPullParserException, IOException {
        int eventType = xpp.getEventType();
        do {
            if (eventType == 2) {
                this.processElement(xpp);
            } else if (eventType == 3) {
                assert (false) : "Unexpected state: end tag " + xpp.getName();
            } else if (eventType == 4) {
                if (xpp.getText().contains(RUBY_DEBUG_PROMPT)) {
                    LOG.debug("got ruby-debug prompt message");
                } else assert (false) : "Unexpected state: got text \"" + xpp.getText() + "\"";
            } else if (eventType != 0) assert (false) : "Unexpected state: " + eventType;
            if (this.finished) break;
            eventType = xpp.next();
            if (!RubyDebuggerProxy.LOG.isDebugEnabled()) continue;
            RubyDebugTarget debugTarget = this.myProxy.getDebugTarget();
            Util.logEvent(xpp, "Received from " + debugTarget.getHost() + ":" + debugTarget.getPort() + ": ", RubyDebuggerProxy.LOG);
        } while (eventType != 1);
    }

    private void processElement(XmlPullParser xpp) throws IOException, XmlPullParserException {
        String element = xpp.getName();
        if (BREAKPOINT_ADDED_ELEMENT.equals(element)) {
            this.addedBreakpoints.add(BreakpointAddedReader.readBreakpointData(xpp));
        } else if (BREAKPOINT_DELETED_ELEMENT.equals(element)) {
            this.removedBreakpoints.add(BreakpointDeletedReader.readBreakpointNo(xpp));
        } else if (BREAKPOINT_ENABLED_ELEMENT.equals(element)) {
            this.enabledBreakpoints.add(BreakpointEnabledReader.readBreakpointNo(xpp));
        } else if (BREAKPOINT_DISABLED_ELEMENT.equals(element)) {
            this.disabledBreakpoints.add(BreakpointDisabledReader.readBreakpointNo(xpp));
        } else if (BREAKPOINT_STATE_CHANGED_ELEMENT.equals(element)) {
            this.breakpointStateChanges.add(RubyBreakpointStateChangedReader.readBreakpointData(xpp));
        } else if (BREAKPOINT_ELEMENT.equals(element) || SUSPENDED_ELEMENT.equals(element) || EXCEPTION_ELEMENT.equals(element) || UNABLE_ELEMENT.equals(element)) {
            SuspensionPoint sp = SuspensionReader.readSuspension(xpp);
            this.suspensions.add(sp);
        } else if (CONDITION_SET_ELEMENT.equals(element)) {
            this.conditionSets.add(ConditionSetReader.readBreakpointNo(xpp));
        } else if (CATCHPOINT_SET_ELEMENT.equals(element)) {
            this.catchpointSets.add(CatchpointSetReader.readExceptionClassName(xpp));
        } else if (CATCHPOINT_DELETED_ELEMENT.equals(element)) {
            this.deletedCatchpoints.add(CatchpointSetReader.readExceptionClassName(xpp));
        } else if (THREADS_ELEMENT.equals(element)) {
            this.threads.add(ThreadInfoReader.readThreads(xpp));
        } else if (FRAMES_ELEMENT.equals(element)) {
            this.frames.add(FramesReader.readFrames(xpp));
        } else if (SMART_STEP_VARIANTS_ELEMENT.equals(element)) {
            this.smartStepIntoVariants.add(StepVariantsReader.readStepVariants(xpp));
        } else if (SUSPENSION_LOCATION_ELEMENT.equals(element)) {
            this.suspensionLocations.add(SuspensionLocationReader.readSuspensionLocation(xpp));
        } else if (VARIABLES_ELEMENT.equals(element)) {
            this.variables.add(VariablesReader.readVariables(xpp));
        } else if (RECEIVER_ELEMENT.equals(element)) {
            this.receivers.add(SpecialVariableReader.readVariable(xpp, RECEIVER_ELEMENT));
        } else if (RETURN_VALUE_ELEMENT.equals(element)) {
            this.returnValues.add(SpecialVariableReader.readVariable(xpp, RETURN_VALUE_ELEMENT));
        } else if (PROCESSING_EXCEPTION_ELEMENT.equals(element)) {
            VariablesReader.logProcessingException(xpp);
            this.variables.add(new RubyVariableInfo[0]);
        } else if (FRAME_ELEMENT.equals(element)) {
            XmlStreamReader.ensureEndTag(xpp, element);
        } else if (EXPRESSION_INFO_ELEMENT.equals(element)) {
            this.expressionInfos.add(ExpressionInfoReader.readExpressionInfo(xpp));
        } else if (FILE_INCLUDED.equals(element) || FILE_EXCLUDED.equals(element) || FILE_FILTER.equals(element)) {
            XmlStreamReader.ensureEndTag(xpp, element);
        } else if (FULL_VALUE_ELEMENT.equals(element)) {
            this.fullValues.add(FullValueReader.readFullValueInfo(xpp));
        } else if (RENDERERS_STATUS_ELEMENT.equals(element)) {
            this.renderersStatuses.add(RenderersStatusReader.readRenderersStatusInfo(xpp));
        } else {
            Message message = ErrorReader.tryToReadMessageOrError(xpp, element);
            if (message != null) {
                if (message.getText().equals(FINISHED)) {
                    LOG.debug("Got 'finished' <message>, text == finished");
                    this.finished = true;
                }
            } else assert (false) : "Unexpected element: " + element + " pid = " + xpp.getAttributeValue("", "pid");
        }
    }

    private <T> T[] readInfo(BlockingQueue<T[]> queue) throws RubyDebuggerException {
        Application application = ApplicationManager.getApplication();
        if (application.isInternal() && !application.isUnitTestMode()) {
            LOG.assertTrue(!application.isReadAccessAllowed(), (Object)"do not poll ruby debugger under read lock");
        }
        try {
            T[] result = this.pollGently(queue, this.myTimeout);
            if (result == null) {
                throw new RubyDebuggerException("Unable to read information in the specified timeout [" + this.myTimeout + "s]");
            }
            return result;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RubyDebuggerException("Interruped during reading information " + String.valueOf(queue.getClass()), ex);
        }
    }

    @Nullable
    private <T> T pollGently(BlockingQueue<T> queue, long timeoutSeconds) throws InterruptedException {
        long stopTime = System.currentTimeMillis() + timeoutSeconds * 1000L;
        while (System.currentTimeMillis() < stopTime) {
            if (this.myTerminated.get()) {
                LOG.debug("ReadersSupport was terminated due polling");
                return null;
            }
            T value = queue.poll(10L, TimeUnit.MILLISECONDS);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    RubyThreadInfo[] readThreads() throws RubyDebuggerException {
        return (RubyThreadInfo[])this.readInfo(this.threads);
    }

    RubyFrameInfo[] readFrames() throws RubyDebuggerException {
        return (RubyFrameInfo[])this.readInfo(this.frames);
    }

    RubyStepVariant[] readSmartStepIntoVariants() throws RubyDebuggerException {
        return (RubyStepVariant[])this.readInfo(this.smartStepIntoVariants);
    }

    ExpressionInfo readExpressionInfo() throws RubyDebuggerException {
        return this.poll(this.expressionInfos, "expression info");
    }

    RubyVariableInfo[] readVariables() throws RubyDebuggerException {
        return (RubyVariableInfo[])this.readInfo(this.variables);
    }

    RubyVariableInfo readReceiver() throws RubyDebuggerException {
        return this.poll(this.receivers, "receivers");
    }

    RubyVariableInfo readReturnValue() throws RubyDebuggerException {
        return this.poll(this.returnValues, "return values");
    }

    RubyFullValueInfo readFullValue() throws RubyDebuggerException {
        return this.poll(this.fullValues, "full values");
    }

    @NotNull
    RubyRenderersStatusInfo readRenderersStatus() throws RubyDebuggerException {
        RubyRenderersStatusInfo rubyRenderersStatusInfo = this.poll(this.renderersStatuses, "renderers statuses");
        if (rubyRenderersStatusInfo == null) {
            ReadersSupport.$$$reportNull$$$0(1);
        }
        return rubyRenderersStatusInfo;
    }

    @NotNull
    @NotNull Pair<@NotNull Integer, @NotNull ThreeState> readAddedBreakpointData() throws RubyDebuggerException {
        Pair<Integer, ThreeState> pair = this.poll(this.addedBreakpoints, "added breakpoint number");
        if (pair == null) {
            ReadersSupport.$$$reportNull$$$0(2);
        }
        return pair;
    }

    int readEnabledBreakpointNo(int breakpointID) throws RubyDebuggerException {
        int enabledID = this.poll(this.enabledBreakpoints, "breakpoint number of the enabled breakpoint (" + breakpointID + ")");
        if (enabledID != breakpointID) {
            throw new RubyDebuggerException("Unexpected breakpoint removed. Received id: " + enabledID + ", expected: " + breakpointID);
        }
        return enabledID;
    }

    int readDisabledBreakpointNo(int breakpointID) throws RubyDebuggerException {
        int disabledID = this.poll(this.disabledBreakpoints, "breakpoint number of the disabled breakpoint (" + breakpointID + ")");
        if (disabledID != breakpointID) {
            throw new RubyDebuggerException("Unexpected breakpoint removed. Received id: " + disabledID + ", expected: " + breakpointID);
        }
        return disabledID;
    }

    int readConditionSet() throws RubyDebuggerException {
        return this.poll(this.conditionSets, "breakpoint number of the set condition");
    }

    String readCatchpointSet() throws RubyDebuggerException {
        return this.poll(this.catchpointSets, "catchpoint set");
    }

    String readCatchpointDeleted() throws RubyDebuggerException {
        return this.poll(this.deletedCatchpoints, "catchpoint deleted");
    }

    int waitForRemovedBreakpoint(int breakpointID) throws RubyDebuggerException {
        int removedID = this.poll(this.removedBreakpoints, "breakpoint number of the removed breakpoint (" + breakpointID + ")");
        if (removedID != breakpointID) {
            throw new RubyDebuggerException("Unexpected breakpoint removed. Received id: " + removedID + ", expected: " + breakpointID);
        }
        return removedID;
    }

    private <T> T poll(BlockingQueue<T> queue, String toRead) throws RubyDebuggerException {
        Application application = ApplicationManager.getApplication();
        if (application.isInternal() && !application.isUnitTestMode()) {
            LOG.assertTrue(!application.isReadAccessAllowed(), (Object)"do not poll ruby debugger under read lock");
        }
        try {
            T t = this.pollGently(queue, this.myTimeout);
            if (t == null) {
                throw new RubyDebuggerException("Unable to read " + toRead + " in the specified timeout [" + this.myTimeout + "s]");
            }
            return t;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RubyDebuggerException("Interruped during reading " + toRead + " (timeout: " + this.myTimeout + ")", ex);
        }
    }

    @Nullable
    SuspensionPoint readSuspension() {
        try {
            SuspensionPoint value;
            do {
                if (!this.myTerminated.get()) continue;
                LOG.debug("Readers support was terminated on polling");
                return null;
            } while ((value = this.suspensions.poll(10L, TimeUnit.MILLISECONDS)) == null);
            return value;
        }
        catch (InterruptedException ex) {
            LOG.debug("Interrupted exception during reading suspension point", new Object[]{ex.getMessage()});
            return null;
        }
    }

    @Nullable Pair<@NotNull Integer, @NotNull ThreeState> pollBreakpointState() {
        return (Pair)this.breakpointStateChanges.poll();
    }

    boolean isUnexpectedFail() {
        return this.unexpectedFail;
    }

    public RubySuspensionLocation readSuspensionLocation() {
        try {
            RubySuspensionLocation suspensionLocation = this.pollGently(this.suspensionLocations, 5L);
            if (suspensionLocation == null) {
                LOG.warn("Timeout reading suspension location.");
            }
            return suspensionLocation;
        }
        catch (InterruptedException ex) {
            LOG.error("Interrupted during reading suspension location", (Throwable)ex);
            return null;
        }
    }

    private static XmlPullParser getXpp(InputStream is) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance("org.kxml2.io.KXmlParser,org.kxml2.io.KXmlSerializer", null);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput(new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)));
        return xpp;
    }

    synchronized void terminate() {
        LOG.debug("Terminating readers support");
        this.myTerminated.set(true);
        if (this.myInputStream != null) {
            try {
                this.myInputStream.close();
                this.myInputStream = null;
            }
            catch (IOException e) {
                LOG.warn("Error closing input stream for ReadersSupport: " + e.getMessage());
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myLoopThread != null) {
            LOG.debug("Waiting for command loop to finish...");
            long startTime = System.currentTimeMillis();
            while (this.myLoopThread != null && this.myLoopThread.isAlive()) {
                try {
                    this.myLoopThread.join(10L);
                    if (!this.myLoopThread.isAlive()) {
                        this.myLoopThread = null;
                        continue;
                    }
                    if (System.currentTimeMillis() - startTime <= 10000L) continue;
                    LOG.error("Command loop didn't finished in 10 seconds");
                    this.myLoopThread = null;
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted while waiting command loop to finish");
                    this.myLoopThread = null;
                }
            }
        }
        LOG.debug("Terminated readers support");
    }

    public String toString() {
        return "ReadersSupport{myTimeout=" + this.myTimeout + ", myTerminated=" + String.valueOf(this.myTerminated) + ", threads=" + String.valueOf(this.threads) + ", frames=" + String.valueOf(this.frames) + ", smartStepIntoVariants=" + String.valueOf(this.smartStepIntoVariants) + ", variables=" + String.valueOf(this.variables) + ", receivers=" + String.valueOf(this.receivers) + ", returnValues=" + String.valueOf(this.returnValues) + ", fullValues=" + String.valueOf(this.fullValues) + ", renderersStatuses=" + String.valueOf(this.renderersStatuses) + ", suspensions=" + String.valueOf(this.suspensions) + ", addedBreakpoints=" + String.valueOf(this.addedBreakpoints) + ", removedBreakpoints=" + String.valueOf(this.removedBreakpoints) + ", enabledBreakpoints=" + String.valueOf(this.enabledBreakpoints) + ", disabledBreakpoints=" + String.valueOf(this.disabledBreakpoints) + ", breakpointStateChanges=" + String.valueOf(this.breakpointStateChanges) + ", conditionSets=" + String.valueOf(this.conditionSets) + ", catchpointSets=" + String.valueOf(this.catchpointSets) + ", deletedCatchpoints=" + String.valueOf(this.deletedCatchpoints) + ", expressionInfos=" + String.valueOf(this.expressionInfos) + ", suspensionLocations=" + String.valueOf(this.suspensionLocations) + ", finished=" + this.finished + ", unexpectedFail=" + this.unexpectedFail + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/rubyforge/debugcommons/ReadersSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/rubyforge/debugcommons/ReadersSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readRenderersStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readAddedBreakpointData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private class XPPLoop
    extends Thread {
        private final XmlPullParser xpp;
        private final InputStream is;

        XPPLoop(InputStream is, String loopName) throws XmlPullParserException, IOException {
            super(loopName);
            this.is = is;
            this.xpp = ReadersSupport.getXpp(is);
        }

        @Override
        public void run() {
            try {
                LOG.debug("Starting ReadersSupport readloop: ", new Object[]{this.getName()});
                ReadersSupport.this.readingLoop(this.xpp);
                LOG.debug("ReadersSupport readloop [", new Object[]{this.getName(), "] successfully finished."});
            }
            catch (IOException e) {
                LOG.debug("SocketException. Loop [", new Object[]{this.getName(), "]: ", e.getMessage()});
                LOG.debug(e.getMessage(), (Throwable)e);
                ReadersSupport.this.unexpectedFail = true;
            }
            catch (XmlPullParserException e) {
                LOG.error("Exception during ReadersSupport loop [" + this.getName() + "]", (Throwable)e);
                ReadersSupport.this.unexpectedFail = true;
            }
            finally {
                ReadersSupport.this.suspensions.add(SuspensionPoint.END);
                try {
                    this.is.close();
                }
                catch (IOException e) {
                    LOG.error("Cannot close socket's input stream", (Throwable)e);
                }
            }
        }
    }
}

