/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 66445589310641L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1849790910 - (char)-20920, -1849790910 - -((char)-20868), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1849790910 - (char)-20921, -1849659840 + -((char)-2335), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 105261578393651L;
                thread = Thread.currentThread();
                String[] stringArray = SshAgentIpcService.v();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (stringArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-519954690 - -30968, 519954690 - (char)-31920, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-519954690 - -30969, 519954690 - (char)-17623, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-519954690 - -30962, 519954690 - (char)-15669, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 30380096365753L;
                Object object = this.lock;
                String[] stringArray = SshAgentIpcService.v();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1792644390 + -((char)-16545), -1792644390 + -((char)-12936), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1792644390 + -((char)-16542), -1792644390 + -((char)-9040), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1792644390 + -((char)-16543), -1792644390 + -((char)-18129), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (stringArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1792644390 + -((char)-16540), 1792644390 + (char)-24703, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1792644390 + -((char)-16541), -1792644390 + -((char)-11654), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1792644390 + -((char)-16538), -1792644390 + -((char)-17610), (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1792644390 + -((char)-16540), 1792644390 + (char)-24703, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1792644390 + -((char)-16539), -1792644390 + -((char)-31073), (int)l2));
            if (ActionTimestamp.v() == null) {
                SshAgentIpcService.v(new String[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String[] stringArray;
                block6: {
                    long l2 = 114360721547399L;
                    stringArray = SshAgentIpcService.v();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (stringArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (stringArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String[] stringArray;
        long l2;
        block27: {
            block28: {
                l2 = 105924243460033L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            stringArray = SshAgentIpcService.v();
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (stringArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1760007960 + -26846, -1760007960 + -13465, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1760007960 + -26842, 1760007960 + 2247, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -26845, 1760007960 + 10768, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1760007960 + -26842, 1760007960 + 2247, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -26848, 1760007960 + 22919, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1760007960 + -26846, -1760007960 + -13465, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1760007960 + -26842, 1760007960 + 2247, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -26847, -1760007960 + -8215, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (stringArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1760007960 + -26846, -1760007960 + -13465, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1760007960 + -26842, 1760007960 + 2247, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -26834, 1760007960 + 7452, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1760007960 + -26842, 1760007960 + 2247, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -26833, 1760007960 + 1996, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (stringArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1760007960 + -26842, 1760007960 + 2247, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -26848, 1760007960 + 22919, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1760007960 + -26846, -1760007960 + -13465, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1760007960 + -26842, 1760007960 + 2247, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1760007960 + -26836, -1760007960 + -19192, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 54090871271951L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(53083350 + (char)-8735, -53083350 + -((char)-10448), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 30810164669383L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1930661100 + -((char)-4202), 1930661100 + (char)-24379, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "Ab\u0095<d\u00bdC\u00b0\u00f6\u00f1e\u0080\u00db\u00ad\u0013M\b\u009c\u00e2\u0014\u001f\u00f0^h\u0006\u00f5r<Rf4\u00a63\u0090\u00cfa~\u00df+\u0013";
                        var4_3 = "Ab\u0095<d\u00bdC\u00b0\u00f6\u00f1e\u0080\u00db\u00ad\u0013M\b\u009c\u00e2\u0014\u001f\u00f0^h\u0006\u00f5r<Rf4\u00a63\u0090\u00cfa~\u00df+\u0013".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 123;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 122;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 110;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 50;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 41;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 115;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 27;
                                        break;
                                    }
                                    default: {
                                        v11 = 99;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x28B8) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 96;
                            case 1 -> 201;
                            case 2 -> 138;
                            case 3 -> 244;
                            case 4 -> 187;
                            case 5 -> 158;
                            case 6 -> 206;
                            case 7 -> 59;
                            case 8 -> 57;
                            case 9 -> 132;
                            case 10 -> 204;
                            case 11 -> 232;
                            case 12 -> 122;
                            case 13 -> 91;
                            case 14 -> 166;
                            case 15 -> 145;
                            case 16 -> 119;
                            case 17 -> 164;
                            case 18 -> 36;
                            case 19 -> 245;
                            case 20 -> 234;
                            case 21 -> 208;
                            case 22 -> 224;
                            case 23 -> 214;
                            case 24 -> 74;
                            case 25 -> 178;
                            case 26 -> 63;
                            case 27 -> 44;
                            case 28 -> 228;
                            case 29 -> 102;
                            case 30 -> 6;
                            case 31 -> 68;
                            case 32 -> 20;
                            case 33 -> 43;
                            case 34 -> 246;
                            case 35 -> 176;
                            case 36 -> 18;
                            case 37 -> 42;
                            case 38 -> 243;
                            case 39 -> 31;
                            case 40 -> 28;
                            case 41 -> 142;
                            case 42 -> 233;
                            case 43 -> 37;
                            case 44 -> 230;
                            case 45 -> 253;
                            case 46 -> 193;
                            case 47 -> 2;
                            case 48 -> 105;
                            case 49 -> 65;
                            case 50 -> 60;
                            case 51 -> 248;
                            case 52 -> 33;
                            case 53 -> 13;
                            case 54 -> 115;
                            case 55 -> 88;
                            case 56 -> 226;
                            case 57 -> 106;
                            case 58 -> 146;
                            case 59 -> 217;
                            case 60 -> 210;
                            case 61 -> 25;
                            case 62 -> 5;
                            case 63 -> 167;
                            case 64 -> 199;
                            case 65 -> 98;
                            case 66 -> 184;
                            case 67 -> 83;
                            case 68 -> 140;
                            case 69 -> 66;
                            case 70 -> 62;
                            case 71 -> 116;
                            case 72 -> 175;
                            case 73 -> 211;
                            case 74 -> 229;
                            case 75 -> 118;
                            case 76 -> 48;
                            case 77 -> 137;
                            case 78 -> 174;
                            case 79 -> 64;
                            case 80 -> 254;
                            case 81 -> 92;
                            case 82 -> 154;
                            case 83 -> 114;
                            case 84 -> 148;
                            case 85 -> 71;
                            case 86 -> 222;
                            case 87 -> 250;
                            case 88 -> 109;
                            case 89 -> 255;
                            case 90 -> 162;
                            case 91 -> 101;
                            case 92 -> 242;
                            case 93 -> 9;
                            case 94 -> 7;
                            case 95 -> 221;
                            case 96 -> 157;
                            case 97 -> 8;
                            case 98 -> 4;
                            case 99 -> 121;
                            case 100 -> 203;
                            case 101 -> 30;
                            case 102 -> 10;
                            case 103 -> 188;
                            case 104 -> 156;
                            case 105 -> 14;
                            case 106 -> 84;
                            case 107 -> 186;
                            case 108 -> 73;
                            case 109 -> 56;
                            case 110 -> 51;
                            case 111 -> 11;
                            case 112 -> 135;
                            case 113 -> 227;
                            case 114 -> 21;
                            case 115 -> 87;
                            case 116 -> 215;
                            case 117 -> 252;
                            case 118 -> 86;
                            case 119 -> 205;
                            case 120 -> 155;
                            case 121 -> 216;
                            case 122 -> 133;
                            case 123 -> 247;
                            case 124 -> 236;
                            case 125 -> 82;
                            case 126 -> 197;
                            case 127 -> 237;
                            case 128 -> 125;
                            case 129 -> 93;
                            case 130 -> 241;
                            case 131 -> 249;
                            case 132 -> 72;
                            case 133 -> 131;
                            case 134 -> 192;
                            case 135 -> 107;
                            case 136 -> 136;
                            case 137 -> 143;
                            case 138 -> 200;
                            case 139 -> 165;
                            case 140 -> 182;
                            case 141 -> 40;
                            case 142 -> 144;
                            case 143 -> 213;
                            case 144 -> 111;
                            case 145 -> 168;
                            case 146 -> 151;
                            case 147 -> 50;
                            case 148 -> 171;
                            case 149 -> 108;
                            case 150 -> 219;
                            case 151 -> 99;
                            case 152 -> 103;
                            case 153 -> 196;
                            case 154 -> 172;
                            case 155 -> 181;
                            case 156 -> 169;
                            case 157 -> 195;
                            case 158 -> 39;
                            case 159 -> 173;
                            case 160 -> 15;
                            case 161 -> 79;
                            case 162 -> 207;
                            case 163 -> 139;
                            case 164 -> 251;
                            case 165 -> 189;
                            case 166 -> 67;
                            case 167 -> 112;
                            case 168 -> 177;
                            case 169 -> 77;
                            case 170 -> 80;
                            case 171 -> 160;
                            case 172 -> 180;
                            case 173 -> 23;
                            case 174 -> 240;
                            case 175 -> 16;
                            case 176 -> 54;
                            case 177 -> 41;
                            case 178 -> 223;
                            case 179 -> 212;
                            case 180 -> 45;
                            case 181 -> 26;
                            case 182 -> 61;
                            case 183 -> 124;
                            case 184 -> 76;
                            case 185 -> 161;
                            case 186 -> 183;
                            case 187 -> 152;
                            case 188 -> 159;
                            case 189 -> 235;
                            case 190 -> 0;
                            case 191 -> 97;
                            case 192 -> 95;
                            case 193 -> 3;
                            case 194 -> 89;
                            case 195 -> 35;
                            case 196 -> 69;
                            case 197 -> 52;
                            case 198 -> 90;
                            case 199 -> 104;
                            case 200 -> 46;
                            case 201 -> 94;
                            case 202 -> 218;
                            case 203 -> 120;
                            case 204 -> 225;
                            case 205 -> 190;
                            case 206 -> 85;
                            case 207 -> 100;
                            case 208 -> 147;
                            case 209 -> 58;
                            case 210 -> 53;
                            case 211 -> 150;
                            case 212 -> 141;
                            case 213 -> 12;
                            case 214 -> 32;
                            case 215 -> 55;
                            case 216 -> 209;
                            case 217 -> 27;
                            case 218 -> 19;
                            case 219 -> 49;
                            case 220 -> 70;
                            case 221 -> 1;
                            case 222 -> 220;
                            case 223 -> 17;
                            case 224 -> 130;
                            case 225 -> 153;
                            case 226 -> 75;
                            case 227 -> 134;
                            case 228 -> 38;
                            case 229 -> 126;
                            case 230 -> 149;
                            case 231 -> 129;
                            case 232 -> 22;
                            case 233 -> 127;
                            case 234 -> 202;
                            case 235 -> 110;
                            case 236 -> 231;
                            case 237 -> 191;
                            case 238 -> 128;
                            case 239 -> 194;
                            case 240 -> 81;
                            case 241 -> 238;
                            case 242 -> 113;
                            case 243 -> 179;
                            case 244 -> 123;
                            case 245 -> 163;
                            case 246 -> 34;
                            case 247 -> 24;
                            case 248 -> 117;
                            case 249 -> 29;
                            case 250 -> 185;
                            case 251 -> 78;
                            case 252 -> 47;
                            case 253 -> 239;
                            case 254 -> 170;
                            default -> 198;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (stringArray != null) {
                ActionTimestamp.v(new int[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 130483667426988L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String[] stringArray = SshAgentIpcService.v();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (stringArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1734056100 - (char)-14531, 1734056100 - (char)-19582, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1734056100 - (char)-14527, -1734056100 - -((char)-6314), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1734056100 - (char)-14548, 1733925030 + (char)-1128, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1734056100 - (char)-14531, 1734056100 - (char)-19582, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1734056100 - (char)-14527, -1734056100 - -((char)-6314), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1734056100 - (char)-14555, 1733925030 + (char)-5612, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String[] stringArray;
                    block13: {
                        long l2 = 131721373379621L;
                        String[] stringArray2 = SshAgentIpcService.v();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(978699690 - (char)-7757, 978699690 - (char)-12410, (int)l2));
                        stringArray = stringArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (stringArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (stringArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(978699690 - (char)-7754, -978699690 - -((char)-4867), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (stringArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String[] stringArray;
        long l2;
        block25: {
            block26: {
                l2 = 61760876190368L;
                String[] stringArray2 = SshAgentIpcService.v();
                this.assertConnectionThread();
                Object object2 = this.lock;
                stringArray = stringArray2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (stringArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (stringArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(753521430 - 15787, 753521430 - 12776, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(753521430 - 15783, -753521430 + -8748, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(753521430 - 15782, 753521430 - 2854, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(753521430 - 15783, -753521430 + -8748, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(753521430 - 15789, -753521430 - -14612, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(753521430 - 15787, 753521430 - 12776, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(753521430 - 15783, -753521430 + -8748, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(753521430 - 15767, -753521430 + -11311, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (stringArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(753521430 - 15787, 753521430 - 12776, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(753521430 - 15783, -753521430 + -8748, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(753521430 - 15768, -753521430 + -8379, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (stringArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(753521430 - 15787, 753521430 - 12776, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(753521430 - 15783, -753521430 + -8748, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(753521430 - 15769, 753521430 - 4291, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String[] stringArray;
                block16: {
                    l2 = 59688297912984L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                stringArray = SshAgentIpcService.v();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (stringArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28281), -1137425460 - -((char)-25270), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28277), 1137425460 - 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28296), -1137425460 - -((char)-27301), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28297), 1137425460 - (char)-31817, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28281), -1137425460 - -((char)-25270), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28277), 1137425460 - 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28298), 1137425460 - 32632, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (stringArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (stringArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28281), -1137425460 - -((char)-25270), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28277), 1137425460 - 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28299), -1137425460 - -((char)-18357), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28281), -1137425460 - -((char)-25270), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28277), 1137425460 - 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28300), 1137425460 - (char)-30913, (int)l2));
                    if (stringArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28281), -1137425460 - -((char)-25270), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28277), 1137425460 - 29102, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28237), 1137425460 - 25515, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1137425460 - -((char)-28238), -1137425460 - -19098, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00cc]`IJ\u00dc9x\u0014c<\u00ad\u0082\r-~\\\u0082\u0089\u009ct\u0005Y\u00fcY\u009d8\u00e7\u00da\u0006\u0019\u00b7\u00da\u0014w6\u0018\u0099V\u0092\u00ffhG\u00d0\u00d1\u009fE0\u009d\u00f6\u009b\u00d0\u0083\u00b1\nL\u0001j\u008c\u001a\u0092\t\u00c0\u00a5'0\u00b5!sU\u00d7\u0005e)U\u00c7\u009c\b\u00a1;\u00cd\u00f4\u00adM\u00c3\u00a8\u0014\u008eWht\u00d8\u00fb\u00f1\u0011\u001d\u00fd\u00c4ND\u00bdo(\u00fd\u00c5\u0012'\u0005\u00b4\u00f4o|\u00db\u001e\u00fb\u00a9\u0093\u00b3\u00d9\nD\u0002\u00a8+\u009d\u00d7\u000f\u00f2M\u00ca\u00e3\u00b2\u00d4\u00e2\u00d5\u00df\u00e15\u00a7F6\u00c5N\u00ce\u0010\u0012\u0015J\u00e1\u00b5r?\u00f4\u00baGR\u00a7\u00f0\u00a9\u001d>\tPc\u00e3\u00f9~?,\t\u00d2\u0010\u00cf\u0091\u00f1q\u00c2`\u00d1\u00b6g\u000f\u00e9\u00ae\u0087\u0088\u00f3\u001a?\u0005\u0091D\u00b4.\u00e3?S\u00b6\u00d0\u001bS`\u0094\u009d?<iR\\\u008bZQ\u00e3\u00a1t\u00fb7\u00c0\u00c6hM\u00c7\u00ab\u00ee\u00d3\u0086f`\u0087\u00de\u0005\u00d7,le)&\u00d9\u0099\u00b5\u00ea\u001fJ\u0003G|\u00b9(\u0088\u00e3d\u00e5\b\u00f8\u00e6\u00e6O\u00c8:oF\f\u0003=\u0089/8T\u009f\u008c\u0087\u0000\u00a7KF\u00f2\u00dd\u00b73\u00ff\u00d7g\u00fc\u0098\u0002N\u00cf\\\u000f\u0005j\u00d3\u00a4\u00afJ&\u00ca\u00e7\u00c3A[\u0014\u00d9\u00822\u001a\u00ef\u00b5Ib\u00ae\u00cd\u0084\u00a2\u001f\u0015\u0003%\u0017\u00ec\u0087m\u0007\u00b6E>\u00db\u0081\u00fa\u00c6J[lZ\u008e\u009e\u00cd\u0016\u0095#\u00e1>\u00d5\u00b0\u00c5\u001f\u00ec\u00b1q\u00b0\u0085j\u00cf\u000e\u00d9\u00aa\u00b3\u00e7\u00ca\u00e9\u00fe\u0018\u00ee\u0000\b~\u0085\u00cc<\u00fc}\u00afz4\u00da\u0001\u0013\u000b\u00e86\u00f4N\u0097xj\t9\u00bcz\u0015}tF\u0005\u00c6y\u00acT\u00df\u00f7n\u0087\u00cfICZ\u00a2\u00dc\\\u009c9)\u00d4\u007fvieQ\u00d3iZF\u00c3z\u00c0P!*J\u00ceG\u0000\u009c{\u00d9\u0012\u00ae;\u00d7\u00de@\u00a8\u00c2\u0082PA\u00b8\"\u0088\b\u0081'\u00d2\u0007\u00b8:\u00f1\u00db\u00b1Z\u00d2\u0007\u00a2\u00f4\u00d6n\u00b2\u0003\u00a4(N\u00ffiX6\u001dO\u00c7\u00b9D\u0095\f)\u001f^@\u00a2.\u00f4_\u008b\u00aeTc\u008f\u00a9E\u00f7%\u00ed\u00b53E\u001c\u0084$\u00b5\u00b5\u00b5c\u000f\u00a7\u00d9\u001a\u00b5\u00b0\u00cc:>b\u00f6O\u000b\u00d2\u00ab\u00bf\"\u0096~>IlU\u00f2\u00e9~VGxS\u001c7mc\u000f\u00e8z\u00834\u009a\u00abUXel2\u00cc.\t\u00e3\u00c3\u000e\u0098\u0082\u00fd\u00deL\u00a1\u00a5\u0093\u0091C1\u00bd\u0011w\u001b\u00a2\u00ef\u00bdv\u00bf\u0001N\u00db\u00bb\u00cd\u00f9mX[p\u0093#z]H\u000eFXCF(R\n\u00e5\u0007\u0091l.\u00a6\u00af\u0005,t\u0018\t\u00b6\u00c8P\u0010y\u009a\u008a?.\u00ab\u008e\u00abt\u00f2W\u0004\u00e3n\u0002\u0010D\u00c0P)\u0002Z\u00ac\u00cd>\u00c5\u00b8\u00fb7\u0014n0q\u0010\u0088Y\u0001\u00d5\u00f1\u00a6p\u00bf\r\u0086A;\u00b72\u001fi\u0092+\u007f\u00aa\u0088\u00cbP\u0011\u009a\u0004\u00b1\t\u007f\u000f\u0006j\u00c8\u0082\u00ac\u00e5\u007f";
                var4_3 = "\u00cc]`IJ\u00dc9x\u0014c<\u00ad\u0082\r-~\\\u0082\u0089\u009ct\u0005Y\u00fcY\u009d8\u00e7\u00da\u0006\u0019\u00b7\u00da\u0014w6\u0018\u0099V\u0092\u00ffhG\u00d0\u00d1\u009fE0\u009d\u00f6\u009b\u00d0\u0083\u00b1\nL\u0001j\u008c\u001a\u0092\t\u00c0\u00a5'0\u00b5!sU\u00d7\u0005e)U\u00c7\u009c\b\u00a1;\u00cd\u00f4\u00adM\u00c3\u00a8\u0014\u008eWht\u00d8\u00fb\u00f1\u0011\u001d\u00fd\u00c4ND\u00bdo(\u00fd\u00c5\u0012'\u0005\u00b4\u00f4o|\u00db\u001e\u00fb\u00a9\u0093\u00b3\u00d9\nD\u0002\u00a8+\u009d\u00d7\u000f\u00f2M\u00ca\u00e3\u00b2\u00d4\u00e2\u00d5\u00df\u00e15\u00a7F6\u00c5N\u00ce\u0010\u0012\u0015J\u00e1\u00b5r?\u00f4\u00baGR\u00a7\u00f0\u00a9\u001d>\tPc\u00e3\u00f9~?,\t\u00d2\u0010\u00cf\u0091\u00f1q\u00c2`\u00d1\u00b6g\u000f\u00e9\u00ae\u0087\u0088\u00f3\u001a?\u0005\u0091D\u00b4.\u00e3?S\u00b6\u00d0\u001bS`\u0094\u009d?<iR\\\u008bZQ\u00e3\u00a1t\u00fb7\u00c0\u00c6hM\u00c7\u00ab\u00ee\u00d3\u0086f`\u0087\u00de\u0005\u00d7,le)&\u00d9\u0099\u00b5\u00ea\u001fJ\u0003G|\u00b9(\u0088\u00e3d\u00e5\b\u00f8\u00e6\u00e6O\u00c8:oF\f\u0003=\u0089/8T\u009f\u008c\u0087\u0000\u00a7KF\u00f2\u00dd\u00b73\u00ff\u00d7g\u00fc\u0098\u0002N\u00cf\\\u000f\u0005j\u00d3\u00a4\u00afJ&\u00ca\u00e7\u00c3A[\u0014\u00d9\u00822\u001a\u00ef\u00b5Ib\u00ae\u00cd\u0084\u00a2\u001f\u0015\u0003%\u0017\u00ec\u0087m\u0007\u00b6E>\u00db\u0081\u00fa\u00c6J[lZ\u008e\u009e\u00cd\u0016\u0095#\u00e1>\u00d5\u00b0\u00c5\u001f\u00ec\u00b1q\u00b0\u0085j\u00cf\u000e\u00d9\u00aa\u00b3\u00e7\u00ca\u00e9\u00fe\u0018\u00ee\u0000\b~\u0085\u00cc<\u00fc}\u00afz4\u00da\u0001\u0013\u000b\u00e86\u00f4N\u0097xj\t9\u00bcz\u0015}tF\u0005\u00c6y\u00acT\u00df\u00f7n\u0087\u00cfICZ\u00a2\u00dc\\\u009c9)\u00d4\u007fvieQ\u00d3iZF\u00c3z\u00c0P!*J\u00ceG\u0000\u009c{\u00d9\u0012\u00ae;\u00d7\u00de@\u00a8\u00c2\u0082PA\u00b8\"\u0088\b\u0081'\u00d2\u0007\u00b8:\u00f1\u00db\u00b1Z\u00d2\u0007\u00a2\u00f4\u00d6n\u00b2\u0003\u00a4(N\u00ffiX6\u001dO\u00c7\u00b9D\u0095\f)\u001f^@\u00a2.\u00f4_\u008b\u00aeTc\u008f\u00a9E\u00f7%\u00ed\u00b53E\u001c\u0084$\u00b5\u00b5\u00b5c\u000f\u00a7\u00d9\u001a\u00b5\u00b0\u00cc:>b\u00f6O\u000b\u00d2\u00ab\u00bf\"\u0096~>IlU\u00f2\u00e9~VGxS\u001c7mc\u000f\u00e8z\u00834\u009a\u00abUXel2\u00cc.\t\u00e3\u00c3\u000e\u0098\u0082\u00fd\u00deL\u00a1\u00a5\u0093\u0091C1\u00bd\u0011w\u001b\u00a2\u00ef\u00bdv\u00bf\u0001N\u00db\u00bb\u00cd\u00f9mX[p\u0093#z]H\u000eFXCF(R\n\u00e5\u0007\u0091l.\u00a6\u00af\u0005,t\u0018\t\u00b6\u00c8P\u0010y\u009a\u008a?.\u00ab\u008e\u00abt\u00f2W\u0004\u00e3n\u0002\u0010D\u00c0P)\u0002Z\u00ac\u00cd>\u00c5\u00b8\u00fb7\u0014n0q\u0010\u0088Y\u0001\u00d5\u00f1\u00a6p\u00bf\r\u0086A;\u00b72\u001fi\u0092+\u007f\u00aa\u0088\u00cbP\u0011\u009a\u0004\u00b1\t\u007f\u000f\u0006j\u00c8\u0082\u00ac\u00e5\u007f".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 103;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0014\u0014F,K\u00d1>Q\u00cfiY\u00b7\u00bf\u00c8yj\u0017\u0097KBZ4\u0093\u0001\u0011\u00ff\u0004\u00c7\u00d1\u0014y{\u00c6BH\u001d\u00fer\u00bad\u00b3\u00e1\u00c8\u00c3m\"\u0087\u007f\u008c\u001a";
                    var4_3 = "\u0014\u0014F,K\u00d1>Q\u00cfiY\u00b7\u00bf\u00c8yj\u0017\u0097KBZ4\u0093\u0001\u0011\u00ff\u0004\u00c7\u00d1\u0014y{\u00c6BH\u001d\u00fer\u00bad\u00b3\u00e1\u00c8\u00c3m\"\u0087\u007f\u008c\u001a".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 110;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 2;
                            break;
                        }
                        case 1: {
                            v15 = 105;
                            break;
                        }
                        case 2: {
                            v15 = 60;
                            break;
                        }
                        case 3: {
                            v15 = 101;
                            break;
                        }
                        case 4: {
                            v15 = 100;
                            break;
                        }
                        case 5: {
                            v15 = 122;
                            break;
                        }
                        default: {
                            v15 = 89;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFF8FC7) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 107;
                case 1 -> 120;
                case 2 -> 151;
                case 3 -> 121;
                case 4 -> 18;
                case 5 -> 216;
                case 6 -> 159;
                case 7 -> 228;
                case 8 -> 55;
                case 9 -> 187;
                case 10 -> 254;
                case 11 -> 219;
                case 12 -> 39;
                case 13 -> 191;
                case 14 -> 105;
                case 15 -> 142;
                case 16 -> 231;
                case 17 -> 189;
                case 18 -> 19;
                case 19 -> 233;
                case 20 -> 32;
                case 21 -> 162;
                case 22 -> 199;
                case 23 -> 5;
                case 24 -> 112;
                case 25 -> 75;
                case 26 -> 77;
                case 27 -> 1;
                case 28 -> 2;
                case 29 -> 164;
                case 30 -> 29;
                case 31 -> 212;
                case 32 -> 177;
                case 33 -> 137;
                case 34 -> 152;
                case 35 -> 56;
                case 36 -> 213;
                case 37 -> 97;
                case 38 -> 37;
                case 39 -> 141;
                case 40 -> 47;
                case 41 -> 128;
                case 42 -> 8;
                case 43 -> 69;
                case 44 -> 110;
                case 45 -> 109;
                case 46 -> 156;
                case 47 -> 24;
                case 48 -> 182;
                case 49 -> 12;
                case 50 -> 165;
                case 51 -> 41;
                case 52 -> 52;
                case 53 -> 115;
                case 54 -> 230;
                case 55 -> 176;
                case 56 -> 241;
                case 57 -> 104;
                case 58 -> 174;
                case 59 -> 68;
                case 60 -> 21;
                case 61 -> 78;
                case 62 -> 248;
                case 63 -> 188;
                case 64 -> 88;
                case 65 -> 154;
                case 66 -> 240;
                case 67 -> 26;
                case 68 -> 63;
                case 69 -> 224;
                case 70 -> 140;
                case 71 -> 148;
                case 72 -> 244;
                case 73 -> 27;
                case 74 -> 130;
                case 75 -> 76;
                case 76 -> 234;
                case 77 -> 153;
                case 78 -> 200;
                case 79 -> 144;
                case 80 -> 65;
                case 81 -> 195;
                case 82 -> 211;
                case 83 -> 87;
                case 84 -> 92;
                case 85 -> 161;
                case 86 -> 89;
                case 87 -> 86;
                case 88 -> 59;
                case 89 -> 113;
                case 90 -> 73;
                case 91 -> 172;
                case 92 -> 150;
                case 93 -> 51;
                case 94 -> 100;
                case 95 -> 226;
                case 96 -> 143;
                case 97 -> 197;
                case 98 -> 239;
                case 99 -> 196;
                case 100 -> 145;
                case 101 -> 93;
                case 102 -> 180;
                case 103 -> 50;
                case 104 -> 101;
                case 105 -> 10;
                case 106 -> 192;
                case 107 -> 222;
                case 108 -> 206;
                case 109 -> 168;
                case 110 -> 201;
                case 111 -> 61;
                case 112 -> 70;
                case 113 -> 157;
                case 114 -> 136;
                case 115 -> 245;
                case 116 -> 218;
                case 117 -> 249;
                case 118 -> 9;
                case 119 -> 13;
                case 120 -> 207;
                case 121 -> 229;
                case 122 -> 108;
                case 123 -> 129;
                case 124 -> 117;
                case 125 -> 43;
                case 126 -> 98;
                case 127 -> 185;
                case 128 -> 57;
                case 129 -> 34;
                case 130 -> 237;
                case 131 -> 15;
                case 132 -> 238;
                case 133 -> 83;
                case 134 -> 209;
                case 135 -> 60;
                case 136 -> 22;
                case 137 -> 114;
                case 138 -> 178;
                case 139 -> 85;
                case 140 -> 255;
                case 141 -> 122;
                case 142 -> 118;
                case 143 -> 138;
                case 144 -> 202;
                case 145 -> 210;
                case 146 -> 171;
                case 147 -> 28;
                case 148 -> 208;
                case 149 -> 173;
                case 150 -> 243;
                case 151 -> 72;
                case 152 -> 64;
                case 153 -> 126;
                case 154 -> 45;
                case 155 -> 124;
                case 156 -> 217;
                case 157 -> 183;
                case 158 -> 53;
                case 159 -> 186;
                case 160 -> 102;
                case 161 -> 119;
                case 162 -> 33;
                case 163 -> 116;
                case 164 -> 175;
                case 165 -> 123;
                case 166 -> 133;
                case 167 -> 220;
                case 168 -> 253;
                case 169 -> 54;
                case 170 -> 193;
                case 171 -> 81;
                case 172 -> 17;
                case 173 -> 94;
                case 174 -> 246;
                case 175 -> 23;
                case 176 -> 205;
                case 177 -> 139;
                case 178 -> 147;
                case 179 -> 225;
                case 180 -> 103;
                case 181 -> 31;
                case 182 -> 158;
                case 183 -> 179;
                case 184 -> 99;
                case 185 -> 40;
                case 186 -> 74;
                case 187 -> 242;
                case 188 -> 71;
                case 189 -> 236;
                case 190 -> 62;
                case 191 -> 135;
                case 192 -> 67;
                case 193 -> 80;
                case 194 -> 35;
                case 195 -> 132;
                case 196 -> 149;
                case 197 -> 184;
                case 198 -> 134;
                case 199 -> 194;
                case 200 -> 127;
                case 201 -> 4;
                case 202 -> 38;
                case 203 -> 155;
                case 204 -> 25;
                case 205 -> 131;
                case 206 -> 82;
                case 207 -> 66;
                case 208 -> 251;
                case 209 -> 125;
                case 210 -> 163;
                case 211 -> 6;
                case 212 -> 36;
                case 213 -> 221;
                case 214 -> 166;
                case 215 -> 203;
                case 216 -> 30;
                case 217 -> 190;
                case 218 -> 223;
                case 219 -> 232;
                case 220 -> 16;
                case 221 -> 84;
                case 222 -> 247;
                case 223 -> 48;
                case 224 -> 49;
                case 225 -> 111;
                case 226 -> 3;
                case 227 -> 235;
                case 228 -> 204;
                case 229 -> 42;
                case 230 -> 252;
                case 231 -> 46;
                case 232 -> 214;
                case 233 -> 169;
                case 234 -> 227;
                case 235 -> 106;
                case 236 -> 20;
                case 237 -> 91;
                case 238 -> 215;
                case 239 -> 167;
                case 240 -> 170;
                case 241 -> 160;
                case 242 -> 181;
                case 243 -> 198;
                case 244 -> 95;
                case 245 -> 250;
                case 246 -> 146;
                case 247 -> 11;
                case 248 -> 96;
                case 249 -> 79;
                case 250 -> 58;
                case 251 -> 7;
                case 252 -> 14;
                case 253 -> 44;
                case 254 -> 90;
                default -> 0;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 53314272590987L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-843566520 - -((char)-28391), 843566520 - 21635, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String[] stringArray;
                        block4: {
                            l2 = 69521784983722L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            stringArray = SshAgentIpcService.v();
                            try {
                                hANDLE2 = hANDLE;
                                if (stringArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (stringArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(850644300 + 8693, 850644300 - 10098, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(850644300 + 8694, 850644300 - 16374, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(850644300 + 8695, -850644300 - -16972, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0001\u0089\u00ed\u00c4\u0085\u00b8HF\u0010\u00a3lH\u00d9\u008b\u00a0p\u001cln\u009f\u00fc\u009cJ\"}";
                    var4_3 = "\u0001\u0089\u00ed\u00c4\u0085\u00b8HF\u0010\u00a3lH\u00d9\u008b\u00a0p\u001cln\u009f\u00fc\u009cJ\"}".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 9;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00002\u00da\u00a4\u00045\u0099L\u00fe\u0007RUD\u001e\u008a\u0082\u00c6\u00b6W\u00feIv\u009b\u0089X\u0013I\u0093\u008d\u00ad[{yc\u00a5T6X\u0099w\u00be\u00aca\u0080\u00d8Y\u00bbnI\u0081\u00c9;\u0006\u00bd\u0017\u00b9W\u00e8\u0006";
                        var4_3 = "\u00002\u00da\u00a4\u00045\u0099L\u00fe\u0007RUD\u001e\u008a\u0082\u00c6\u00b6W\u00feIv\u009b\u0089X\u0013I\u0093\u008d\u00ad[{yc\u00a5T6X\u0099w\u00be\u00aca\u0080\u00d8Y\u00bbnI\u0081\u00c9;\u0006\u00bd\u0017\u00b9W\u00e8\u0006".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 56;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 21;
                                break;
                            }
                            case 1: {
                                v15 = 93;
                                break;
                            }
                            case 2: {
                                v15 = 73;
                                break;
                            }
                            case 3: {
                                v15 = 87;
                                break;
                            }
                            case 4: {
                                v15 = 23;
                                break;
                            }
                            case 5: {
                                v15 = 74;
                                break;
                            }
                            default: {
                                v15 = 28;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFBFEA) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 200;
                    case 1 -> 158;
                    case 2 -> 191;
                    case 3 -> 188;
                    case 4 -> 193;
                    case 5 -> 133;
                    case 6 -> 31;
                    case 7 -> 60;
                    case 8 -> 47;
                    case 9 -> 207;
                    case 10 -> 147;
                    case 11 -> 242;
                    case 12 -> 45;
                    case 13 -> 3;
                    case 14 -> 27;
                    case 15 -> 44;
                    case 16 -> 25;
                    case 17 -> 71;
                    case 18 -> 138;
                    case 19 -> 221;
                    case 20 -> 141;
                    case 21 -> 140;
                    case 22 -> 198;
                    case 23 -> 126;
                    case 24 -> 83;
                    case 25 -> 10;
                    case 26 -> 224;
                    case 27 -> 22;
                    case 28 -> 19;
                    case 29 -> 81;
                    case 30 -> 75;
                    case 31 -> 30;
                    case 32 -> 243;
                    case 33 -> 167;
                    case 34 -> 85;
                    case 35 -> 248;
                    case 36 -> 96;
                    case 37 -> 246;
                    case 38 -> 169;
                    case 39 -> 69;
                    case 40 -> 21;
                    case 41 -> 117;
                    case 42 -> 87;
                    case 43 -> 201;
                    case 44 -> 142;
                    case 45 -> 159;
                    case 46 -> 150;
                    case 47 -> 128;
                    case 48 -> 222;
                    case 49 -> 13;
                    case 50 -> 86;
                    case 51 -> 132;
                    case 52 -> 155;
                    case 53 -> 46;
                    case 54 -> 112;
                    case 55 -> 63;
                    case 56 -> 36;
                    case 57 -> 5;
                    case 58 -> 43;
                    case 59 -> 58;
                    case 60 -> 218;
                    case 61 -> 67;
                    case 62 -> 197;
                    case 63 -> 250;
                    case 64 -> 111;
                    case 65 -> 39;
                    case 66 -> 239;
                    case 67 -> 244;
                    case 68 -> 108;
                    case 69 -> 77;
                    case 70 -> 113;
                    case 71 -> 76;
                    case 72 -> 84;
                    case 73 -> 100;
                    case 74 -> 173;
                    case 75 -> 220;
                    case 76 -> 12;
                    case 77 -> 99;
                    case 78 -> 16;
                    case 79 -> 232;
                    case 80 -> 114;
                    case 81 -> 199;
                    case 82 -> 247;
                    case 83 -> 194;
                    case 84 -> 219;
                    case 85 -> 162;
                    case 86 -> 131;
                    case 87 -> 161;
                    case 88 -> 228;
                    case 89 -> 24;
                    case 90 -> 210;
                    case 91 -> 156;
                    case 92 -> 206;
                    case 93 -> 185;
                    case 94 -> 54;
                    case 95 -> 35;
                    case 96 -> 225;
                    case 97 -> 61;
                    case 98 -> 209;
                    case 99 -> 103;
                    case 100 -> 184;
                    case 101 -> 171;
                    case 102 -> 1;
                    case 103 -> 32;
                    case 104 -> 136;
                    case 105 -> 181;
                    case 106 -> 4;
                    case 107 -> 68;
                    case 108 -> 8;
                    case 109 -> 217;
                    case 110 -> 11;
                    case 111 -> 34;
                    case 112 -> 88;
                    case 113 -> 135;
                    case 114 -> 187;
                    case 115 -> 183;
                    case 116 -> 53;
                    case 117 -> 62;
                    case 118 -> 238;
                    case 119 -> 97;
                    case 120 -> 177;
                    case 121 -> 120;
                    case 122 -> 92;
                    case 123 -> 37;
                    case 124 -> 223;
                    case 125 -> 213;
                    case 126 -> 121;
                    case 127 -> 95;
                    case 128 -> 89;
                    case 129 -> 204;
                    case 130 -> 7;
                    case 131 -> 52;
                    case 132 -> 205;
                    case 133 -> 229;
                    case 134 -> 170;
                    case 135 -> 166;
                    case 136 -> 154;
                    case 137 -> 102;
                    case 138 -> 157;
                    case 139 -> 226;
                    case 140 -> 125;
                    case 141 -> 139;
                    case 142 -> 192;
                    case 143 -> 231;
                    case 144 -> 253;
                    case 145 -> 180;
                    case 146 -> 42;
                    case 147 -> 18;
                    case 148 -> 234;
                    case 149 -> 70;
                    case 150 -> 153;
                    case 151 -> 214;
                    case 152 -> 79;
                    case 153 -> 179;
                    case 154 -> 127;
                    case 155 -> 235;
                    case 156 -> 245;
                    case 157 -> 20;
                    case 158 -> 15;
                    case 159 -> 2;
                    case 160 -> 189;
                    case 161 -> 101;
                    case 162 -> 64;
                    case 163 -> 176;
                    case 164 -> 124;
                    case 165 -> 59;
                    case 166 -> 65;
                    case 167 -> 122;
                    case 168 -> 0;
                    case 169 -> 116;
                    case 170 -> 14;
                    case 171 -> 160;
                    case 172 -> 17;
                    case 173 -> 106;
                    case 174 -> 119;
                    case 175 -> 230;
                    case 176 -> 254;
                    case 177 -> 164;
                    case 178 -> 208;
                    case 179 -> 130;
                    case 180 -> 28;
                    case 181 -> 241;
                    case 182 -> 38;
                    case 183 -> 123;
                    case 184 -> 41;
                    case 185 -> 137;
                    case 186 -> 134;
                    case 187 -> 107;
                    case 188 -> 240;
                    case 189 -> 66;
                    case 190 -> 227;
                    case 191 -> 152;
                    case 192 -> 26;
                    case 193 -> 40;
                    case 194 -> 255;
                    case 195 -> 202;
                    case 196 -> 91;
                    case 197 -> 252;
                    case 198 -> 129;
                    case 199 -> 80;
                    case 200 -> 151;
                    case 201 -> 237;
                    case 202 -> 168;
                    case 203 -> 145;
                    case 204 -> 82;
                    case 205 -> 143;
                    case 206 -> 144;
                    case 207 -> 211;
                    case 208 -> 215;
                    case 209 -> 6;
                    case 210 -> 49;
                    case 211 -> 33;
                    case 212 -> 98;
                    case 213 -> 118;
                    case 214 -> 165;
                    case 215 -> 149;
                    case 216 -> 72;
                    case 217 -> 110;
                    case 218 -> 9;
                    case 219 -> 178;
                    case 220 -> 104;
                    case 221 -> 146;
                    case 222 -> 249;
                    case 223 -> 216;
                    case 224 -> 109;
                    case 225 -> 74;
                    case 226 -> 186;
                    case 227 -> 175;
                    case 228 -> 148;
                    case 229 -> 29;
                    case 230 -> 236;
                    case 231 -> 78;
                    case 232 -> 196;
                    case 233 -> 57;
                    case 234 -> 23;
                    case 235 -> 51;
                    case 236 -> 90;
                    case 237 -> 93;
                    case 238 -> 203;
                    case 239 -> 48;
                    case 240 -> 163;
                    case 241 -> 251;
                    case 242 -> 190;
                    case 243 -> 56;
                    case 244 -> 73;
                    case 245 -> 233;
                    case 246 -> 195;
                    case 247 -> 174;
                    case 248 -> 94;
                    case 249 -> 115;
                    case 250 -> 105;
                    case 251 -> 50;
                    case 252 -> 212;
                    case 253 -> 182;
                    case 254 -> 172;
                    default -> 55;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 16328151471526L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "6nZ=S@do\t1dI7\u001e\u0002ys\"";
                    var5_4 = "6nZ=S@do\t1dI7\u001e\u0002ys\"".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 20;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 73;
                                    break;
                                }
                                case 1: {
                                    v11 = 31;
                                    break;
                                }
                                case 2: {
                                    v11 = 60;
                                    break;
                                }
                                case 3: {
                                    v11 = 71;
                                    break;
                                }
                                case 4: {
                                    v11 = 34;
                                    break;
                                }
                                case 5: {
                                    v11 = 56;
                                    break;
                                }
                                default: {
                                    v11 = 67;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 128441382757510L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "8]9bf\u0002q\u0004>C5x\n2\\>xj\u0000i\u0018]7\t2\\>xj\u0000i\u0014W\r5Z#u`\rs\u0014P$\u007fa\u0004";
                    var5_4 = "8]9bf\u0002q\u0004>C5x\n2\\>xj\u0000i\u0018]7\t2\\>xj\u0000i\u0014W\r5Z#u`\rs\u0014P$\u007fa\u0004".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 104;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "N#C\u0019\u001aq\u0006\u0006N#C\u0019\u0016{";
                        var5_4 = "N#C\u0019\u001aq\u0006\u0006N#C\u0019\u0016{".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 20;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 25;
                                break;
                            }
                            case 1: {
                                v15 = 91;
                                break;
                            }
                            case 2: {
                                v15 = 56;
                                break;
                            }
                            case 3: {
                                v15 = 126;
                                break;
                            }
                            case 4: {
                                v15 = 103;
                                break;
                            }
                            case 5: {
                                v15 = 11;
                                break;
                            }
                            default: {
                                v15 = 117;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 17168018619729L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1034273370 + (char)-2407, -1034404440 - -((char)-8973), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 59933978797435L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u000bi\u00bf\u00af1\u0003\u00e0Xv\u0005bh\u00b4K\u00b3\r=\u00e7i\u00f0\u00fd\u00ffZ\u00efJ\u00a1\u000b%\u0007\u0010\u00eem\u00d4Ju=`\u008a\u00c4\u00899m\u00a7\u00b7`h\u0005.\u00fd=\u00f9\u00823\u009bQ\u009a\u001biS\u00d3S\u00cfO\u00d3\u009c<\u00d8?\u009aG\u00ab\u00ce\u00af\u00e40\u00e3s\u00f9E<*\u0081t\u00af\u00a5\u0011\u0096\u0097\u00c9\u0003L\u0080\u00b0\u00d5\u00d1\u00a7\u00f9G\u00e2\u00c3T\u00fe\u0086'";
                    var4_3 = "\u000bi\u00bf\u00af1\u0003\u00e0Xv\u0005bh\u00b4K\u00b3\r=\u00e7i\u00f0\u00fd\u00ffZ\u00efJ\u00a1\u000b%\u0007\u0010\u00eem\u00d4Ju=`\u008a\u00c4\u00899m\u00a7\u00b7`h\u0005.\u00fd=\u00f9\u00823\u009bQ\u009a\u001biS\u00d3S\u00cfO\u00d3\u009c<\u00d8?\u009aG\u00ab\u00ce\u00af\u00e40\u00e3s\u00f9E<*\u0081t\u00af\u00a5\u0011\u0096\u0097\u00c9\u0003L\u0080\u00b0\u00d5\u00d1\u00a7\u00f9G\u00e2\u00c3T\u00fe\u0086'".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 35;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00b7\u00d40\u00b2&\u00ed\u00c5_\u00bf\u00fc\u0099\f|T\u00d4\u00dbL\u00a4L\u00a5k\u00be\u001e\u00b8O\u0099m\u00f1\u0087\u007f\u00ab']\u008eM\u00c7Jb'\u00d6\u00fc\u00b3\u0090\u009f\u0099\u00c0\u0084\u00a7\u001b\u00cf`\u00f2\u00c4R\u00fc_\u000f\u00d7\u0014\u00e7\u00f3\u0095\u00b2\u009d\u00a9\b\u00c2\u00de\u00fe6\u00cd,\u00cd\u00c5f\u001e!\u00cd\u00dc\u0000\u009a\u00ce\u00ce\u0012\u008di\u0011\u00b3\u00da\u00f3\u0082e$";
                        var4_3 = "\u00b7\u00d40\u00b2&\u00ed\u00c5_\u00bf\u00fc\u0099\f|T\u00d4\u00dbL\u00a4L\u00a5k\u00be\u001e\u00b8O\u0099m\u00f1\u0087\u007f\u00ab']\u008eM\u00c7Jb'\u00d6\u00fc\u00b3\u0090\u009f\u0099\u00c0\u0084\u00a7\u001b\u00cf`\u00f2\u00c4R\u00fc_\u000f\u00d7\u0014\u00e7\u00f3\u0095\u00b2\u009d\u00a9\b\u00c2\u00de\u00fe6\u00cd,\u00cd\u00c5f\u001e!\u00cd\u00dc\u0000\u009a\u00ce\u00ce\u0012\u008di\u0011\u00b3\u00da\u00f3\u0082e$".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 45;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 30;
                                break;
                            }
                            case 1: {
                                v15 = 25;
                                break;
                            }
                            case 2: {
                                v15 = 114;
                                break;
                            }
                            case 3: {
                                v15 = 3;
                                break;
                            }
                            case 4: {
                                v15 = 114;
                                break;
                            }
                            case 5: {
                                v15 = 64;
                                break;
                            }
                            default: {
                                v15 = 16;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5A2) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 176;
                    case 1 -> 136;
                    case 2 -> 93;
                    case 3 -> 104;
                    case 4 -> 63;
                    case 5 -> 48;
                    case 6 -> 99;
                    case 7 -> 173;
                    case 8 -> 47;
                    case 9 -> 39;
                    case 10 -> 120;
                    case 11 -> 109;
                    case 12 -> 74;
                    case 13 -> 147;
                    case 14 -> 40;
                    case 15 -> 219;
                    case 16 -> 79;
                    case 17 -> 108;
                    case 18 -> 142;
                    case 19 -> 194;
                    case 20 -> 3;
                    case 21 -> 21;
                    case 22 -> 118;
                    case 23 -> 195;
                    case 24 -> 210;
                    case 25 -> 51;
                    case 26 -> 56;
                    case 27 -> 105;
                    case 28 -> 94;
                    case 29 -> 87;
                    case 30 -> 82;
                    case 31 -> 33;
                    case 32 -> 254;
                    case 33 -> 223;
                    case 34 -> 8;
                    case 35 -> 216;
                    case 36 -> 152;
                    case 37 -> 100;
                    case 38 -> 228;
                    case 39 -> 165;
                    case 40 -> 26;
                    case 41 -> 41;
                    case 42 -> 235;
                    case 43 -> 103;
                    case 44 -> 54;
                    case 45 -> 133;
                    case 46 -> 212;
                    case 47 -> 29;
                    case 48 -> 68;
                    case 49 -> 186;
                    case 50 -> 200;
                    case 51 -> 251;
                    case 52 -> 153;
                    case 53 -> 61;
                    case 54 -> 115;
                    case 55 -> 83;
                    case 56 -> 91;
                    case 57 -> 16;
                    case 58 -> 23;
                    case 59 -> 168;
                    case 60 -> 222;
                    case 61 -> 234;
                    case 62 -> 245;
                    case 63 -> 184;
                    case 64 -> 27;
                    case 65 -> 154;
                    case 66 -> 12;
                    case 67 -> 116;
                    case 68 -> 197;
                    case 69 -> 134;
                    case 70 -> 183;
                    case 71 -> 129;
                    case 72 -> 199;
                    case 73 -> 132;
                    case 74 -> 50;
                    case 75 -> 250;
                    case 76 -> 221;
                    case 77 -> 162;
                    case 78 -> 201;
                    case 79 -> 11;
                    case 80 -> 106;
                    case 81 -> 72;
                    case 82 -> 97;
                    case 83 -> 13;
                    case 84 -> 225;
                    case 85 -> 180;
                    case 86 -> 230;
                    case 87 -> 144;
                    case 88 -> 192;
                    case 89 -> 44;
                    case 90 -> 95;
                    case 91 -> 75;
                    case 92 -> 122;
                    case 93 -> 155;
                    case 94 -> 55;
                    case 95 -> 175;
                    case 96 -> 2;
                    case 97 -> 117;
                    case 98 -> 239;
                    case 99 -> 114;
                    case 100 -> 181;
                    case 101 -> 86;
                    case 102 -> 4;
                    case 103 -> 32;
                    case 104 -> 164;
                    case 105 -> 19;
                    case 106 -> 169;
                    case 107 -> 107;
                    case 108 -> 220;
                    case 109 -> 60;
                    case 110 -> 253;
                    case 111 -> 36;
                    case 112 -> 58;
                    case 113 -> 255;
                    case 114 -> 113;
                    case 115 -> 177;
                    case 116 -> 59;
                    case 117 -> 92;
                    case 118 -> 17;
                    case 119 -> 205;
                    case 120 -> 67;
                    case 121 -> 171;
                    case 122 -> 139;
                    case 123 -> 77;
                    case 124 -> 96;
                    case 125 -> 157;
                    case 126 -> 140;
                    case 127 -> 9;
                    case 128 -> 241;
                    case 129 -> 227;
                    case 130 -> 62;
                    case 131 -> 179;
                    case 132 -> 233;
                    case 133 -> 196;
                    case 134 -> 84;
                    case 135 -> 208;
                    case 136 -> 30;
                    case 137 -> 22;
                    case 138 -> 15;
                    case 139 -> 18;
                    case 140 -> 207;
                    case 141 -> 65;
                    case 142 -> 252;
                    case 143 -> 49;
                    case 144 -> 42;
                    case 145 -> 123;
                    case 146 -> 159;
                    case 147 -> 101;
                    case 148 -> 240;
                    case 149 -> 203;
                    case 150 -> 237;
                    case 151 -> 217;
                    case 152 -> 81;
                    case 153 -> 111;
                    case 154 -> 69;
                    case 155 -> 167;
                    case 156 -> 126;
                    case 157 -> 73;
                    case 158 -> 125;
                    case 159 -> 71;
                    case 160 -> 149;
                    case 161 -> 6;
                    case 162 -> 158;
                    case 163 -> 135;
                    case 164 -> 110;
                    case 165 -> 7;
                    case 166 -> 0;
                    case 167 -> 231;
                    case 168 -> 224;
                    case 169 -> 163;
                    case 170 -> 244;
                    case 171 -> 187;
                    case 172 -> 38;
                    case 173 -> 213;
                    case 174 -> 20;
                    case 175 -> 232;
                    case 176 -> 172;
                    case 177 -> 190;
                    case 178 -> 1;
                    case 179 -> 89;
                    case 180 -> 151;
                    case 181 -> 178;
                    case 182 -> 229;
                    case 183 -> 70;
                    case 184 -> 128;
                    case 185 -> 156;
                    case 186 -> 236;
                    case 187 -> 35;
                    case 188 -> 148;
                    case 189 -> 57;
                    case 190 -> 247;
                    case 191 -> 14;
                    case 192 -> 102;
                    case 193 -> 43;
                    case 194 -> 170;
                    case 195 -> 226;
                    case 196 -> 78;
                    case 197 -> 189;
                    case 198 -> 10;
                    case 199 -> 127;
                    case 200 -> 248;
                    case 201 -> 141;
                    case 202 -> 112;
                    case 203 -> 130;
                    case 204 -> 215;
                    case 205 -> 202;
                    case 206 -> 34;
                    case 207 -> 174;
                    case 208 -> 238;
                    case 209 -> 206;
                    case 210 -> 46;
                    case 211 -> 66;
                    case 212 -> 85;
                    case 213 -> 80;
                    case 214 -> 64;
                    case 215 -> 214;
                    case 216 -> 249;
                    case 217 -> 131;
                    case 218 -> 143;
                    case 219 -> 150;
                    case 220 -> 121;
                    case 221 -> 211;
                    case 222 -> 119;
                    case 223 -> 161;
                    case 224 -> 5;
                    case 225 -> 45;
                    case 226 -> 88;
                    case 227 -> 160;
                    case 228 -> 166;
                    case 229 -> 146;
                    case 230 -> 31;
                    case 231 -> 76;
                    case 232 -> 246;
                    case 233 -> 242;
                    case 234 -> 198;
                    case 235 -> 188;
                    case 236 -> 53;
                    case 237 -> 209;
                    case 238 -> 25;
                    case 239 -> 182;
                    case 240 -> 193;
                    case 241 -> 138;
                    case 242 -> 204;
                    case 243 -> 37;
                    case 244 -> 243;
                    case 245 -> 98;
                    case 246 -> 145;
                    case 247 -> 191;
                    case 248 -> 24;
                    case 249 -> 137;
                    case 250 -> 124;
                    case 251 -> 185;
                    case 252 -> 28;
                    case 253 -> 218;
                    case 254 -> 52;
                    default -> 90;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 3755765332270L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-1963952880 - -((char)-12734), -1963821810 + -((char)-484), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 76637240666931L;
                    String[] stringArray = SshAgentIpcService.v();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-2139193470 + -28212, -2139193470 + -30707, (int)l2));
                    String[] stringArray2 = stringArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (stringArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 114197379536688L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00c5\u00b5s\u00fc\u009e\u0003bp\u00d1";
                var4_3 = "\u00c5\u00b5s\u00fc\u009e\u0003bp\u00d1".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 29;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 82;
                                break;
                            }
                            case 1: {
                                v11 = 81;
                                break;
                            }
                            case 2: {
                                v11 = 23;
                                break;
                            }
                            case 3: {
                                v11 = 59;
                                break;
                            }
                            case 4: {
                                v11 = 17;
                                break;
                            }
                            case 5: {
                                v11 = 64;
                                break;
                            }
                            default: {
                                v11 = 59;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFBA7C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 144;
                    case 1 -> 17;
                    case 2 -> 234;
                    case 3 -> 198;
                    case 4 -> 54;
                    case 5 -> 135;
                    case 6 -> 190;
                    case 7 -> 251;
                    case 8 -> 38;
                    case 9 -> 87;
                    case 10 -> 35;
                    case 11 -> 128;
                    case 12 -> 75;
                    case 13 -> 227;
                    case 14 -> 10;
                    case 15 -> 218;
                    case 16 -> 207;
                    case 17 -> 181;
                    case 18 -> 189;
                    case 19 -> 108;
                    case 20 -> 157;
                    case 21 -> 146;
                    case 22 -> 81;
                    case 23 -> 5;
                    case 24 -> 89;
                    case 25 -> 236;
                    case 26 -> 98;
                    case 27 -> 53;
                    case 28 -> 42;
                    case 29 -> 183;
                    case 30 -> 200;
                    case 31 -> 34;
                    case 32 -> 253;
                    case 33 -> 33;
                    case 34 -> 101;
                    case 35 -> 167;
                    case 36 -> 39;
                    case 37 -> 250;
                    case 38 -> 139;
                    case 39 -> 141;
                    case 40 -> 243;
                    case 41 -> 123;
                    case 42 -> 175;
                    case 43 -> 116;
                    case 44 -> 29;
                    case 45 -> 94;
                    case 46 -> 136;
                    case 47 -> 145;
                    case 48 -> 8;
                    case 49 -> 134;
                    case 50 -> 122;
                    case 51 -> 22;
                    case 52 -> 239;
                    case 53 -> 83;
                    case 54 -> 31;
                    case 55 -> 73;
                    case 56 -> 110;
                    case 57 -> 21;
                    case 58 -> 105;
                    case 59 -> 161;
                    case 60 -> 154;
                    case 61 -> 113;
                    case 62 -> 149;
                    case 63 -> 212;
                    case 64 -> 71;
                    case 65 -> 143;
                    case 66 -> 252;
                    case 67 -> 240;
                    case 68 -> 84;
                    case 69 -> 107;
                    case 70 -> 245;
                    case 71 -> 24;
                    case 72 -> 80;
                    case 73 -> 70;
                    case 74 -> 78;
                    case 75 -> 153;
                    case 76 -> 232;
                    case 77 -> 246;
                    case 78 -> 174;
                    case 79 -> 103;
                    case 80 -> 56;
                    case 81 -> 117;
                    case 82 -> 68;
                    case 83 -> 64;
                    case 84 -> 230;
                    case 85 -> 229;
                    case 86 -> 26;
                    case 87 -> 219;
                    case 88 -> 86;
                    case 89 -> 11;
                    case 90 -> 76;
                    case 91 -> 151;
                    case 92 -> 225;
                    case 93 -> 41;
                    case 94 -> 61;
                    case 95 -> 247;
                    case 96 -> 47;
                    case 97 -> 1;
                    case 98 -> 27;
                    case 99 -> 82;
                    case 100 -> 204;
                    case 101 -> 132;
                    case 102 -> 129;
                    case 103 -> 52;
                    case 104 -> 221;
                    case 105 -> 111;
                    case 106 -> 92;
                    case 107 -> 165;
                    case 108 -> 12;
                    case 109 -> 235;
                    case 110 -> 95;
                    case 111 -> 58;
                    case 112 -> 205;
                    case 113 -> 168;
                    case 114 -> 249;
                    case 115 -> 15;
                    case 116 -> 148;
                    case 117 -> 36;
                    case 118 -> 118;
                    case 119 -> 184;
                    case 120 -> 180;
                    case 121 -> 238;
                    case 122 -> 45;
                    case 123 -> 85;
                    case 124 -> 65;
                    case 125 -> 150;
                    case 126 -> 119;
                    case 127 -> 114;
                    case 128 -> 201;
                    case 129 -> 231;
                    case 130 -> 233;
                    case 131 -> 137;
                    case 132 -> 109;
                    case 133 -> 91;
                    case 134 -> 186;
                    case 135 -> 255;
                    case 136 -> 13;
                    case 137 -> 14;
                    case 138 -> 241;
                    case 139 -> 121;
                    case 140 -> 160;
                    case 141 -> 147;
                    case 142 -> 155;
                    case 143 -> 199;
                    case 144 -> 133;
                    case 145 -> 206;
                    case 146 -> 125;
                    case 147 -> 188;
                    case 148 -> 37;
                    case 149 -> 96;
                    case 150 -> 254;
                    case 151 -> 192;
                    case 152 -> 237;
                    case 153 -> 228;
                    case 154 -> 99;
                    case 155 -> 156;
                    case 156 -> 242;
                    case 157 -> 138;
                    case 158 -> 7;
                    case 159 -> 3;
                    case 160 -> 176;
                    case 161 -> 63;
                    case 162 -> 178;
                    case 163 -> 171;
                    case 164 -> 214;
                    case 165 -> 19;
                    case 166 -> 79;
                    case 167 -> 115;
                    case 168 -> 195;
                    case 169 -> 164;
                    case 170 -> 158;
                    case 171 -> 28;
                    case 172 -> 209;
                    case 173 -> 46;
                    case 174 -> 159;
                    case 175 -> 170;
                    case 176 -> 126;
                    case 177 -> 97;
                    case 178 -> 74;
                    case 179 -> 59;
                    case 180 -> 40;
                    case 181 -> 194;
                    case 182 -> 130;
                    case 183 -> 124;
                    case 184 -> 179;
                    case 185 -> 248;
                    case 186 -> 50;
                    case 187 -> 23;
                    case 188 -> 90;
                    case 189 -> 172;
                    case 190 -> 162;
                    case 191 -> 43;
                    case 192 -> 169;
                    case 193 -> 6;
                    case 194 -> 25;
                    case 195 -> 2;
                    case 196 -> 210;
                    case 197 -> 67;
                    case 198 -> 217;
                    case 199 -> 62;
                    case 200 -> 213;
                    case 201 -> 72;
                    case 202 -> 152;
                    case 203 -> 18;
                    case 204 -> 55;
                    case 205 -> 93;
                    case 206 -> 102;
                    case 207 -> 44;
                    case 208 -> 187;
                    case 209 -> 57;
                    case 210 -> 224;
                    case 211 -> 215;
                    case 212 -> 88;
                    case 213 -> 69;
                    case 214 -> 202;
                    case 215 -> 16;
                    case 216 -> 66;
                    case 217 -> 131;
                    case 218 -> 220;
                    case 219 -> 120;
                    case 220 -> 49;
                    case 221 -> 127;
                    case 222 -> 32;
                    case 223 -> 182;
                    case 224 -> 223;
                    case 225 -> 48;
                    case 226 -> 142;
                    case 227 -> 222;
                    case 228 -> 77;
                    case 229 -> 30;
                    case 230 -> 208;
                    case 231 -> 211;
                    case 232 -> 226;
                    case 233 -> 4;
                    case 234 -> 20;
                    case 235 -> 185;
                    case 236 -> 9;
                    case 237 -> 51;
                    case 238 -> 197;
                    case 239 -> 191;
                    case 240 -> 104;
                    case 241 -> 203;
                    case 242 -> 193;
                    case 243 -> 244;
                    case 244 -> 106;
                    case 245 -> 196;
                    case 246 -> 100;
                    case 247 -> 173;
                    case 248 -> 163;
                    case 249 -> 177;
                    case 250 -> 112;
                    case 251 -> 60;
                    case 252 -> 166;
                    case 253 -> 216;
                    case 254 -> 0;
                    default -> 140;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

