/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang.js;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.stimulus.UtilKt;
import com.intellij.stimulus.lang.StimulusAttributeDescriptorsProviderKt;
import com.intellij.stimulus.lang.js.StimulusJSReferenceContributorKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/stimulus/lang/js/StimulusClassFieldReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "refExpression", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/lang/javascript/psi/JSReferenceExpression;Lcom/intellij/openapi/util/TextRange;)V", "resolve", "isReferenceTo", "", "element", "resolveAsTarget", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "name", "", "resolveAsClass", "resolveAsValue", "resolveAsOutlet", "resolveFromFieldWithSuffix", "suffix", "fieldName", "getSimplePropertyName", "handleElementRename", "newElementName", "intellij.stimulus"})
@SourceDebugExtension(value={"SMAP\nStimulusJSReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StimulusJSReferenceContributor.kt\ncom/intellij/stimulus/lang/js/StimulusClassFieldReference\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1400#2,2:179\n1400#2,2:181\n1#3:183\n*S KotlinDebug\n*F\n+ 1 StimulusJSReferenceContributor.kt\ncom/intellij/stimulus/lang/js/StimulusClassFieldReference\n*L\n105#1:179,2\n125#1:181,2\n*E\n"})
public final class StimulusClassFieldReference
extends PsiReferenceBase<PsiElement> {
    @NotNull
    private final JSReferenceExpression refExpression;

    public StimulusClassFieldReference(@NotNull JSReferenceExpression refExpression, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)refExpression, (String)"refExpression");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super((PsiElement)refExpression, range, true);
        this.refExpression = refExpression;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        JSClass jSClass = StimulusJSReferenceContributorKt.getOwnerClass(psiElement);
        if (jSClass == null) {
            return null;
        }
        JSClass jsClass = jSClass;
        String string = this.refExpression.getReferenceName();
        if (string == null) {
            return null;
        }
        String name = string;
        PsiElement targetResolve = this.resolveAsTarget(jsClass, name);
        if (targetResolve != null) {
            return targetResolve;
        }
        PsiElement classResolve = this.resolveAsClass(jsClass, name);
        if (classResolve != null) {
            return classResolve;
        }
        PsiElement outletResolve = this.resolveAsOutlet(jsClass, name);
        if (outletResolve != null) {
            return outletResolve;
        }
        return this.resolveAsValue(jsClass, name);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = this.resolve();
        if (psiElement == null || (psiElement = psiElement.getParent()) == null) {
            return false;
        }
        PsiElement realElement = psiElement;
        return this.getElement().getManager().areElementsEquivalent(realElement, element);
    }

    private final PsiElement resolveAsTarget(JSClass jsClass, String name) {
        return this.resolveFromFieldWithSuffix(jsClass, name, "Target", "targets");
    }

    private final PsiElement resolveAsClass(JSClass jsClass, String name) {
        return this.resolveFromFieldWithSuffix(jsClass, name, "Class", "classes");
    }

    private final PsiElement resolveAsValue(JSClass jsClass, String name) {
        JSProperty[] jSPropertyArray;
        block9: {
            block8: {
                JSProperty[] jSPropertyArray2;
                block7: {
                    if (!StringsKt.endsWith$default((String)name, (String)"Value", (boolean)false, (int)2, null)) {
                        String string = StringUtil.pluralize((String)"Value");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
                        if (!StringsKt.endsWith$default((String)name, (String)string, (boolean)false, (int)2, null)) {
                            return null;
                        }
                    }
                    JSField jSField = UtilKt.getStaticField(jsClass, "values");
                    if (jSField == null) {
                        return null;
                    }
                    JSField field = jSField;
                    String propName = this.getSimplePropertyName(name, "Value");
                    JSExpression jSExpression = field.getInitializer();
                    jSPropertyArray = jSExpression instanceof JSObjectLiteralExpression ? (JSProperty[])jSExpression : null;
                    if (jSPropertyArray == null || (jSPropertyArray = jSPropertyArray.getProperties()) == null) break block8;
                    JSProperty[] $this$firstOrNull$iv = jSPropertyArray;
                    boolean $i$f$firstOrNull = false;
                    int n = $this$firstOrNull$iv.length;
                    for (int i = 0; i < n; ++i) {
                        JSProperty[] element$iv;
                        JSProperty[] it = element$iv = $this$firstOrNull$iv[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)propName)) continue;
                        jSPropertyArray2 = element$iv;
                        break block7;
                    }
                    jSPropertyArray2 = jSPropertyArray = null;
                }
                if (jSPropertyArray2 != null) break block9;
            }
            return null;
        }
        JSProperty[] jsProperty = jSPropertyArray;
        return (PsiElement)new JSLocalImplicitElementImpl(name, null, (PsiElement)jsProperty, JSImplicitElement.Type.Property);
    }

    private final PsiElement resolveAsOutlet(JSClass jsClass, String name) {
        String string = JSStringUtil.toCamelCase((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCamelCase(...)");
        return this.resolveFromFieldWithSuffix(jsClass, string, "Outlet", "outlets");
    }

    private final PsiElement resolveFromFieldWithSuffix(JSClass jsClass, String name, String suffix, String fieldName) {
        JSLiteralExpression literal;
        block5: {
            JSLiteralExpression jSLiteralExpression;
            JSField jSField = UtilKt.getStaticField(jsClass, fieldName);
            if (jSField == null) {
                return null;
            }
            JSField field = jSField;
            if (!StringsKt.endsWith$default((String)name, (String)suffix, (boolean)false, (int)2, null)) {
                String string = StringUtil.pluralize((String)suffix);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
                if (!StringsKt.endsWith$default((String)name, (String)string, (boolean)false, (int)2, null)) {
                    return null;
                }
            }
            String propName = this.getSimplePropertyName(name, suffix);
            JSLiteralExpression[] $this$firstOrNull$iv = StimulusAttributeDescriptorsProviderKt.getLiterals(field);
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                JSLiteralExpression element$iv;
                JSLiteralExpression it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getStringValue(), (Object)propName)) continue;
                jSLiteralExpression = element$iv;
                break block5;
            }
            jSLiteralExpression = literal = null;
        }
        if (literal != null) {
            return (PsiElement)new JSLocalImplicitElementImpl(name, null, (PsiElement)literal, JSImplicitElement.Type.Property);
        }
        return null;
    }

    private final String getSimplePropertyName(String name, String suffix) {
        String string;
        if (StringsKt.endsWith$default((String)name, (String)suffix, (boolean)false, (int)2, null)) {
            String string2 = name.substring(0, name.length() - suffix.length());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String string3 = name.substring(0, name.length() - StringUtil.pluralize((String)suffix).length());
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        String withoutSuffix = string;
        if (StringsKt.startsWith$default((String)withoutSuffix, (String)"has", (boolean)false, (int)2, null)) {
            String string4 = withoutSuffix.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String string5 = StringUtil.decapitalize((String)string4);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"decapitalize(...)");
            return string5;
        }
        return withoutSuffix;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Object v1;
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
            object = StimulusJSReferenceContributorKt.access$getAllSuffixes$p();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                String it = (String)t;
                boolean bl = false;
                String string = this.getElement().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.endsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        String suffix = v1;
        String string = this.getElement().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        object = string;
        int n = 0;
        int n2 = this.getRangeInElement().getStartOffset();
        String string2 = ((String)object).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String newElementText = string2 + newElementName + suffix;
        JSExpression jSExpression = JSPsiElementFactory.createJSExpression((String)newElementText, (PsiElement)this.getElement());
        Intrinsics.checkNotNullExpressionValue((Object)jSExpression, (String)"createJSExpression(...)");
        JSExpression newElement = jSExpression;
        this.getElement().replace((PsiElement)newElement);
        return (PsiElement)newElement;
    }
}

