/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.stimulus.lang.BaseStimulusAttributeDescriptor;
import com.intellij.stimulus.lang.StimulusReferencesKt;
import com.intellij.xml.impl.XmlAttributeDescriptorEx;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/stimulus/lang/ValuesFieldAttributeDescriptor;", "Lcom/intellij/stimulus/lang/BaseStimulusAttributeDescriptor;", "Lcom/intellij/xml/impl/XmlAttributeDescriptorEx;", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "<init>", "(Lcom/intellij/lang/javascript/psi/JSProperty;)V", "getDeclaration", "Lcom/intellij/psi/PsiElement;", "getName", "", "handleTargetRename", "newTargetName", "intellij.stimulus"})
public final class ValuesFieldAttributeDescriptor
extends BaseStimulusAttributeDescriptor
implements XmlAttributeDescriptorEx {
    @NotNull
    private final JSProperty property;

    public ValuesFieldAttributeDescriptor(@NotNull JSProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.property = property;
    }

    @NotNull
    public PsiElement getDeclaration() {
        return (PsiElement)this.property;
    }

    @NotNull
    public String getName() {
        PsiFile psiFile = this.property.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return "data-" + StimulusReferencesKt.toControllerName(psiFile) + "-" + JSStringUtil.toKebabCase((String)this.property.getName(), (boolean)true, (boolean)true, (boolean)false) + "-value";
    }

    @NotNull
    public String handleTargetRename(@NotNull String newTargetName) {
        Intrinsics.checkNotNullParameter((Object)newTargetName, (String)"newTargetName");
        PsiFile psiFile = this.property.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return "data-" + StimulusReferencesKt.toControllerName(psiFile) + "-" + JSStringUtil.toKebabCase((String)newTargetName, (boolean)true, (boolean)true, (boolean)false) + "-value";
    }
}

