/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.stimulus.StimulusBundle;
import com.intellij.stimulus.lang.StimulusTargetFakePsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0016J\r\u0010\u001f\u001a\u00070\u0014\u00a2\u0006\u0002\b H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u00020\u00182\b\u0010$\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010%\u001a\u00020&H\u0016R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006'"}, d2={"Lcom/intellij/stimulus/lang/StimulusTargetFakePsiElement;", "Lcom/intellij/psi/impl/RenameableFakePsiElement;", "Lcom/intellij/psi/PsiTarget;", "parent", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "<init>", "(Lcom/intellij/lang/javascript/psi/JSLiteralExpression;)V", "myPresentation", "com/intellij/stimulus/lang/StimulusTargetFakePsiElement$myPresentation$1", "Lcom/intellij/stimulus/lang/StimulusTargetFakePsiElement$myPresentation$1;", "getParent", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRangeInParent", "getTextLength", "", "getTextOffset", "getText", "", "textToCharArray", "", "textContains", "", "c", "", "setName", "Lcom/intellij/psi/PsiElement;", "name", "getName", "getTypeName", "Lorg/jetbrains/annotations/Nls;", "getIcon", "Ljavax/swing/Icon;", "isEquivalentTo", "another", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "intellij.stimulus"})
public final class StimulusTargetFakePsiElement
extends RenameableFakePsiElement
implements PsiTarget {
    @NotNull
    private final myPresentation.1 myPresentation;

    public StimulusTargetFakePsiElement(@NotNull JSLiteralExpression parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super((PsiElement)parent);
        this.myPresentation = new ItemPresentation(this){
            final /* synthetic */ StimulusTargetFakePsiElement this$0;
            {
                this.this$0 = $receiver;
            }

            public String getPresentableText() {
                return this.this$0.getName();
            }

            public Icon getIcon(boolean unused) {
                return this.this$0.getIcon();
            }
        };
    }

    @NotNull
    public JSLiteralExpression getParent() {
        PsiElement psiElement = super.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSLiteralExpression");
        return (JSLiteralExpression)psiElement;
    }

    @NotNull
    public PsiFile getContainingFile() {
        PsiFile psiFile = this.getParent().getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return psiFile;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.getParent().getTextRange().shiftRight(1).grown(-2);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
        return textRange;
    }

    @NotNull
    public TextRange getTextRangeInParent() {
        TextRange textRange = TextRange.create((int)1, (int)(this.getParent().getTextLength() - 1));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }

    public int getTextLength() {
        return this.getParent().getTextLength() - 2;
    }

    public int getTextOffset() {
        return this.getParent().getTextOffset() + 1;
    }

    @NotNull
    public String getText() {
        String string = this.getTextRangeInParent().substring(this.getParent().getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = Arrays.copyOfRange(this.getParent().textToCharArray(), this.getTextRangeInParent().getStartOffset(), this.getTextRangeInParent().getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"copyOfRange(...)");
        return cArray;
    }

    public boolean textContains(char c) {
        return this.getParent().textContains(c);
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = StringUtil.wrapWithDoubleQuote((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrapWithDoubleQuote(...)");
        String newElementText = string;
        JSExpression jSExpression = JSPsiElementFactory.createJSExpression((String)newElementText, (PsiElement)((PsiElement)this.getParent()), JSLiteralExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)jSExpression, (String)"createJSExpression(...)");
        JSLiteralExpression newElement = (JSLiteralExpression)jSExpression;
        this.getParent().replace((JSExpression)newElement);
        return (PsiElement)new StimulusTargetFakePsiElement(newElement);
    }

    @Nullable
    public String getName() {
        return this.getParent().getStringValue();
    }

    @NotNull
    public String getTypeName() {
        return StimulusBundle.INSTANCE.message("stimulus.target", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Nodes.Field;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Field");
        return icon;
    }

    public boolean isEquivalentTo(@Nullable PsiElement another) {
        if (another instanceof StimulusTargetFakePsiElement) {
            return this.equals(another);
        }
        return PsiManager.getInstance((Project)this.getProject()).areElementsEquivalent((PsiElement)this.getParent(), another);
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return this.myPresentation;
    }
}

