/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.stimulus.UtilKt;
import com.intellij.stimulus.lang.StimulusReferencesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\"\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0000\u001a&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\b\u001a\u00020\u0006\u001a&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"dataControllerName", "", "dataActionName", "dataTargetName", "CONTROLLERS", "resolveController", "Lcom/intellij/psi/PsiElement;", "name", "context", "toControllerName", "file", "Lcom/intellij/psi/PsiFile;", "getContextControllers", "", "Lkotlin/Pair;", "Lcom/intellij/psi/xml/XmlTag;", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "contextTag", "findControllersByName", "Lcom/intellij/lang/javascript/psi/JSFile;", "extension", "trimPrefix", "getAllControllers", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "manager", "Lcom/intellij/psi/PsiManager;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.stimulus"})
@SourceDebugExtension(value={"SMAP\nStimulusReferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StimulusReferences.kt\ncom/intellij/stimulus/lang/StimulusReferencesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1617#2,9:274\n1869#2:283\n1870#2:285\n1626#2:286\n774#2:287\n865#2,2:288\n1617#2,9:291\n1869#2:300\n1870#2:302\n1626#2:303\n1#3:284\n1#3:290\n1#3:301\n*S KotlinDebug\n*F\n+ 1 StimulusReferences.kt\ncom/intellij/stimulus/lang/StimulusReferencesKt\n*L\n99#1:274,9\n99#1:283\n99#1:285\n99#1:286\n100#1:287\n100#1:288,2\n120#1:291,9\n120#1:300\n120#1:302\n120#1:303\n99#1:284\n120#1:301\n*E\n"})
public final class StimulusReferencesKt {
    @NotNull
    public static final String dataControllerName = "data-controller";
    @NotNull
    public static final String dataActionName = "data-action";
    @NotNull
    public static final String dataTargetName = "data-target";
    @NotNull
    private static final String CONTROLLERS = "controllers";

    @Nullable
    public static final PsiElement resolveController(@NotNull String name, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List filesByNames = CollectionsKt.plus((Collection)StimulusReferencesKt.findControllersByName(context, name, "ts"), (Iterable)StimulusReferencesKt.findControllersByName(context, name, "js"));
        return (PsiElement)CollectionsKt.firstOrNull((List)filesByNames);
    }

    @NotNull
    public static final String toControllerName(@NotNull PsiFile file) {
        VirtualFile parent;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String name = StringsKt.replace$default((String)UtilKt.trimControllerPostfix(file), (char)'_', (char)'-', (boolean)false, (int)4, null);
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return name;
        }
        VirtualFile virtualFile2 = virtualFile;
        VirtualFile virtualFile3 = virtualFile2.getParent();
        if (virtualFile3 == null) {
            return name;
        }
        VirtualFile startParent = virtualFile3;
        String controllersDirectory = CONTROLLERS;
        if (Intrinsics.areEqual((Object)startParent.getName(), (Object)controllersDirectory)) {
            return name;
        }
        for (parent = startParent; parent != null && !Intrinsics.areEqual((Object)parent.getName(), (Object)controllersDirectory); parent = parent.getParent()) {
        }
        if (parent != null) {
            String string = VfsUtil.getRelativePath((VirtualFile)startParent, (VirtualFile)parent);
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (((CharSequence)it).length() > 0) {
                    return StringsKt.replace$default((String)StringsKt.replace$default((String)it, (char)'_', (char)'-', (boolean)false, (int)4, null), (String)".", (String)"--", (boolean)false, (int)4, null) + "--" + name;
                }
            }
        }
        return name;
    }

    @NotNull
    public static final List<Pair<XmlTag, JSClass>> getContextControllers(@NotNull XmlTag contextTag) {
        Intrinsics.checkNotNullParameter((Object)contextTag, (String)"contextTag");
        return SequencesKt.toList((Sequence)SequencesKt.flatten((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)contextTag, StimulusReferencesKt::getContextControllers$lambda$0), StimulusReferencesKt::getContextControllers$lambda$1)));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<JSFile> findControllersByName(PsiElement context, String name, String extension) {
        Collection collection;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Collection collection2 = FilenameIndex.getVirtualFilesByName((String)(StringsKt.replace$default((String)(StimulusReferencesKt.trimPrefix(name) + "_controller."), (char)'-', (char)'_', (boolean)false, (int)4, null) + extension), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)context.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getVirtualFilesByName(...)");
        Collection filesWithUnderscore = collection2;
        Collection collection3 = FilenameIndex.getVirtualFilesByName((String)(StimulusReferencesKt.trimPrefix(name) + "-controller." + extension), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)context.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"getVirtualFilesByName(...)");
        Collection filesWithDash = collection3;
        Collection collection4 = FilenameIndex.getVirtualFilesByName((String)(StimulusReferencesKt.trimPrefix(name) + "_controller." + extension), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)context.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"getVirtualFilesByName(...)");
        Collection filesWithDashAndUnderscore = collection4;
        PsiManager manager = context.getManager();
        List files = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)filesWithUnderscore, (Iterable)filesWithDash), (Iterable)filesWithDashAndUnderscore);
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JSFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            PsiFile psiFile = manager.findFile(it);
            if ((psiFile instanceof JSFile ? (JSFile)psiFile : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List mappedFiles = (List)destination$iv$iv;
        Iterable $this$filter$iv = mappedFiles;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JSFile it = (JSFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)StimulusReferencesKt.toControllerName((PsiFile)it), (Object)name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection5 = (List)destination$iv$iv;
        if (collection5.isEmpty()) {
            boolean bl = false;
            collection = mappedFiles;
        } else {
            collection = collection5;
        }
        return (List)collection;
    }

    private static final String trimPrefix(String name) {
        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)name, (String)"--", (int)0, (boolean)false, (int)6, null);
        if (lastIndex <= 0) {
            return name;
        }
        String string = name.substring(lastIndex + 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public static final List<JSFile> getAllControllers(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GlobalSearchScope globalSearchScope = DelegatingGlobalSearchScope.projectScope((Project)context.getProject());
        DelegatingGlobalSearchScope scope2 = new DelegatingGlobalSearchScope(globalSearchScope){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean contains(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!super.contains(file)) return false;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!UtilKt.isControllerFile(string)) return false;
                return true;
            }
        };
        FileType fileType = (FileType)JavaScriptFileType.INSTANCE;
        PsiManager psiManager = context.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getManager(...)");
        Collection collection = StimulusReferencesKt.getAllControllers(fileType, psiManager, (GlobalSearchScope)scope2);
        FileType fileType2 = (FileType)TypeScriptFileType.INSTANCE;
        PsiManager psiManager2 = context.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getManager(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)StimulusReferencesKt.getAllControllers(fileType2, psiManager2, (GlobalSearchScope)scope2));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<JSFile> getAllControllers(FileType fileType, PsiManager manager, GlobalSearchScope scope2) {
        void $this$mapNotNullTo$iv$iv;
        Collection collection = FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)scope2);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            JSFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            PsiFile psiFile = manager.findFile(it);
            if ((psiFile instanceof JSFile ? (JSFile)psiFile : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final XmlTag getContextControllers$lambda$0(XmlTag it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParentTag();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Sequence getContextControllers$lambda$1(XmlTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        XmlAttribute xmlAttribute = tag.getAttribute(dataControllerName);
        if (xmlAttribute == null) {
            return null;
        }
        XmlAttribute attribute = xmlAttribute;
        String string = attribute.getValue();
        if (string == null) return null;
        String value = string;
        boolean bl = false;
        String[] stringArray = new String[]{" "};
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StringsKt.splitToSequence$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (Function1)getContextControllers.2.1.1.INSTANCE), arg_0 -> StimulusReferencesKt.getContextControllers$lambda$1$0$0(tag, arg_0));
        if (sequence == null) return null;
        Sequence sequence2 = SequencesKt.mapNotNull((Sequence)sequence, StimulusReferencesKt::getContextControllers$lambda$1$1);
        if (sequence2 == null) return null;
        Sequence sequence3 = SequencesKt.map((Sequence)sequence2, arg_0 -> StimulusReferencesKt.getContextControllers$lambda$1$2(tag, arg_0));
        return sequence3;
    }

    private static final PsiElement getContextControllers$lambda$1$0$0(XmlTag $tag, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StimulusReferencesKt.resolveController(it, (PsiElement)$tag);
    }

    private static final JSClass getContextControllers$lambda$1$1(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof JSFile ? (JSClass)PsiTreeUtil.findChildOfType((PsiElement)it, JSClass.class) : null;
    }

    private static final Pair getContextControllers$lambda$1$2(XmlTag $tag, JSClass it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TuplesKt.to((Object)$tag, (Object)it);
    }
}

