/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.stimulus.UtilKt;
import com.intellij.stimulus.lang.StimulusChildReference;
import com.intellij.stimulus.lang.StimulusControllerReference;
import com.intellij.stimulus.lang.StimulusTargetFakePsiElement;
import com.intellij.stimulus.lang.js.StimulusClassFieldReference;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/stimulus/lang/StimulusReferenceSearch;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "getSearchWords", "", "", "elementToSearch", "Lcom/intellij/psi/PsiElement;", "intellij.stimulus"})
final class StimulusReferenceSearch
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public StimulusReferenceSearch() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement elementToSearch;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
                Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                PsiElement psiElement = queryParameters.getElementToSearch();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
                elementToSearch = psiElement;
                PsiFile containingFile = elementToSearch.getContainingFile();
                if (containingFile == null || !(containingFile.getLanguage() instanceof JSLanguageDialect)) break block5;
                String string = containingFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (UtilKt.isControllerFile(string) && UtilKt.isStimulusContext(elementToSearch)) break block6;
            }
            return;
        }
        List<String> searchWords = this.getSearchWords(elementToSearch);
        if (searchWords.isEmpty()) {
            return;
        }
        Object[] objectArray = new Object[]{};
        RequestResultProcessor requestResultProcessor2 = new RequestResultProcessor(elementToSearch, objectArray){
            final /* synthetic */ PsiElement $elementToSearch;
            {
                this.$elementToSearch = $elementToSearch;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public boolean processTextOccurrence(PsiElement element, int offsetInElement, Processor<? super PsiReference> consumer) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
                if (!(element instanceof XmlAttributeValue || element instanceof XmlAttribute || element instanceof JSReferenceExpression)) {
                    return true;
                }
                List list = PsiReferenceService.getService().getReferences(element, PsiReferenceService.Hints.NO_HINTS);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getReferences(...)");
                Collection collection = list;
                PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)element, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferencesFromProviders(...)");
                Iterable iterable = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)collection, (Iterable)ArraysKt.asList((Object[])psiReferenceArray)));
                boolean $i$f$filter = false;
                void var7_7 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    PsiReference it = (PsiReference)element$iv$iv;
                    boolean bl = false;
                    if (!(it instanceof StimulusControllerReference || it instanceof StimulusChildReference || it instanceof StimulusClassFieldReference)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List references = (List)destination$iv$iv;
                for (PsiReference reference : references) {
                    if (!reference.isReferenceTo(this.$elementToSearch) || consumer.process((Object)reference)) continue;
                    return false;
                }
                return true;
            }
        };
        for (String searchWord : searchWords) {
            queryParameters.getOptimizer().searchWord(searchWord, elementToSearch.getUseScope(), (short)255, true, elementToSearch, requestResultProcessor2);
        }
    }

    private final List<String> getSearchWords(PsiElement elementToSearch) {
        List list;
        PsiElement psiElement = elementToSearch;
        if (psiElement instanceof JSFile) {
            list = CollectionsKt.listOf((Object)JSStringUtil.toKebabCase((String)UtilKt.trimControllerPostfix((PsiFile)elementToSearch), (boolean)true, (boolean)true, (boolean)false));
        } else if (psiElement instanceof JSLiteralExpression) {
            Object[] objectArray = new String[2];
            String string = ((JSLiteralExpression)elementToSearch).getStringValue();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            objectArray[1] = ((JSLiteralExpression)elementToSearch).getStringValue() + "Target";
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (psiElement instanceof StimulusTargetFakePsiElement) {
            list = this.getSearchWords((PsiElement)((StimulusTargetFakePsiElement)elementToSearch).getParent());
        } else if (psiElement instanceof JSProperty) {
            Object[] objectArray = new String[2];
            Intrinsics.checkNotNullExpressionValue((Object)JSStringUtil.toKebabCase((String)((JSProperty)elementToSearch).getName(), (boolean)true, (boolean)true, (boolean)false), (String)"toKebabCase(...)");
            objectArray[1] = ((JSProperty)elementToSearch).getName() + "Value";
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

