/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.stimulus.UtilKt;
import com.intellij.stimulus.lang.StimulusReferencesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0013\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/stimulus/lang/StimulusControllerReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "name", "", "psiElement", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "resolve", "isReferenceTo", "", "element", "getVariants", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "()[Lcom/intellij/codeInsight/lookup/LookupElement;", "handleElementRename", "newElementName", "intellij.stimulus"})
@SourceDebugExtension(value={"SMAP\nStimulusReferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StimulusReferences.kt\ncom/intellij/stimulus/lang/StimulusControllerReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,273:1\n1563#2:274\n1634#2,3:275\n1563#2:278\n1634#2,3:279\n37#3,2:282\n*S KotlinDebug\n*F\n+ 1 StimulusReferences.kt\ncom/intellij/stimulus/lang/StimulusControllerReference\n*L\n132#1:274\n132#1:275,3\n133#1:278\n133#1:279,3\n134#1:282,2\n*E\n"})
public final class StimulusControllerReference
extends PsiReferenceBase<PsiElement> {
    @NotNull
    private final String name;

    public StimulusControllerReference(@NotNull String name, @NotNull PsiElement psiElement, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(psiElement, range, true);
        this.name = name;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        return StimulusReferencesKt.resolveController(this.name, psiElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isReferenceTo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof JSFile)) return false;
        String string = ((JSFile)element).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!UtilKt.isControllerFile(string)) return false;
        if (!super.isReferenceTo(element)) return false;
        return true;
    }

    @NotNull
    public LookupElement[] getVariants() {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        Iterable $this$map$iv = StimulusReferencesKt.getAllControllers(psiElement);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JSFile jSFile = (JSFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StimulusReferencesKt.toControllerName((PsiFile)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LookupElementBuilder.create((String)it).withIcon(AllIcons.Nodes.Class));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LookupElement[0]);
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        String controllerName = UtilKt.trimControllerPostfix(newElementName);
        PsiElement psiElement2 = this.myElement;
        if (psiElement2 instanceof XmlAttributeValue) {
            XmlAttribute parentAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlAttribute.class);
            if (parentAttribute == null) {
                return null;
            }
            String string = this.myElement.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = this.getRangeInElement().getEndOffset();
            int n2 = this.myElement.getTextLength() - 1;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String newValueText = controllerName + string3;
            XmlAttribute xmlAttribute = XmlElementFactory.getInstance((Project)this.myElement.getProject()).createAttribute(parentAttribute.getName(), newValueText, (PsiElement)parentAttribute);
            Intrinsics.checkNotNullExpressionValue((Object)xmlAttribute, (String)"createAttribute(...)");
            XmlAttribute newElement = xmlAttribute;
            psiElement = parentAttribute.replace((PsiElement)newElement);
        } else if (psiElement2 instanceof XmlAttribute) {
            PsiElement psiElement3 = this.myElement;
            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlAttribute");
            XmlAttribute xmlAttribute = (XmlAttribute)psiElement3;
            String xmlAttributeValue = xmlAttribute.getValue();
            if (xmlAttributeValue == null) {
                return null;
            }
            String string = xmlAttribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string4 = string;
            int n = 0;
            int n3 = this.getRangeInElement().getStartOffset();
            String string5 = string4.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String string6 = xmlAttribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
            string4 = string6;
            n = this.getRangeInElement().getEndOffset();
            String string7 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            String newNameText = string5 + controllerName + string7;
            XmlAttribute xmlAttribute2 = XmlElementFactory.getInstance((Project)this.myElement.getProject()).createAttribute(newNameText, xmlAttributeValue, (PsiElement)xmlAttribute);
            Intrinsics.checkNotNullExpressionValue((Object)xmlAttribute2, (String)"createAttribute(...)");
            XmlAttribute newElement = xmlAttribute2;
            psiElement = xmlAttribute.replace((PsiElement)newElement);
        } else {
            psiElement = null;
        }
        return psiElement;
    }
}

