/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stimulus.lang;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.stimulus.lang.StimulusActionReference;
import com.intellij.stimulus.lang.StimulusChildReference;
import com.intellij.stimulus.lang.StimulusControllerReference;
import com.intellij.stimulus.lang.StimulusReferenceContributorKt;
import com.intellij.stimulus.lang.StimulusTargetReference;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/stimulus/lang/ActionOrTargetReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "intellij.stimulus"})
final class ActionOrTargetReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StimulusReferenceContributorKt.multiValueAttributeReferenceMapper(element, (Function2<? super String, ? super TextRange, ? extends List<? extends PsiReference>>)((Function2)(arg_0, arg_1) -> ActionOrTargetReferenceProvider.getReferencesByElement$lambda$0(element, arg_0, arg_1)));
    }

    private static final List getReferencesByElement$lambda$0(PsiElement $element, String part, TextRange range) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int actionSeparatorIndex = StringsKt.indexOf$default((CharSequence)part, (String)"->", (int)0, (boolean)false, (int)6, null);
        int methodStart = StringsKt.indexOf$default((CharSequence)part, (String)"#", (int)0, (boolean)false, (int)6, null);
        int targetStart = StringsKt.indexOf$default((CharSequence)part, (String)".", (int)0, (boolean)false, (int)6, null);
        int controllerEnd = Math.max(methodStart, targetStart);
        int controllerStartIndex = actionSeparatorIndex > 0 ? actionSeparatorIndex + 2 : 0;
        String string = part.substring(controllerStartIndex, controllerEnd > 0 ? controllerEnd : part.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String controllerName = string;
        int methodOrTargetEnd = controllerEnd > 0 ? StringsKt.indexOf$default((CharSequence)part, (String)":", (int)controllerEnd, (boolean)false, (int)4, null) : -1;
        int controllerNameStartAbsolute = range.getStartOffset() + controllerStartIndex;
        int controllerNameEndAbsolute = controllerNameStartAbsolute + controllerName.length();
        StimulusControllerReference parentRef = new StimulusControllerReference(controllerName, $element, new TextRange(controllerNameStartAbsolute, controllerNameEndAbsolute));
        if (controllerEnd <= 0) {
            return CollectionsKt.listOf((Object)((Object)parentRef));
        }
        String string2 = part.substring(controllerEnd + 1, methodOrTargetEnd > 0 ? methodOrTargetEnd : part.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String childName = string2;
        int childNameStartAbsolute = range.getStartOffset() + controllerEnd + 1;
        int childNameEndAbsolute = childNameStartAbsolute + childName.length();
        TextRange childRange = new TextRange(childNameStartAbsolute, childNameEndAbsolute);
        StimulusChildReference childRef = methodStart > 0 ? (StimulusChildReference)new StimulusActionReference(childName, (PsiReference)parentRef, $element, childRange) : (StimulusChildReference)new StimulusTargetReference(childName, (PsiReference)parentRef, $element, childRange);
        Object[] objectArray = new PsiReferenceBase[]{parentRef, childRef};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

