/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyVMOptions {
    public static final String RUBY_DEBUG_PARSER = "ruby.debug.parser";
    public static final String FILESET_PATTERN = "fileset.pattern";
    public static final String CONSOLE_CUSTOM_ENCODING = "console.encoding";
    private static final String FORCED_LANGUAGE_LEVEL = "forced.ruby.language.level";
    private static final String RUBY_RUNNER_SYNC_IO_ARGS = "ruby.runner.sync.io.args";
    private static final String RUBY_RUNNER_IRB_WIN_SYNC_IO_ARGS = "ruby.runner.irb.win.sync.io.args";
    private static final String RUBY_RUNNER_TESTUINT_RUN_CLASS_SYNC_IO_ARGS = "ruby.runner.testunit.class.sync.io.args";
    private static final String FORCE_JRUBY_JIT = "force.jruby.jit";
    private static final String JRUBY_DEBUG = "debug.jruby";
    private static final String RUBY_GEM_SCANNER = "ruby.gem.scanner";
    private static final String RUBY_AUTO_BUNDLER_EMULATION_DISABLED = "ruby.bundler.auto.emulation";
    @Deprecated
    private static final String RAKE_TASK_LIST_FETCHING_DISABLED = "ruby.rake.tasks.fetching";
    private static final String RUBYMINE_TESTFRAMEWORK_RAILS_VERSION_DEPENDENCY_PROPERTY = "rubymine.testframework.rails.version";
    private static final String RUBYMINE_REQUIRES_WITH_SUBSTITUTION = "rubymine.requires.with.substitution";
    public static final String RUBY_DEBUGGER_INT_HANDLER_DISABLED = "rubymine.debugger.int.handler.disabled";

    private RubyVMOptions() {
    }

    public static RubyVMOptions getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static boolean shouldForceJIT() {
        return "true".equals(System.getProperty(FORCE_JRUBY_JIT));
    }

    public static boolean enableJRubyDebug() {
        return "true".equals(System.getProperty(JRUBY_DEBUG));
    }

    public boolean isLanguageLevelEnabled(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            RubyVMOptions.$$$reportNull$$$0(0);
        }
        LanguageLevel forcedLanguageLevel = this.getForcedLanguageLevel();
        if (languageLevel != LanguageLevel.latest()) {
            return forcedLanguageLevel == languageLevel;
        }
        return forcedLanguageLevel == null || forcedLanguageLevel == LanguageLevel.latest();
    }

    @Deprecated
    public boolean isRuby18Enabled(@Nullable LanguageLevel languageLevel) {
        LanguageLevel forcedLanguageLevel = this.getForcedLanguageLevel();
        return forcedLanguageLevel == LanguageLevel.RUBY18 || forcedLanguageLevel == null && languageLevel == LanguageLevel.RUBY18;
    }

    public void forceLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            RubyVMOptions.$$$reportNull$$$0(1);
        }
        if (languageLevel == LanguageLevel.latest()) {
            RubyVMOptions.resetForcedLanguageLevel();
        } else {
            System.setProperty(FORCED_LANGUAGE_LEVEL, languageLevel.toString());
        }
    }

    public static void resetForcedLanguageLevel() {
        System.clearProperty(FORCED_LANGUAGE_LEVEL);
    }

    @Nullable
    public LanguageLevel getForcedLanguageLevel() {
        String property = System.getProperty(FORCED_LANGUAGE_LEVEL);
        if (StringUtil.isNotEmpty((String)property)) {
            return LanguageLevel.fromString(property);
        }
        return null;
    }

    @Nullable
    public static String getSyncIoArgsProperty() {
        return System.getProperty(RUBY_RUNNER_SYNC_IO_ARGS);
    }

    @Nullable
    public static String getConsoleCustomEncodingProperty() {
        return System.getProperty(CONSOLE_CUSTOM_ENCODING);
    }

    @Nullable
    public static String getIrbWinSyncIoArgsProperty() {
        return System.getProperty(RUBY_RUNNER_IRB_WIN_SYNC_IO_ARGS);
    }

    @Nullable
    public static String getTestUnitClassSyncIoArgsProperty() {
        return System.getProperty(RUBY_RUNNER_TESTUINT_RUN_CLASS_SYNC_IO_ARGS);
    }

    public static boolean isAutoBundlerEmulationDisabled() {
        return RubyVMOptions.isPropertyDisabled(RUBY_AUTO_BUNDLER_EMULATION_DISABLED);
    }

    @Deprecated
    public static boolean isRakeTasksListFetchingDisabled() {
        return RubyVMOptions.isPropertyDisabled(RAKE_TASK_LIST_FETCHING_DISABLED);
    }

    private static boolean isPropertyDisabled(String propertyName) {
        String value = System.getProperty(propertyName);
        return "false".equalsIgnoreCase(value) || "disabled".equalsIgnoreCase(value);
    }

    public static boolean disableGemsScanner() {
        return RubyVMOptions.isPropertyDisabled(RUBY_GEM_SCANNER);
    }

    public static String getTestRailsVersion() {
        return System.getProperty(RUBYMINE_TESTFRAMEWORK_RAILS_VERSION_DEPENDENCY_PROPERTY);
    }

    public static boolean evaluateAllRequires() {
        return "full".equalsIgnoreCase(System.getProperty(RUBYMINE_REQUIRES_WITH_SUBSTITUTION, "project"));
    }

    public static boolean isDisableDebuggerIntHandler() {
        return !"false".equalsIgnoreCase(System.getProperty(RUBY_DEBUGGER_INT_HANDLER_DISABLED));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "languageLevel";
        objectArray2[1] = "org/jetbrains/plugins/ruby/RubyVMOptions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isLanguageLevelEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "forceLanguageLevel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SingletonHolder {
        private static final RubyVMOptions INSTANCE = new RubyVMOptions();

        private SingletonHolder() {
        }
    }
}

