/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.SftpChannelException;
import com.intellij.ssh.SftpChannelNoSuchFileException;
import com.intellij.ssh.impl.sshj.SshjRemoteFileObjectKt;
import com.intellij.ssh.impl.sshj.UtilKt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0006\u0010\u0011\u001a\u00020\u000fJ\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ssh/impl/sshj/SshjLazyLstatHolder;", "", "sftp", "Lnet/schmizz/sshj/sftp/SFTPClient;", "path", "", "value", "Lnet/schmizz/sshj/sftp/FileAttributes;", "surelyImaginary", "", "SshjLazyLstatHolder", "(Lnet/schmizz/sshj/sftp/SFTPClient;Ljava/lang/String;Lnet/schmizz/sshj/sftp/FileAttributes;Z)V", "error", "Lcom/intellij/ssh/SftpChannelException;", "v", "", "logNoSuchFileError", "clear", "getOrThrow", "isFileExist", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjRemoteFileObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjLazyLstatHolder\n+ 2 Util.kt\ncom/intellij/ssh/impl/sshj/UtilKt\n+ 3 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjRemoteFileObjectKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n41#2,6:249\n48#2,28:270\n233#3,15:255\n1#4:298\n*S KotlinDebug\n*F\n+ 1 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjLazyLstatHolder\n*L\n195#1:249,6\n195#1:270,28\n196#1:255,15\n*E\n"})
final class SshjLazyLstatHolder {
    @NotNull
    private final SFTPClient sftp;
    @NotNull
    private final String path;
    @Nullable
    private FileAttributes value;
    @Nullable
    private SftpChannelException error;

    public SshjLazyLstatHolder(@NotNull SFTPClient sftp, @NotNull String path2, @Nullable FileAttributes value, boolean surelyImaginary) {
        Intrinsics.checkNotNullParameter((Object)sftp, (String)"sftp");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.sftp = sftp;
        this.path = path2;
        this.value = value;
        this.error = surelyImaginary ? (SftpChannelException)new SftpChannelNoSuchFileException(this.path + " was created as surely imaginary file", new Throwable()) : null;
    }

    public /* synthetic */ SshjLazyLstatHolder(SFTPClient sFTPClient, String string, FileAttributes fileAttributes, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(sFTPClient, string, fileAttributes, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void v(boolean bl) {
        SshjLazyLstatHolder sshjLazyLstatHolder = this;
        synchronized (sshjLazyLstatHolder) {
            boolean bl2;
            boolean bl3 = false;
            if (this.value == null && this.error == null) {
                try {
                    FileAttributes fileAttributes;
                    String string = this.path;
                    boolean bl4 = bl;
                    SshjLazyLstatHolder sshjLazyLstatHolder2 = this;
                    boolean bl5 = true;
                    boolean bl6 = false;
                    boolean bl7 = bl4;
                    boolean bl8 = bl5;
                    boolean bl9 = false;
                    try {
                        FileAttributes fileAttributes2;
                        boolean bl10 = false;
                        boolean bl11 = false;
                        if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                            boolean bl12 = false;
                            fileAttributes2 = this.sftp.lstat(this.path);
                        } else {
                            FileAttributes fileAttributes3;
                            long l = System.nanoTime();
                            String string2 = "ok";
                            try {
                                boolean bl13 = false;
                                fileAttributes3 = this.sftp.lstat(this.path);
                            }
                            catch (Throwable throwable) {
                                string2 = "exception";
                                throw throwable;
                            }
                            finally {
                                long l2 = System.nanoTime();
                                Logger logger = UtilKt.getSSHJ_LOG();
                                boolean bl14 = false;
                                logger.debug("Called " + ("sftp.lstat(" + this.path + ")") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string2 + ")");
                            }
                            fileAttributes2 = fileAttributes3;
                        }
                        fileAttributes = fileAttributes2;
                    }
                    catch (SFTPException sFTPException) {
                        Object object = (IOException)((Object)sFTPException);
                        boolean bl15 = false;
                        object = "File " + string + ": " + ((Throwable)object).getMessage();
                        Response.StatusCode statusCode = sFTPException.getStatusCode();
                        switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                            case 1: {
                                if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                                    UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                                }
                                UtilKt.getSSHJ_LOG().info((String)object);
                                break;
                            }
                            case 2: {
                                if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                                    UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                                }
                                if (!bl7) break;
                                UtilKt.getSSHJ_LOG().warn((String)object);
                                break;
                            }
                            default: {
                                UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                            }
                        }
                        throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
                    }
                    catch (IOException iOException) {
                        IOException iOException2 = iOException;
                        boolean bl16 = false;
                        String string3 = "File " + string + ": " + iOException2.getMessage();
                        UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
                        throw SftpChannelException.Companion.create(-1, string3, iOException);
                    }
                    sshjLazyLstatHolder2.value = fileAttributes;
                    UtilKt.getSSHJ_LOG().debug("Fetched and cached permissions of " + this.path + ": " + this.value);
                }
                catch (SftpChannelNoSuchFileException sftpChannelNoSuchFileException) {
                    this.error = sftpChannelNoSuchFileException;
                }
            }
            boolean bl17 = bl2 = this.value == null != (this.error == null);
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        SshjLazyLstatHolder sshjLazyLstatHolder = this;
        synchronized (sshjLazyLstatHolder) {
            boolean bl = false;
            if (this.value != null || this.error != null) {
                UtilKt.getSSHJ_LOG().debug("Clearing permission cache of " + this.path);
                this.value = null;
                this.error = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final FileAttributes getOrThrow() {
        this.v(true);
        FileAttributes fileAttributes = this.value;
        if (fileAttributes != null) {
            FileAttributes fileAttributes2 = fileAttributes;
            boolean bl = false;
            return fileAttributes2;
        }
        SftpChannelException sftpChannelException = this.error;
        Intrinsics.checkNotNull((Object)((Object)sftpChannelException));
        throw sftpChannelException;
    }

    public final boolean isFileExist() {
        boolean bl;
        this.v(false);
        SftpChannelException sftpChannelException = this.error;
        if (sftpChannelException == null) {
            bl = true;
        } else if (sftpChannelException instanceof SftpChannelNoSuchFileException) {
            bl = false;
        } else {
            throw sftpChannelException;
        }
        return bl;
    }
}

