/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CsBundle;
import org.coffeescript.refactoring.surround.CoffeeScriptBaseSurrounder;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptWithTryCatchSurrounder
extends CoffeeScriptBaseSurrounder {
    @Override
    protected String getStatementTemplate(PsiElement context) {
        return "try\n  body\ncatch error\n  error_handling_code";
    }

    @Override
    @NotNull
    protected ASTNode getNodeToReplace(ASTNode surroundedNode) {
        JSTryStatement tryStatement = (JSTryStatement)surroundedNode.getPsi();
        ASTNode aSTNode = tryStatement.getStatement().getChildren()[0].getNode();
        if (aSTNode == null) {
            CoffeeScriptWithTryCatchSurrounder.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSTryStatement tryStatement = (JSTryStatement)statementNode.getPsi();
        ASTNode errorNode = tryStatement.getAllCatchBlocks()[0].getStatement().getNode();
        int startOffset = errorNode.getStartOffset();
        int endOffset = startOffset + errorNode.getTextLength();
        return new TextRange(startOffset, endOffset);
    }

    public String getTemplateDescription() {
        return CsBundle.message("surrounder.try.catch", new Object[0]);
    }

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            CoffeeScriptWithTryCatchSurrounder.$$$reportNull$$$0(1);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/refactoring/surround/CoffeeScriptWithTryCatchSurrounder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeToReplace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/refactoring/surround/CoffeeScriptWithTryCatchSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

