/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CsBundle;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.coffeescript.refactoring.surround.CoffeeScriptBaseSurrounder;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptWithIfElseSurrounder
extends CoffeeScriptBaseSurrounder {
    @Override
    protected String getStatementTemplate(PsiElement context) {
        return "if condition \n  body\nelse";
    }

    @Override
    @NotNull
    protected ASTNode getNodeToReplace(ASTNode surroundedNode) {
        ASTNode aSTNode = surroundedNode.findChildByType(CoffeeScriptElementTypes.INDENT_BLOCK).getFirstChildNode();
        if (aSTNode == null) {
            CoffeeScriptWithIfElseSurrounder.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSIfStatement ifStatement = (JSIfStatement)statementNode.getPsi();
        int startOffset = ifStatement.getCondition().getTextOffset();
        int endOffset = startOffset + ifStatement.getCondition().getTextLength();
        return new TextRange(startOffset, endOffset);
    }

    public String getTemplateDescription() {
        return CsBundle.message("surrounder.if.else", new Object[0]);
    }

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            CoffeeScriptWithIfElseSurrounder.$$$reportNull$$$0(1);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/refactoring/surround/CoffeeScriptWithIfElseSurrounder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeToReplace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/refactoring/surround/CoffeeScriptWithIfElseSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

