/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.coffeescript.CsBundle;
import org.coffeescript.file.CoffeeScriptFileType;
import org.coffeescript.refactoring.CoffeeScriptChangeUtil;
import org.coffeescript.refactoring.CoffeeScriptIntroduceHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptIntroduceParameterHandler
extends CoffeeScriptIntroduceHandler {
    @Override
    protected void processIntroduce(final @NotNull Editor editor, final @NotNull PsiElement element) {
        if (editor == null) {
            CoffeeScriptIntroduceParameterHandler.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CoffeeScriptIntroduceParameterHandler.$$$reportNull$$$0(1);
        }
        ArrayList<JSFunctionExpression> functions = new ArrayList<JSFunctionExpression>();
        JSFunctionExpression function = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSFunctionExpression.class);
        while (function != null) {
            functions.add(function);
            function = (JSFunctionExpression)PsiTreeUtil.getParentOfType((PsiElement)function, JSFunctionExpression.class);
        }
        if (functions.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)CsBundle.message("refactorings.introduce.cant.introduce.message", new Object[0]), (String)CsBundle.message("refactorings.introduce.cant.introduce.title", new Object[0]), (String)"refactoring.extract.variable.coffeescript");
        } else if (functions.size() == 1) {
            CoffeeScriptIntroduceParameterHandler.processIntroduce(editor, element, (JSFunctionExpression)functions.get(0));
        } else {
            Pass<JSFunctionExpression> callback = new Pass<JSFunctionExpression>(this){

                public void pass(JSFunctionExpression selectedValue) {
                    CoffeeScriptIntroduceParameterHandler.processIntroduce(editor, element, selectedValue);
                }
            };
            IntroduceTargetChooser.showChooser((Editor)editor, functions, (Pass)callback, jsExpression -> {
                ItemPresentation presentation = jsExpression.getPresentation();
                if (presentation != null) {
                    return presentation.getPresentableText();
                }
                return "Function";
            }, (String)CsBundle.message("dialog.title.target.function", new Object[0]));
        }
    }

    private static void processIntroduce(@NotNull Editor editor, @NotNull PsiElement element, @NotNull JSFunctionExpression functionExpression) {
        if (editor == null) {
            CoffeeScriptIntroduceParameterHandler.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CoffeeScriptIntroduceParameterHandler.$$$reportNull$$$0(3);
        }
        if (functionExpression == null) {
            CoffeeScriptIntroduceParameterHandler.$$$reportNull$$$0(4);
        }
        JSParameterList parameterList = functionExpression.getParameterList();
        String parametersBefore = functionExpression.getParameterList() == null || functionExpression.getParameters().length == 0 ? "" : "before, ";
        JSExpressionStatement statement = (JSExpressionStatement)CoffeeScriptChangeUtil.createElementFromText(String.format("(%sparameter = %s) ->", parametersBefore, element.getText()), (FileType)CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE, element.getProject());
        assert (statement != null);
        JSFunctionExpression dummyFunction = (JSFunctionExpression)statement.getChildren()[0];
        JSParameter parameterToInsert = dummyFunction.getParameterVariables()[dummyFunction.getParameterVariables().length - 1];
        assert (parameterToInsert != null);
        PsiElement parameterReference = CoffeeScriptChangeUtil.createElementFromText("parameter", (FileType)CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE, element.getProject());
        assert (parameterReference != null);
        SmartPsiElementPointer addedParameterPointer = (SmartPsiElementPointer)WriteCommandAction.writeCommandAction((Project)element.getProject(), (PsiFile[])new PsiFile[]{element.getContainingFile()}).compute(() -> {
            element.replace(parameterReference);
            if (parameterList != null) {
                if (parameterList.getParameters().length > 0) {
                    parameterList.addBefore(parameterToInsert.getPrevSibling().getPrevSibling(), parameterList.getLastChild());
                    parameterList.addBefore(parameterToInsert.getPrevSibling(), parameterList.getLastChild());
                }
                parameterList.addBefore((PsiElement)parameterToInsert, parameterList.getLastChild());
            } else {
                functionExpression.addBefore(parameterToInsert.getParent(), functionExpression.getFirstChild());
                functionExpression.addAfter(parameterToInsert.getParent().getNextSibling(), functionExpression.getFirstChild());
            }
            JSParameter insertedParameter = functionExpression.getParameterVariables()[functionExpression.getParameterVariables().length - 1];
            SmartPsiElementPointer resultPointer = SmartPointerManager.getInstance((Project)insertedParameter.getProject()).createSmartPsiElementPointer((PsiElement)insertedParameter);
            return resultPointer;
        });
        JSParameter insertedParameter = (JSParameter)addedParameterPointer.getElement();
        assert (insertedParameter != null);
        final JSVariable updatedParameter = (JSVariable)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)insertedParameter);
        InplaceVariableIntroducer<PsiElement> introducer = new InplaceVariableIntroducer<PsiElement>((PsiNamedElement)updatedParameter, editor, functionExpression.getProject(), CsBundle.message("refactorings.introduce.variable.title", new Object[0]), new PsiElement[]{parameterReference}, null){

            @Nullable
            protected PsiElement checkLocalScope() {
                return updatedParameter.getContainingFile();
            }
        };
        LinkedHashSet<String> variants = new LinkedHashSet<String>();
        variants.add("parameter");
        editor.getCaretModel().moveToOffset(updatedParameter.getTextOffset());
        introducer.performInplaceRefactoring(variants);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "functionExpression";
                break;
            }
        }
        objectArray[1] = "org/coffeescript/refactoring/CoffeeScriptIntroduceParameterHandler";
        objectArray[2] = "processIntroduce";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

