/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import org.coffeescript.lang.lexer.CoffeeScriptFlexLexer;
import org.coffeescript.lang.lexer.CoffeeScriptLiterateLexerPosition;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptLiterateLexer
extends LexerBase {
    private CharSequence myBuffer;
    private int myTokenStart;
    private int myTokenEnd;
    private int myEndOffset;
    private CoffeeScriptLiterateLexerPosition myLexerPosition = new CoffeeScriptLiterateLexerPosition(0, 0, 0, 0, true, false);
    private final CoffeeScriptFlexLexer myCoffeeScriptLexer = new CoffeeScriptFlexLexer();

    @NotNull
    public LexerPosition getCurrentPosition() {
        CoffeeScriptLiterateLexerPosition result = this.myLexerPosition.copy();
        result.setState(this.getState());
        CoffeeScriptLiterateLexerPosition coffeeScriptLiterateLexerPosition = result;
        if (coffeeScriptLiterateLexerPosition == null) {
            CoffeeScriptLiterateLexer.$$$reportNull$$$0(0);
        }
        return coffeeScriptLiterateLexerPosition;
    }

    public void advance() {
        this.myTokenStart = this.myTokenEnd;
        if (this.myLexerPosition.isLiterateCommentState()) {
            this.myLexerPosition.setLiterateCommentState(false);
            int tokenEnd = this.calculateLiterateCommentEnd(this.myTokenStart);
            if (tokenEnd > this.myTokenStart) {
                this.myTokenEnd = tokenEnd;
                return;
            }
        }
        if (!this.myLexerPosition.isInCoffeeScriptState()) {
            this.myLexerPosition.setInCoffeeScriptState(true);
            this.myLexerPosition.setCoffeeScriptBlockStart(this.myTokenStart);
            this.myLexerPosition.setCoffeeScriptBlockEnd(this.calculateCoffeeScriptBlockEnd(this.myTokenStart));
            this.myCoffeeScriptLexer.start(this.myBuffer, this.myTokenStart, this.myLexerPosition.getCoffeeScriptBlockEnd());
        } else {
            this.myCoffeeScriptLexer.advance();
        }
        this.myTokenEnd = this.myCoffeeScriptLexer.getTokenEnd();
        if (this.myCoffeeScriptLexer.getTokenType() == null && this.myTokenEnd < this.myEndOffset) {
            this.myLexerPosition.setLiterateCommentState(true);
            this.myLexerPosition.setInCoffeeScriptState(false);
            this.advance();
        }
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myLexerPosition.isInCoffeeScriptState()) {
            return this.myCoffeeScriptLexer.getTokenType();
        }
        return CoffeeScriptTokenTypes.BLOCK_COMMENT;
    }

    public int getState() {
        if (this.myEndOffset > 0 && this.myLexerPosition.isInCoffeeScriptState()) {
            return this.myCoffeeScriptLexer.getState() + 1;
        }
        return 0;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            CoffeeScriptLiterateLexer.$$$reportNull$$$0(1);
        }
        this.myBuffer = buffer;
        this.myTokenEnd = this.myTokenStart = startOffset;
        this.myEndOffset = endOffset;
        this.myLexerPosition.setLiterateCommentState(initialState == 0);
        this.myLexerPosition.setInCoffeeScriptState(initialState != 0);
        this.advance();
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            CoffeeScriptLiterateLexer.$$$reportNull$$$0(2);
        }
        super.restore(position);
        CoffeeScriptLiterateLexerPosition lexerPosition = (CoffeeScriptLiterateLexerPosition)position;
        this.myLexerPosition = lexerPosition.copy();
        if (lexerPosition.isInCoffeeScriptState()) {
            this.myCoffeeScriptLexer.start(this.myBuffer, this.myLexerPosition.getCoffeeScriptBlockStart(), this.myLexerPosition.getCoffeeScriptBlockEnd(), lexerPosition.getState() - 1);
        }
    }

    public int getTokenStart() {
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        return this.myTokenEnd;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            CoffeeScriptLiterateLexer.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }

    private int calculateLiterateCommentEnd(int offset) {
        if (offset == 0 && !this.myBuffer.isEmpty() && CoffeeScriptLiterateLexer.isWhitespaceWithoutNewLine(this.myBuffer.charAt(0))) {
            return 0;
        }
        for (int i = offset + 1; i < this.myEndOffset; ++i) {
            if (this.myBuffer.charAt(i - 1) != '\n' || !CoffeeScriptLiterateLexer.isWhitespaceWithoutNewLine(this.myBuffer.charAt(i))) continue;
            while (i > 0 && this.myBuffer.charAt(i - 1) == '\n') {
                --i;
            }
            return i;
        }
        return this.myEndOffset;
    }

    private int calculateCoffeeScriptBlockEnd(int offset) {
        for (int i = offset + 1; i < this.myEndOffset; ++i) {
            if (this.myBuffer.charAt(i - 1) != '\n' || Character.isWhitespace(this.myBuffer.charAt(i))) continue;
            return i;
        }
        return this.myEndOffset;
    }

    private static boolean isWhitespaceWithoutNewLine(char c) {
        return Character.isWhitespace(c) && c != '\n';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/lang/lexer/CoffeeScriptLiterateLexer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPosition";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/lang/lexer/CoffeeScriptLiterateLexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

