/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.highlighter;

import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.highlighter.CoffeeScriptHighlightingLexer;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptSyntaxHighlighter
extends JSHighlighter {
    private static final Map<IElementType, TextAttributesKey> TOKENS_TO_STYLES;
    private static final Map<IElementType, TextAttributesKey> XML_HIGHLIGHTING_MAP;
    static final TextAttributesKey BAD_CHARACTER;
    static final TextAttributesKey SEMICOLON;
    static final TextAttributesKey COMMA;
    static final TextAttributesKey DOT;
    public static final TextAttributesKey CLASS_NAME;
    public static final TextAttributesKey IDENTIFIER;
    public static final TextAttributesKey FUNCTION_NAME;
    public static final TextAttributesKey OBJECT_KEY;
    public static final TextAttributesKey PARAMETER;
    public static final TextAttributesKey LOCAL_VARIABLE;
    public static final TextAttributesKey GLOBAL_VARIABLE;
    static final TextAttributesKey NUMBER;
    static final TextAttributesKey BOOLEAN;
    static final TextAttributesKey STRING_LITERAL;
    static final TextAttributesKey HEREDOC_ID;
    static final TextAttributesKey HEREDOC_CONTENT;
    static final TextAttributesKey HEREGEX_ID;
    static final TextAttributesKey HEREGEX_CONTENT;
    static final TextAttributesKey JAVASCRIPT_INJECTION_QUOTE;
    static final TextAttributesKey JAVASCRIPT_INJECTION;
    static final TextAttributesKey EXPRESSIONS_SUBSTITUTION_MARK;
    static final TextAttributesKey LINE_COMMENT;
    static final TextAttributesKey BLOCK_COMMENT;
    static final TextAttributesKey PARENTHESIS;
    static final TextAttributesKey BRACKETS;
    static final TextAttributesKey BRACES;
    public static final TextAttributesKey OPERATIONS;
    static final TextAttributesKey EXISTENTIAL;
    public static final TextAttributesKey KEYWORD;
    static final TextAttributesKey RANGE;
    static final TextAttributesKey SPLAT;
    static final TextAttributesKey THIS;
    static final TextAttributesKey COLON;
    static final TextAttributesKey PROTOTYPE;
    static final TextAttributesKey FUNCTION_ARROW;
    static final TextAttributesKey FUNCTION_BINDING_ARROW;
    static final TextAttributesKey REGULAR_EXPRESSION_ID;
    static final TextAttributesKey REGULAR_EXPRESSION_CONTENT;
    static final TextAttributesKey REGULAR_EXPRESSION_FLAG;
    static final TextAttributesKey ESCAPE_SEQUENCE;
    private static final Map<TextAttributesKey, TextAttributesKey> ourJsToCoffeeKeyMap;

    public CoffeeScriptSyntaxHighlighter() {
        super(CoffeeScriptLanguage.INSTANCE.getOptionHolder());
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new CoffeeScriptHighlightingLexer();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = CoffeeScriptSyntaxHighlighter.pack((TextAttributesKey)TOKENS_TO_STYLES.get(tokenType), (TextAttributesKey)XML_HIGHLIGHTING_MAP.get(tokenType));
        if (textAttributesKeyArray == null) {
            CoffeeScriptSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public TextAttributesKey getMappedKey(@NotNull TextAttributesKey original) {
        if (original == null) {
            CoffeeScriptSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        TextAttributesKey textAttributesKey = ourJsToCoffeeKeyMap.getOrDefault(original, original);
        if (textAttributesKey == null) {
            CoffeeScriptSyntaxHighlighter.$$$reportNull$$$0(2);
        }
        return textAttributesKey;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_8;
        BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.BAD_CHARACTER", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
        SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.SEMICOLON", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
        COMMA = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        DOT = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
        CLASS_NAME = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.CLASS_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        FUNCTION_NAME = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.FUNCTION_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
        OBJECT_KEY = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.OBJECT_KEY", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
        PARAMETER = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
        LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.LOCAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_LOCAL_VARIABLE);
        GLOBAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.GLOBAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_GLOBAL_VARIABLE);
        NUMBER = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        BOOLEAN = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.BOOLEAN", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        STRING_LITERAL = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.STRING_LITERAL", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        HEREDOC_ID = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.HEREDOC_ID", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        HEREDOC_CONTENT = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.HEREDOC_CONTENT", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        HEREGEX_ID = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.HEREGEX_ID", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        HEREGEX_CONTENT = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.HEREGEX_CONTENT", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        JAVASCRIPT_INJECTION_QUOTE = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.JAVASCRIPT_ID", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        JAVASCRIPT_INJECTION = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.JAVASCRIPT_CONTENT", (TextAttributesKey)EditorColors.INJECTED_LANGUAGE_FRAGMENT);
        EXPRESSIONS_SUBSTITUTION_MARK = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.EXPRESSIONS_SUBSTITUTION_MARK", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.BLOCK_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT);
        PARENTHESIS = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.PARENTHESIS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        BRACKETS = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.BRACKET", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        BRACES = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.BRACE", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        OPERATIONS = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.OPERATIONS", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        EXISTENTIAL = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.EXISTENTIAL", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        KEYWORD = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        RANGE = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.RANGE", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        SPLAT = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.SPLAT", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        THIS = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.THIS", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        COLON = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        PROTOTYPE = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.PROTOTYPE", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        FUNCTION_ARROW = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.FUNCTION", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        FUNCTION_BINDING_ARROW = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.FUNCTION_BINDING", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        REGULAR_EXPRESSION_ID = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.REGULAR_EXPRESSION_ID", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        REGULAR_EXPRESSION_CONTENT = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.REGULAR_EXPRESSION_CONTENT", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        REGULAR_EXPRESSION_FLAG = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.REGULAR_EXPRESSION_FLAG", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        ESCAPE_SEQUENCE = TextAttributesKey.createTextAttributesKey((String)"COFFEESCRIPT.ESCAPE_SEQUENCE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        ourJsToCoffeeKeyMap = new HashMap<TextAttributesKey, TextAttributesKey>();
        TOKENS_TO_STYLES = new HashMap<IElementType, TextAttributesKey>();
        XML_HIGHLIGHTING_MAP = new HashMap<IElementType, TextAttributesKey>();
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.BAD_CHARACTER, BAD_CHARACTER);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.ERROR_ELEMENT, BAD_CHARACTER);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.WHITE_SPACE, HighlighterColors.TEXT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.TERMINATOR, HighlighterColors.TEXT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.DOT, DOT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.COMMA, COMMA);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.COLON, COLON);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.SEMICOLON, SEMICOLON);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.IDENTIFIER, IDENTIFIER);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.NUMBER, NUMBER);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.BOOL, BOOLEAN);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.ESCAPE_SEQUENCE, ESCAPE_SEQUENCE);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.STRING_LITERAL, STRING_LITERAL);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.HEREDOC_START, HEREDOC_ID);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.HEREDOC, HEREDOC_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.HEREDOC_END, HEREDOC_ID);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_START, REGULAR_EXPRESSION_ID);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX, REGULAR_EXPRESSION_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_BRACKET_START, REGULAR_EXPRESSION_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_BRACKET_END, REGULAR_EXPRESSION_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_PARENTHESIS_START, REGULAR_EXPRESSION_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_PARENTHESIS_END, REGULAR_EXPRESSION_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_BRACE_START, REGULAR_EXPRESSION_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_BRACE_END, REGULAR_EXPRESSION_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_END, REGULAR_EXPRESSION_ID);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.REGEX_FLAG, REGULAR_EXPRESSION_FLAG);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.HEREGEX_START, HEREGEX_ID);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.HEREGEX_TOKEN, HEREGEX_CONTENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.HEREGEX_END, HEREGEX_ID);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.INTERPOLATION_START, EXPRESSIONS_SUBSTITUTION_MARK);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.INTERPOLATION_END, EXPRESSIONS_SUBSTITUTION_MARK);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.JAVASCRIPT_LITERAL, JAVASCRIPT_INJECTION_QUOTE);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.JAVASCRIPT, JAVASCRIPT_INJECTION);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.LINE_COMMENT, LINE_COMMENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.BLOCK_COMMENT, BLOCK_COMMENT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.PARENTHESIS_START, PARENTHESIS);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.PARENTHESIS_END, PARENTHESIS);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.BRACKET_START, BRACKETS);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.BRACKET_END, BRACKETS);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.BRACE_START, BRACES);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.BRACE_END, BRACES);
        for (TokenSet tokenSet : CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY) {
            for (IElementType type : tokenSet.getTypes()) {
                TOKENS_TO_STYLES.put(type, OPERATIONS);
            }
        }
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.EXIST, EXISTENTIAL);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.RANGE, RANGE);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.SPLAT, SPLAT);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.THIS, THIS);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.PROTOTYPE, PROTOTYPE);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.FUNCTION, FUNCTION_ARROW);
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.FUNCTION_BIND, FUNCTION_BINDING_ARROW);
        for (TokenSet tokenSet : CoffeeScriptTokenTypes.KEYWORDS.getTypes()) {
            TOKENS_TO_STYLES.put((IElementType)tokenSet, KEYWORD);
        }
        TOKENS_TO_STYLES.put(CoffeeScriptTokenTypes.LITERATE_BLOCK_COMMENT, BLOCK_COMMENT);
        HashMap keywords = new HashMap();
        CoffeeScriptSyntaxHighlighter.fillMap(keywords, (TokenSet)CoffeeScriptTokenTypes.KEYWORDS, (TextAttributesKey)JS_KEYWORD);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_TAG_NAME, XmlHighlighterColors.XML_TAG_NAME);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_NAME, XmlHighlighterColors.XML_ATTRIBUTE_NAME);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_ATTR_VALUE, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_ATTR_VALUE_END, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_ATTR_VALUE_START, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_ATTR_EQUAL, XmlHighlighterColors.XML_ATTRIBUTE_VALUE);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_ENTITY_REF, XmlHighlighterColors.XML_ENTITY_REFERENCE);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_STYLE_COMMENT, XmlHighlighterColors.XML_COMMENT);
        TOKENS_TO_STYLES.put(JSTokenTypes.XML_TAG_CONTENT, XmlHighlighterColors.XML_TAG_DATA);
        IElementType[] iElementTypeArray = JSElementTypes.XML_TOKENS.getTypes();
        int n = iElementTypeArray.length;
        boolean bl = false;
        while (var3_8 < n) {
            IElementType type = iElementTypeArray[var3_8];
            XML_HIGHLIGHTING_MAP.put(type, XmlHighlighterColors.XML_TAG);
            ++var3_8;
        }
        ourJsToCoffeeKeyMap.put(JSHighlighter.JS_CLASS, CLASS_NAME);
        ourJsToCoffeeKeyMap.put(JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION, FUNCTION_NAME);
        ourJsToCoffeeKeyMap.put(JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE, GLOBAL_VARIABLE);
        ourJsToCoffeeKeyMap.put(JSHighlighter.JS_LOCAL_VARIABLE, LOCAL_VARIABLE);
        ourJsToCoffeeKeyMap.put(JSHighlighter.JS_GLOBAL_VARIABLE, GLOBAL_VARIABLE);
        ourJsToCoffeeKeyMap.put(JSHighlighter.JS_PARAMETER, PARAMETER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/highlighter/CoffeeScriptSyntaxHighlighter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/highlighter/CoffeeScriptSyntaxHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMappedKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

