/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.coffeescript.CoffeeScriptLanguage;
import org.coffeescript.file.CoffeeScriptFileType;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public final class CoffeeScriptEnterHandler
implements EnterHandlerDelegate {
    private final String BLOCK_COMMENT_PREFIX = ((Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)CoffeeScriptLanguage.INSTANCE)).getBlockCommentPrefix();
    private final String EMPTY_BLOCK_COMMENT = this.BLOCK_COMMENT_PREFIX + this.BLOCK_COMMENT_PREFIX;

    private static String getIndentText(@NotNull PsiFile file) {
        if (file == null) {
            CoffeeScriptEnterHandler.$$$reportNull$$$0(0);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)file);
        return StringUtil.repeatSymbol((char)' ', (int)indentOptions.INDENT_SIZE);
    }

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            CoffeeScriptEnterHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            CoffeeScriptEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretOffset == null) {
            CoffeeScriptEnterHandler.$$$reportNull$$$0(3);
        }
        if (caretAdvance == null) {
            CoffeeScriptEnterHandler.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            CoffeeScriptEnterHandler.$$$reportNull$$$0(5);
        }
        if (!CoffeeScriptEnterHandler.shouldHandle(editor, dataContext)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caret = editor.getCaretModel().getOffset();
        if (caret == 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement currentElement = file.findElementAt(caret - 1);
        if (currentElement != null) {
            IElementType type = currentElement.getNode().getElementType();
            if (currentElement.getText().startsWith(this.BLOCK_COMMENT_PREFIX)) {
                String indent = CoffeeScriptEnterHandler.getIndentText(file);
                if (currentElement.getText().trim().equals(this.EMPTY_BLOCK_COMMENT)) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n" + indent + "\n"));
                    editor.getCaretModel().moveCaretRelatively(0, -1, false, false, true);
                } else if (!currentElement.getText().substring(this.BLOCK_COMMENT_PREFIX.length()).endsWith(this.BLOCK_COMMENT_PREFIX)) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n" + indent + "\n" + this.BLOCK_COMMENT_PREFIX));
                    editor.getCaretModel().moveCaretRelatively(indent.length() - this.BLOCK_COMMENT_PREFIX.length(), -1, false, false, true);
                } else {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n" + indent));
                }
                return EnterHandlerDelegate.Result.Stop;
            }
            if (type == CoffeeScriptTokenTypes.HEREDOC_START) {
                PsiElement parent = currentElement.getParent();
                if (parent != null) {
                    if (parent.getNode().getLastChildNode() != null && parent.getNode().getLastChildNode().getElementType() != CoffeeScriptTokenTypes.HEREDOC_END) {
                        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n\n" + currentElement.getText()));
                        editor.getCaretModel().moveCaretRelatively(0, -1, false, false, true);
                    } else if (parent.getTextLength() == this.EMPTY_BLOCK_COMMENT.length()) {
                        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"\n\n");
                        editor.getCaretModel().moveCaretRelatively(0, -1, false, false, true);
                    } else {
                        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"\n");
                    }
                    return EnterHandlerDelegate.Result.Stop;
                }
            } else {
                if (type == CoffeeScriptTokenTypes.HEREDOC) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"\n");
                    return EnterHandlerDelegate.Result.Stop;
                }
                if (type == CoffeeScriptTokenTypes.BRACKET_START) {
                    PsiElement parent = currentElement.getParent();
                    if (parent instanceof JSArrayLiteralExpression && parent.getText().equals("[]")) {
                        int lineNumber = editor.getDocument().getLineNumber(currentElement.getTextOffset());
                        int lineStartOffset = editor.getDocument().getLineStartOffset(lineNumber);
                        int i = 0;
                        while (lineStartOffset + i < editor.getDocument().getTextLength() && editor.getDocument().getText().charAt(lineStartOffset + i) == ' ') {
                            ++i;
                        }
                        String indent = StringUtil.repeatSymbol((char)' ', (int)i);
                        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)("\n" + indent));
                        editor.getCaretModel().moveCaretRelatively(0, -1, false, false, true);
                    }
                } else if (type == CoffeeScriptTokenTypes.STRING_LITERAL && (currentElement = currentElement.getParent()).getTextOffset() + currentElement.getTextLength() > caret) {
                    EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"\n");
                    return EnterHandlerDelegate.Result.Stop;
                }
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean shouldHandle(Editor editor, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null || psiFile.getFileType() != CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE) {
            return false;
        }
        if (editor.isViewer()) {
            return false;
        }
        Document document = editor.getDocument();
        return document.isWritable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/coffeescript/formatter/CoffeeScriptEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

