/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;

public final class CoffeeScriptTypedHandler
extends TypedHandlerDelegate {
    private static boolean isSelectionInsideDoubleQuotedString(@NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element;
        if (editor == null) {
            CoffeeScriptTypedHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CoffeeScriptTypedHandler.$$$reportNull$$$0(1);
        }
        if (editor.getSelectionModel().hasSelection() && (element = file.findElementAt(editor.getSelectionModel().getSelectionStart())) != null && element.getNode().getElementType() == CoffeeScriptTokenTypes.STRING_LITERAL && element.getText().startsWith("\"")) {
            SelectionModel selectionModel = editor.getSelectionModel();
            return element.getTextRange().contains(new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()));
        }
        return false;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            CoffeeScriptTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CoffeeScriptTypedHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CoffeeScriptTypedHandler.$$$reportNull$$$0(4);
        }
        if (c == '#' && CoffeeScriptUtil.isCoffeeScriptContent((PsiElement)file) && CoffeeScriptTypedHandler.isSelectionInsideDoubleQuotedString(editor, file)) {
            int start = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            editor.getSelectionModel().removeSelection();
            editor.getCaretModel().moveToOffset(start);
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"#{");
            editor.getCaretModel().moveToOffset(end + 2);
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}");
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                CoffeeScriptTypedHandler.$$$reportNull$$$0(5);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.beforeSelectionRemoved(c, project, editor, file);
        if (result == null) {
            CoffeeScriptTypedHandler.$$$reportNull$$$0(6);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/editor/CoffeeScriptTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/editor/CoffeeScriptTypedHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelectionInsideDoubleQuotedString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

