/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.ruby.psi;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiErrorElement;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.SlimFileType;
import org.jetbrains.plugins.slim.SlimLanguage;

final class SlimRubyErrorFilter
extends HighlightErrorFilter {
    private static final List<Language> LANGUAGES_TO_HIGHLIGHT_ERROR = Arrays.asList(SlimLanguage.INSTANCE, HTMLLanguage.INSTANCE, XMLLanguage.INSTANCE);

    SlimRubyErrorFilter() {
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        VirtualFile vFile;
        if (element == null) {
            SlimRubyErrorFilter.$$$reportNull$$$0(0);
        }
        VirtualFile virtualFile = vFile = element.getContainingFile() != null ? element.getContainingFile().getVirtualFile() : null;
        if (vFile == null || !(vFile.getFileType() instanceof SlimFileType)) {
            return true;
        }
        return LANGUAGES_TO_HIGHLIGHT_ERROR.contains(element.getLanguage());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/slim/ruby/psi/SlimRubyErrorFilter", "shouldHighlightErrorElement"));
    }
}

