/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactoryImpl;
import java.awt.Component;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyCreateRemoteInterpreterDialog;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;

public final class RubyRemoteInterpreterFactory
extends RemoteSdkFactoryImpl<RubyRemoteSdkAdditionalData> {
    private final SdkType @NotNull [] mySdkTypes;

    public RubyRemoteInterpreterFactory(SdkType @NotNull [] sdkTypes) {
        if (sdkTypes == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(0);
        }
        this.mySdkTypes = sdkTypes;
    }

    @NotNull
    protected SdkType getSdkType(@NotNull RubyRemoteSdkAdditionalData data) {
        SdkType type;
        if (data == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(1);
        }
        if ((type = RubyCreateRemoteInterpreterDialog.selectSdkType(data.getInterpreterPath(), RubySdkUtil.isWindows((String)data.getPlatform()), this.mySdkTypes)) != null) {
            SdkType sdkType = type;
            if (sdkType == null) {
                RubyRemoteInterpreterFactory.$$$reportNull$$$0(2);
            }
            return sdkType;
        }
        throw new IllegalArgumentException("unrecognized sdk type for " + String.valueOf(data));
    }

    @NotNull
    protected String getSdkName(@NotNull RubyRemoteSdkAdditionalData data, @Nullable String version) throws RemoteSdkException {
        String normalizedVersionString;
        if (data == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(3);
        }
        if ((normalizedVersionString = data.getNormalizedVersionString()) == null) {
            throw new RemoteSdkException(RBundle.message((String)"remote.interpreter.cannot.find.interpreter.path"));
        }
        String patchLevel = RubyVersionUtil.getPatchLevel((String)normalizedVersionString);
        String shortVersion = RubyVersionUtil.getShortVersion((String)normalizedVersionString);
        String suggestedSdkName = ((RubySdkType)this.getSdkType(data)).createSuggestedSdkName(shortVersion, patchLevel);
        RubyVersionManagerSdkData versionManagerSdkAdditionalData = data.getVersionManagerSdkAdditionalData();
        String string = "Remote" + versionManagerSdkAdditionalData.getHandler().getRemoteNameSuffix() + ": " + suggestedSdkName + versionManagerSdkAdditionalData.getRemoteSdkNameSuffix();
        if (string == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected String getSdkVersion(Project project, @NotNull RubyRemoteSdkAdditionalData data) throws RemoteSdkException {
        if (data == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(5);
        }
        if (data.getNormalizedVersionString() == null) {
            try {
                data.setNormalizedVersionString(RubyVersionUtil.getFullVersion((RubyRunner)data.getRunner(null), (String)data.getInterpreterPath(), (boolean)true));
            }
            catch (ExecutionException e) {
                throw new RemoteSdkException(e.getMessage(), (Throwable)e);
            }
        }
        return data.getNormalizedVersionString();
    }

    @NotNull
    protected Sdk createSdk(@NotNull Collection<Sdk> existingSdks, @NotNull SdkType sdkType, @NotNull RubyRemoteSdkAdditionalData data, @Nullable String sdkName) {
        if (existingSdks == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(6);
        }
        if (sdkType == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(7);
        }
        if (data == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(8);
        }
        Sdk sdk = SdkConfigurationUtil.createSdk(existingSdks, (String)this.generateSdkHomePath((RemoteSdkAdditionalData)data), (SdkType)sdkType, (SdkAdditionalData)data, (String)sdkName);
        if (sdk == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(9);
        }
        return sdk;
    }

    public String getDefaultUnfinishedName() {
        return RubyRemoteInterpreterFactory.getDefaultUnfinishedInterpreterName((String)this.sdkName());
    }

    @NotNull
    public String sdkName() {
        return "Ruby";
    }

    public void initSdk(@NotNull Sdk sdk, @Nullable Project project, @Nullable Component ownerComponent) throws RemoteSdkException {
        if (sdk == null) {
            RubyRemoteInterpreterFactory.$$$reportNull$$$0(10);
        }
        try {
            ((RubySdkType)sdk.getSdkType()).setupSdkPaths(sdk);
        }
        catch (Exception e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypes";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteInterpreterFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyRemoteInterpreterFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSdkType";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSdkName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSdkVersion";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 9 -> new IllegalStateException(string);
        };
    }
}

