/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.ui.RemoteMappingsHolder;
import javax.swing.Icon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsConfigurableBase;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.RubySdkCustomActionProvider;

final class RubyEditPathMappingsActionProvider
extends RubySdkCustomActionProvider {
    private static final Logger LOG = Logger.getInstance(RubyEditPathMappingsActionProvider.class);

    RubyEditPathMappingsActionProvider() {
    }

    public AnAction createAction(@NotNull Project project, @NotNull Tree sdkTree, @NotNull Disposable disposable) {
        if (project == null) {
            RubyEditPathMappingsActionProvider.$$$reportNull$$$0(0);
        }
        if (sdkTree == null) {
            RubyEditPathMappingsActionProvider.$$$reportNull$$$0(1);
        }
        if (disposable == null) {
            RubyEditPathMappingsActionProvider.$$$reportNull$$$0(2);
        }
        return new RubyEditPathMappingsAction(project, sdkTree);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "disposable";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyEditPathMappingsActionProvider";
        objectArray[2] = "createAction";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RubyEditPathMappingsAction
    extends AnAction {
        private static final Icon myDefaultIcon = AllIcons.Vcs.Folders;
        private static final Icon myProblemIcon = LayeredIcon.layeredIcon(() -> new Icon[]{AllIcons.Vcs.Folders, AllIcons.General.WarningDecorator});
        private final RemoteMappingsHolder myMappingsHolder;
        private boolean myEnabled;
        private boolean myVisible;
        private volatile boolean myIsEmpty;

        RubyEditPathMappingsAction(@NotNull Project project, @NotNull Tree sdkTree) {
            if (project == null) {
                RubyEditPathMappingsAction.$$$reportNull$$$0(0);
            }
            if (sdkTree == null) {
                RubyEditPathMappingsAction.$$$reportNull$$$0(1);
            }
            super(() -> RBundle.message((String)"remote.action.edit.path.mappings.text"), myDefaultIcon);
            this.myEnabled = true;
            this.myVisible = true;
            Consumer errorConsumer = s -> {
                if (StringUtil.isNotEmpty((String)s)) {
                    LOG.debug("Can not evaluate path mappings due to: " + s);
                }
            };
            this.myMappingsHolder = new RemoteMappingsHolder(project, "ruby", (java.util.function.Consumer)errorConsumer){

                protected void setToolTipText(String toolTipText) {
                }

                protected void updatePresentation(@Nullable String text) {
                    this.setIsEmpty(StringUtil.isEmpty((String)text));
                }

                protected String getPresentation() {
                    return "";
                }

                protected void setVisible(boolean visible) {
                    this.setVisible(visible);
                }

                protected void setEnabled(boolean enabled) {
                    this.setEnabled(enabled);
                }
            };
            sdkTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    SdkAdditionalData data;
                    Sdk sdk = RubySdkGemsConfigurableBase.getSdkByPath((TreePath)e.getPath());
                    if (sdk != null && (data = sdk.getSdkAdditionalData()) instanceof RubyRemoteSdkAdditionalData) {
                        RubyRemoteSdkAdditionalData remoteData = (RubyRemoteSdkAdditionalData)data;
                        myMappingsHolder.updateServerId(remoteData.getSdkId(), (RemoteSdkAdditionalData)remoteData);
                        return;
                    }
                    myMappingsHolder.clearAndShowDisabled(null, null);
                    this.setVisible(false);
                }
            });
        }

        private void setIsEmpty(boolean isEmpty) {
            this.myIsEmpty = isEmpty;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                RubyEditPathMappingsAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RubyEditPathMappingsAction.$$$reportNull$$$0(3);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(this.myEnabled);
            presentation.setVisible(this.myVisible);
            presentation.setIcon(this.myIsEmpty ? myProblemIcon : myDefaultIcon);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                RubyEditPathMappingsAction.$$$reportNull$$$0(4);
            }
            this.myMappingsHolder.editPathMappings();
        }

        private void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        private void setVisible(boolean visible) {
            this.myVisible = visible;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkTree";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/remote/impl/RubyEditPathMappingsActionProvider$RubyEditPathMappingsAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyEditPathMappingsActionProvider$RubyEditPathMappingsAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

