/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactoryImpl;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.CreateRemoteSdkDialog;
import com.intellij.remote.ui.CreateRemoteSdkForm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Verifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyCredentialsContribution;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyRemoteInterpreterFactory;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public final class RubyCreateRemoteInterpreterDialog
extends CreateRemoteSdkDialog<RubyRemoteSdkAdditionalData> {
    private static final BundleAccessor BUNDLE_ACCESSOR = new BundleAccessor(){

        @NotNull
        @Nls
        public String message(@NotNull String key, Object ... params) {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            String string = RBundle.message((String)key, (Object[])params);
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String messageOrNull(@NotNull String key, Object ... params) {
            if (key == null) {
                1.$$$reportNull$$$0(2);
            }
            return RBundle.INSTANCE.messageOrNull(key, params);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/remote/impl/RubyCreateRemoteInterpreterDialog$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyCreateRemoteInterpreterDialog$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "message";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "messageOrNull";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };
    private final SdkType @NotNull [] mySdkTypes;

    public RubyCreateRemoteInterpreterDialog(@Nullable Project project, @NotNull Collection<Sdk> existingSdks, SdkType @NotNull [] sdkTypes) {
        if (existingSdks == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(0);
        }
        if (sdkTypes == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(1);
        }
        super(project, existingSdks);
        this.mySdkTypes = sdkTypes;
        this.setTitle(RBundle.message((String)"remote.interpreter.configure.title"));
        this.init();
    }

    @NotNull
    protected RemoteSdkFactoryImpl<RubyRemoteSdkAdditionalData> createRemoteSdkFactory() {
        return new RubyRemoteInterpreterFactory(this.mySdkTypes);
    }

    @NotNull
    protected CreateRemoteSdkForm<RubyRemoteSdkAdditionalData> createRemoteSdkForm() {
        return new RubyCreateRemoteSdkForm(this);
    }

    protected boolean isModified(@NotNull RubyRemoteSdkAdditionalData oldData, @NotNull RubyRemoteSdkAdditionalData newData) {
        if (oldData == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(2);
        }
        if (newData == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(3);
        }
        return false;
    }

    protected void doOKAction() {
        new Task.Modal(null, RBundle.message((String)"remote.interpreter.creating"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                RubyCreateRemoteInterpreterDialog.super.doOKAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/remote/impl/RubyCreateRemoteInterpreterDialog$2", "run"));
            }
        }.queue();
    }

    @TestOnly
    public void doOkActionInTest() {
        this.doOKAction();
    }

    protected boolean validateRemoteSdkData(RubyRemoteSdkAdditionalData data) {
        for (Sdk sdk : this.myExistingSdks) {
            if (!(sdk.getSdkAdditionalData() instanceof RubyRemoteSdkAdditionalData) || !data.equals((Object)sdk.getSdkAdditionalData())) continue;
            this.validationFailed(RBundle.message((String)"remote.interpreter.already.existing", (Object[])new Object[]{sdk.getName()}), false);
            return false;
        }
        return true;
    }

    @Nullable
    public static SdkType selectSdkType(@NotNull String interpreterPath, boolean isWindows, SdkType ... sdkTypes) {
        File interpreterFile;
        if (interpreterPath == null) {
            RubyCreateRemoteInterpreterDialog.$$$reportNull$$$0(4);
        }
        if (RVMSupportUtil.isRvmSdk((File)(interpreterFile = new File(interpreterPath)))) {
            return RVMSupportUtil.getRubySdkType((String)interpreterFile.getName());
        }
        for (SdkType sdkType : sdkTypes) {
            if (!(sdkType instanceof RubySdkType) || !((RubySdkType)sdkType).isValidInterpreter(interpreterFile, isWindows)) continue;
            return sdkType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyCreateRemoteInterpreterDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectSdkType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RubyCreateRemoteSdkForm
    extends CreateRemoteSdkForm<RubyRemoteSdkAdditionalData> {
        RubyCreateRemoteSdkForm(@NotNull CreateRemoteSdkDialog<RubyRemoteSdkAdditionalData> dialog) {
            if (dialog == null) {
                RubyCreateRemoteSdkForm.$$$reportNull$$$0(0);
            }
            super(dialog.getProject(), dialog, () -> dialog.onValidationPress(), BUNDLE_ACCESSOR);
        }

        @NotNull
        protected List<CredentialsLanguageContribution> getContributions() {
            List list = ContainerUtil.filter((Object[])((CredentialsLanguageContribution[])CredentialsLanguageContribution.EP_NAME.getExtensions()), (Condition)FilteringIterator.instanceOf(RubyCredentialsContribution.class));
            if (list == null) {
                RubyCreateRemoteSdkForm.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        protected RubyRemoteSdkAdditionalData doCreateSdkData(@NotNull String interpreterPath) {
            if (interpreterPath == null) {
                RubyCreateRemoteSdkForm.$$$reportNull$$$0(2);
            }
            RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData = RubyRemoteSdkAdditionalData.create((String)interpreterPath);
            if (rubyRemoteSdkAdditionalData == null) {
                RubyCreateRemoteSdkForm.$$$reportNull$$$0(3);
            }
            return rubyRemoteSdkAdditionalData;
        }

        public RubyRemoteSdkAdditionalData createSdkData() throws RemoteSdkException {
            RubyRemoteSdkAdditionalData additionalData = (RubyRemoteSdkAdditionalData)super.createSdkData();
            RubySdkConfigurator.checkSdkAdditionalData((RubySdkAdditionalData)additionalData);
            RubyRemoteSdkAdditionalData rubyRemoteSdkAdditionalData = (RubyRemoteSdkAdditionalData)ObjectUtils.tryCast((Object)additionalData.withVersionManagerSdkAdditionalData(RubyVersionManagerHandler.createAdditionalData((RubyRemoteSdkAdditionalData)additionalData)), RubyRemoteSdkAdditionalData.class);
            if (rubyRemoteSdkAdditionalData != null) {
                RbConfig.init((RubySdkAdditionalData)rubyRemoteSdkAdditionalData, (String)rubyRemoteSdkAdditionalData.getInterpreterPath());
                if (rubyRemoteSdkAdditionalData.getRbConfig().isEmpty()) {
                    throw new RemoteSdkException(RBundle.message((String)"dialog.message.unable.to.read.rbconfig.from.specified.interpreter"));
                }
            }
            return rubyRemoteSdkAdditionalData;
        }

        @Nullable
        public ValidationInfo validateRemoteInterpreter() {
            String reason = Verifier.checkCharacterData((String)this.getInterpreterPath());
            if (reason != null) {
                return new ValidationInfo(BUNDLE_ACCESSOR.message("remote.interpreter.invalid.chars.in.interpreter.path", new Object[]{reason}), (JComponent)this.myInterpreterPathField);
            }
            return super.validateRemoteInterpreter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/remote/impl/RubyCreateRemoteInterpreterDialog$RubyCreateRemoteSdkForm";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/remote/impl/RubyCreateRemoteInterpreterDialog$RubyCreateRemoteSdkForm";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContributions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doCreateSdkData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "doCreateSdkData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }
}

