/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.rails.actionCable;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.javascript.debugger.rails.actionCable.ChannelNavigationHelper;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import icons.RubyIcons;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.codeInsight.daemon.StaticTooltipProvider;
import org.jetbrains.plugins.ruby.rails.model.RailsChannel;
import org.jetbrains.plugins.ruby.rails.model.RailsChannelAction;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineMarkerProviderDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

final class ActionCableLineMarkerProvider
extends RubyLineMarkerProviderDescriptor {
    ActionCableLineMarkerProvider() {
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            ActionCableLineMarkerProvider.$$$reportNull$$$0(0);
        }
        PsiElement parent = element.getParent();
        if (this.canHoldRubyLineMarker(element)) {
            PsiElement container = parent.getParent().getParent();
            if (container instanceof RClass) {
                RClass rClass = (RClass)container;
                RailsChannel channel = RailsChannel.fromClass((RClass)rClass);
                if (channel == null) {
                    return null;
                }
                return new LineMarkerInfo(element, element.getTextRange(), RubyIcons.Rails.AnyType_12x12, (Function)new StaticTooltipProvider(RBundle.message((String)"rails.action.cable.gutter.tooltip.text", (Object[])new Object[]{channel.getName()})), (GutterIconNavigationHandler)new NavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            }
            if (container instanceof RMethod) {
                RailsChannelAction channelAction = RailsChannelAction.fromMethod((RMethod)((RMethod)container));
                if (channelAction == null) {
                    return null;
                }
                String tooltip = RBundle.message((String)"rails.action.cable.action.gutter.tooltip.text", (Object[])new Object[]{channelAction.getName()});
                return new LineMarkerInfo(element, element.getTextRange(), RubyIcons.Rails.AnyType_12x12, (Function)new StaticTooltipProvider(tooltip), (GutterIconNavigationHandler)new NavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            }
        }
        return null;
    }

    @Nullable
    public String getName() {
        return RBundle.message((String)"rails.action.cable.gutter.title");
    }

    @Nullable
    public Icon getIcon() {
        return RubyIcons.Rails.AnyType_12x12;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/debugger/rails/actionCable/ActionCableLineMarkerProvider", "getLineMarkerInfo"));
    }

    public static class NavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        public void navigate(MouseEvent e, PsiElement element) {
            RelativePoint relativePoint = new RelativePoint(e);
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{RMethod.class, RClass.class});
            if (parent instanceof RClass) {
                ChannelNavigationHelper.switchToOrCreateChannelClient((RClass)parent, relativePoint);
            } else if (parent instanceof RMethod) {
                ChannelNavigationHelper.switchToChannelActionCall((RMethod)parent, relativePoint);
            }
        }
    }
}

