/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.rails.actionCable;

import com.intellij.javascript.debugger.rails.RubyJavascriptDebuggerIcons;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsRelatedFilesProvider;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsChannel;

public final class ActionCableGotoRelatedProvider
extends GotoRelatedProvider {
    private static final List<@NlsSafe String> CHANNEL_CLIENT_FILE_EXTENSION = Arrays.asList("coffee", "js");

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull DataContext context) {
        PsiFile file;
        if (context == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if ((file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            List<? extends GotoRelatedItem> list = this.getItems((PsiElement)file);
            if (list == null) {
                ActionCableGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement element) {
        RailsChannel possibleChannel;
        Module module;
        if (element == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                ActionCableGotoRelatedProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiFile psiFile = element.getContainingFile();
        RailsChannel railsChannel = possibleChannel = psiFile != null ? RailsChannel.fromFile((PsiFile)psiFile) : null;
        if (possibleChannel != null) {
            return ActionCableGotoRelatedProvider.getRelatedItemsForChannel(possibleChannel, RailsPaths.getInstance((Module)module));
        }
        if (psiFile instanceof JSFile && RailsUtil.isUnderChannelClientDirectory((PsiFile)psiFile)) {
            List<? extends GotoRelatedItem> list = ActionCableGotoRelatedProvider.getRelatedItemsForChannelClient(psiFile, RailsPaths.getInstance((Module)module));
            if (list == null) {
                ActionCableGotoRelatedProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static List<? extends GotoRelatedItem> getRelatedItemsForChannelClient(@NotNull PsiFile jsFile, RailsPaths paths) {
        if (jsFile == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(7);
        }
        Project project = jsFile.getProject();
        boolean mnemonicUsed = false;
        ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem> result = new ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem>();
        for (VirtualFile channelsDir : paths.findFiles("app/channels")) {
            for (VirtualFile file : channelsDir.getChildren()) {
                RailsChannel channel;
                PsiFile channelFile;
                if (file.isDirectory() || !file.getNameWithoutExtension().endsWith("channel") || (channelFile = PsiManager.getInstance((Project)project).findFile(file)) == null || (channel = RailsChannel.fromFile((PsiFile)channelFile)) == null) continue;
                result.add(new RailsRelatedFilesProvider.RailsGotoRelatedItem((PsiElement)channel.getRClass(), RBundle.message((String)"rails.action.cable.channel"), RubyJavascriptDebuggerIcons.Channel, mnemonicUsed ? -1 : 7));
                mnemonicUsed = true;
            }
        }
        return result;
    }

    @NotNull
    private static List<? extends GotoRelatedItem> getRelatedItemsForChannel(@NotNull RailsChannel channel, @NotNull RailsPaths paths) {
        if (channel == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(8);
        }
        if (paths == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(9);
        }
        boolean mnemonicUsed = false;
        ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem> result = new ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem>();
        for (VirtualFile channelJavascriptDir : paths.findFiles("app/assets", new String[]{"javascripts", "channels"})) {
            for (VirtualFile file : channelJavascriptDir.getChildren()) {
                PsiFile channelClientPsiFile;
                @NonNls String extension = file.getExtension();
                if (file.isDirectory() || extension == null || !CHANNEL_CLIENT_FILE_EXTENSION.contains(StringUtil.toLowerCase((String)extension)) || (channelClientPsiFile = PsiManager.getInstance((Project)channel.getApp().getProject()).findFile(file)) == null) continue;
                result.add(new RailsRelatedFilesProvider.RailsGotoRelatedItem((PsiElement)channelClientPsiFile, RBundle.message((String)"rails.action.cable.channel.client"), channelClientPsiFile.getIcon(0), mnemonicUsed ? -1 : 7));
                mnemonicUsed = true;
            }
        }
        ArrayList<RailsRelatedFilesProvider.RailsGotoRelatedItem> arrayList = result;
        if (arrayList == null) {
            ActionCableGotoRelatedProvider.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/rails/actionCable/ActionCableGotoRelatedProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/rails/actionCable/ActionCableGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedItemsForChannel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedItemsForChannelClient";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedItemsForChannel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 10 -> new IllegalStateException(string);
        };
    }
}

