/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.rails.actionCable;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.javascript.debugger.rails.RubyJavascriptDebuggerIcons;
import com.intellij.javascript.debugger.rails.actionCable.ActionCableReference;
import com.intellij.javascript.debugger.rails.actionCable.ChannelNavigationHelper;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.util.Function;
import icons.RubyIcons;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.codeInsight.daemon.StaticTooltipProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers.RubyLineMarkerProviderDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;

final class ActionCableClientLineMarkerProvider
extends RubyLineMarkerProviderDescriptor {
    ActionCableClientLineMarkerProvider() {
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Icon icon;
        String tooltip;
        PsiElement parent;
        if (element == null) {
            ActionCableClientLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!((parent = element.getParent()) instanceof PsiLiteralValue)) {
            return null;
        }
        ActionCableReference actionCableReference = ChannelNavigationHelper.getActionCableReference(parent);
        if (actionCableReference == null) {
            return null;
        }
        PsiElement resolveResult = actionCableReference.resolve();
        if (!(resolveResult instanceof NavigatablePsiElement)) {
            return null;
        }
        String elementName = ((NavigatablePsiElement)resolveResult).getName();
        if (resolveResult instanceof RClass) {
            tooltip = RBundle.message((String)"rails.action.cable.client.gutter.tooltip.text", (Object[])new Object[]{elementName});
            icon = RubyJavascriptDebuggerIcons.Channel;
        } else {
            tooltip = RBundle.message((String)"rails.action.cable.client.action.gutter.tooltip.text", (Object[])new Object[]{elementName});
            icon = RubyIcons.Rails.ActionMethod_12x12;
        }
        return new LineMarkerInfo(element, element.getTextRange(), icon, (Function)new StaticTooltipProvider(tooltip), (GutterIconNavigationHandler)new NavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
    }

    @Nullable
    public String getName() {
        return RBundle.message((String)"rails.action.cable.client.gutter.title");
    }

    @Nullable
    public Icon getIcon() {
        return RubyJavascriptDebuggerIcons.Channel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/debugger/rails/actionCable/ActionCableClientLineMarkerProvider", "getLineMarkerInfo"));
    }

    private static class NavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private NavigationHandler() {
        }

        public void navigate(MouseEvent e, PsiElement element) {
            ChannelNavigationHelper.switchToChannelOrAction(element);
        }
    }
}

