/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.rails.actionCable;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.debugger.rails.actionCable.ActionCableReference;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.actions.special.GenerateChannelAction;

public final class ActionCableChannelNotFoundInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ActionCableChannelNotFoundInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ActionCableChannelNotFoundInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSFile(@NotNull JSFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (RailsUtil.isUnderChannelClientDirectory((PsiFile)file)) {
                    super.visitJSFile(file);
                }
            }

            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (PsiReference ref : node.getReferences()) {
                    if (!(ref instanceof ActionCableReference) || ref.resolve() != null) continue;
                    String channelName = ref.getRangeInElement().substring(node.getText());
                    if (channelName.endsWith("Channel")) {
                        channelName = channelName.substring(0, channelName.length() - "Channel".length());
                    }
                    CreateChannelQuickFix fix = new CreateChannelQuickFix(channelName);
                    holder.registerProblem((PsiElement)node, ref.getRangeInElement(), RBundle.message((String)"rails.action.cable.undefined.channel.inspection.text"), new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/debugger/rails/actionCable/ActionCableChannelNotFoundInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            ActionCableChannelNotFoundInspection.$$$reportNull$$$0(2);
        }
        return !RailsUtil.isUnderChannelClientDirectory((PsiFile)element.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/debugger/rails/actionCable/ActionCableChannelNotFoundInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuppressedFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CreateChannelQuickFix
    implements LocalQuickFix {
        private final String myChannnelName;

        CreateChannelQuickFix(String channelName) {
            this.myChannnelName = channelName;
        }

        @NotNull
        @Nls
        public String getFamilyName() {
            String string = RBundle.message((String)"rails.action.cable.undefined.channel.inspection.quickfix.name");
            if (string == null) {
                CreateChannelQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Module module;
            if (project == null) {
                CreateChannelQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CreateChannelQuickFix.$$$reportNull$$$0(2);
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)descriptor.getPsiElement())) == null) {
                return;
            }
            GenerateChannelAction action = new GenerateChannelAction("channel", this.myChannnelName);
            action.invokeDialog(module, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/debugger/rails/actionCable/ActionCableChannelNotFoundInspection$CreateChannelQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/debugger/rails/actionCable/ActionCableChannelNotFoundInspection$CreateChannelQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

