/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cucumber.java.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryUi;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.PathMappingSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.cucumber.java.run.JRubyCucumberCmdLineState;
import org.jetbrains.plugins.ruby.cucumber.java.run.JRubyCucumberRunConfigurationEditor;
import org.jetbrains.plugins.ruby.cucumber.java.run.JRubyCucumberRunConfigurationExternalizer;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfiguration;
import org.jetbrains.plugins.ruby.cucumber.run.BaseCucumberRunConfigurationUtil;
import org.jetbrains.plugins.ruby.java.jruby.facet.JRubyFacet;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;

final class JRubyCucumberRunConfiguration
extends ApplicationConfiguration
implements BaseCucumberRunConfiguration {
    private static final Logger LOG = Logger.getInstance(JRubyCucumberRunConfiguration.class);
    private String myTestsFolderPath;
    private String myTestScriptPath;
    private AbstractRubyTestsRunConfigurationParams.TestType myTestType;
    private String myTestFileMask;
    private String myRunnerArgs;
    private String myNamesFilter;
    private String myTagsFilter;
    @NotNull
    private List<String> myTestScriptsPaths;
    private boolean myBacktraceEnabled;
    @NotNull
    private PathMappingSettings myPathMappingSettings;

    JRubyCucumberRunConfiguration(String name, @NotNull Project project, @NotNull ConfigurationFactory factory) {
        if (project == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(1);
        }
        super(name, project, factory);
        this.myTestsFolderPath = "";
        this.myTestScriptPath = "";
        this.myTestType = AbstractRubyTestsRunConfigurationParams.TestType.TEST_SCRIPT;
        this.myTestFileMask = "";
        this.myRunnerArgs = "";
        this.myNamesFilter = "";
        this.myTagsFilter = "";
        this.myTestScriptsPaths = Collections.emptyList();
        this.myBacktraceEnabled = false;
        this.myPathMappingSettings = new PathMappingSettings();
    }

    @NotNull
    public String getWorkingDirectory() {
        String workingDirectory = super.getWorkingDirectory();
        String string = Strings.notNullize((String)workingDirectory);
        if (string == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setWorkingDirectory(@Nullable String value) {
        super.setWorkingDirectory(Strings.notNullize((String)value));
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(4);
        }
        try {
            this.validateConfiguration();
            JavaRunConfigurationExtensionManager.getInstance().validateConfiguration((RunConfigurationBase)this, true);
        }
        catch (ExecutionException ee) {
            throw ee;
        }
        catch (RuntimeConfigurationWarning e) {
            LOG.warn(e.getMessage());
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return new JRubyCucumberCmdLineState(this, env);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        try {
            this.validateConfiguration();
        }
        catch (RuntimeConfigurationException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new RuntimeConfigurationException(e.getMessage());
        }
        if (!Registry.is((String)"jruby.cucumber.support")) {
            throw new RuntimeConfigurationWarning(RBundle.message((String)"cucumber.jruby.run.configuration.retirement.warning"), () -> new RegistryUi().show());
        }
    }

    private void validateConfiguration() throws RuntimeConfigurationException {
        if (this.inspectJRubySdk()) {
            return;
        }
        RunConfigurationUtil.inspectWorkingDirectory((boolean)false, (AbstractRubyRunConfigurationParams)this);
        BaseCucumberRunConfigurationUtil.inspectFeatureFileOrFolderPath((BaseCucumberRunConfiguration)this);
    }

    private boolean inspectJRubySdk() throws RuntimeConfigurationException {
        JRubyFacet jRubyFacet;
        JavaRunConfigurationModule javaRunConfigurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        if (javaRunConfigurationModule == null) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.jruby.errors.module.not.specified"));
        }
        String moduleName = javaRunConfigurationModule.getModuleName();
        Module module = javaRunConfigurationModule.getModule();
        JRubyFacet jRubyFacet2 = jRubyFacet = module != null ? JRubyFacet.getInstance((Module)module) : null;
        if (jRubyFacet == null) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.jruby.errors.jruby.facet.not.specified", (Object[])new Object[]{moduleName}));
        }
        Sdk rubySdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (rubySdk == null) {
            throw new RuntimeConfigurationError(RBundle.message((String)"cucumber.jruby.errors.jruby.sdk.not.specified", (Object[])new Object[]{moduleName}));
        }
        return false;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(5);
        }
        super.writeExternal(element);
        JRubyCucumberRunConfigurationExternalizer.getInstance().writeExternal((BaseCucumberRunConfiguration)this, element);
        PathMappingSettings.writeExternal((Element)element, (PathMappingSettings)this.getMappingSettings());
        this.collapsePathsRecursively(element);
    }

    private void collapsePathsRecursively(@NotNull Element element) {
        Module module;
        if (element == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(6);
        }
        if ((module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule()) != null) {
            PathMacroManager.getInstance((Module)module).collapsePathsRecursively(element);
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(7);
        }
        super.readExternal(element);
        this.setMappingSettings(PathMappingSettings.readExternal((Element)element));
        JRubyCucumberRunConfigurationExternalizer.getInstance().readExternal((BaseCucumberRunConfiguration)this, element);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new JRubyCucumberRunConfigurationEditor(this.getProject(), this));
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(8);
        }
        return settingsEditorGroup;
    }

    public String getTestFileMask() {
        return this.myTestFileMask;
    }

    public void setTestFileMask(String testFileMask) {
        this.myTestFileMask = Strings.notNullize((String)testFileMask);
    }

    public AbstractRubyTestsRunConfigurationParams.TestType getTestType() {
        return this.myTestType;
    }

    public void setTestType(@NotNull AbstractRubyTestsRunConfigurationParams.TestType testType) {
        if (testType == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(9);
        }
        this.myTestType = testType;
    }

    public String getTestsFolderPath() {
        return this.myTestsFolderPath;
    }

    public void setTestsFolderPath(String path) {
        this.myTestsFolderPath = AbstractRubyRunConfiguration.asSysIndependentPath((String)path);
    }

    public String getTestScriptPath() {
        return this.myTestScriptPath;
    }

    public void setTestScriptPath(String pathOrMask) {
        this.myTestScriptPath = AbstractRubyRunConfiguration.asSysIndependentPath((String)pathOrMask);
    }

    public String getTagsFilters() {
        return this.myTagsFilter;
    }

    public void setTagsFilter(String tagsFilter) {
        this.myTagsFilter = Strings.notNullize((String)tagsFilter);
    }

    public String getFeatureElementNameFilter() {
        return this.myNamesFilter;
    }

    public void setFeatureElementNameFilter(String nameFilter) {
        this.myNamesFilter = Strings.notNullize((String)nameFilter);
    }

    public String getRunnerOptions() {
        return this.myRunnerArgs;
    }

    public void setRunnerOptions(String specArgs) {
        this.myRunnerArgs = Strings.notNullize((String)specArgs);
    }

    @NotNull
    public List<String> getTestScriptsPaths() {
        List<String> list = Collections.unmodifiableList(this.myTestScriptsPaths);
        if (list == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void setTestScriptsPaths(@NotNull List<String> paths) {
        if (paths == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(11);
        }
        this.myTestScriptsPaths = new ArrayList<String>(paths);
    }

    public boolean isBacktraceEnabled() {
        return this.myBacktraceEnabled;
    }

    public void setBacktraceEnabled(boolean enabled) {
        this.myBacktraceEnabled = enabled;
    }

    public boolean isVerboseEnabled() {
        return false;
    }

    public void setVerboseEnabled(boolean isEnabled) {
    }

    public String getCustomCucumberRunnerPath() {
        return "";
    }

    public void setCustomCucumberRunnerPath(String specsRunnerPath) {
    }

    public void setShouldUseCustomCucumberRunner(boolean useCustomRunner) {
    }

    public boolean shouldUseCustomCucumberRunner() {
        return false;
    }

    @Nullable
    public Sdk getAlternativeSdk() {
        return null;
    }

    public void setAlternativeSdk(@Nullable Sdk sdk) {
    }

    @NotNull
    public PathMappingSettings getMappingSettings() {
        PathMappingSettings pathMappingSettings = this.myPathMappingSettings;
        if (pathMappingSettings == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(12);
        }
        return pathMappingSettings;
    }

    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myPathMappingSettings = mappingSettings != null ? mappingSettings : new PathMappingSettings();
    }

    public String getRunnerGemVersion() {
        return "";
    }

    public void setRunnerGemVersion(String gemVersion) {
    }

    public void setPreloadServer(@NotNull PreLoadUtil.PreLoadServer server) {
        if (server == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(13);
        }
    }

    @NotNull
    public PreLoadUtil.PreLoadServer getPreloadServer() {
        PreLoadUtil.PreLoadServer preLoadServer = PreLoadUtil.PreLoadServer.None;
        if (preLoadServer == null) {
            JRubyCucumberRunConfiguration.$$$reportNull$$$0(14);
        }
        return preLoadServer;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return null;
    }

    @Nullable
    public String getDefaultTargetName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 10, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/cucumber/java/run/JRubyCucumberRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/cucumber/java/run/JRubyCucumberRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestScriptsPaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSettings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreloadServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collapsePathsRecursively";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTestType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setTestScriptsPaths";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPreloadServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 10, 12, 14 -> new IllegalStateException(string);
        };
    }
}

