/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.liquid.psi.LiquidBlock;
import com.intellij.lang.liquid.psi.LiquidBranch;
import com.intellij.lang.liquid.psi.PsiLiquidTagLiquid;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypes;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class LiquidPsiUtil {
    private LiquidPsiUtil() {
    }

    @Contract(value="null->null")
    @Nullable
    public static PsiElement getClosestStructuralElement(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{LiquidBlock.class, LiquidBranch.class, PsiLiquidTagLiquid.class, PsiFile.class});
    }

    @Contract(value="null->false")
    public static boolean isInsideLiquidTag(@Nullable PsiElement psiElement) {
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiLiquidTagLiquid.class) != null;
    }

    @Contract(value="null->false")
    public static boolean isSchemaBody(@Nullable PsiElement psiElement) {
        return psiElement != null && LiquidPsiUtil.isSchemaBody(psiElement.getNode());
    }

    @Contract(value="null->false")
    public static boolean isSchemaBody(@Nullable ASTNode astNode) {
        return astNode != null && astNode.getElementType() == LiquidElementTypes.LIQUID_TEMPLATE_BLOCK && PsiUtilCore.getElementType((ASTNode)astNode.getTreePrev()) == LiquidElementTypesGenerated.SCHEMA_TAG;
    }
}

