/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.liquid.LiquidBundle;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.Nullable;

public final class LiquidParserUtil
extends GeneratedParserUtilBase {
    private static final MultiMap<IElementType, IElementType> BLOCK_CLOSERS_MAP = MultiMap.createSet();
    private static final TokenSet BLOCK_TOKENS;
    private static final TokenSet CASE_RECOVER_TOKENSET;

    private LiquidParserUtil() {
    }

    public static boolean markBadCharacters(PsiBuilder b, int l) {
        PsiBuilder.Marker mark = null;
        StringBuilder message = null;
        while (!b.eof() && b.getTokenType() == TokenType.BAD_CHARACTER) {
            if (mark == null) {
                mark = b.mark();
                message = new StringBuilder();
            }
            message.append(b.getTokenText());
            b.advanceLexer();
        }
        if (mark != null) {
            mark.error(LiquidBundle.message("parser.error.tag.name.expected", message.toString()));
        }
        return true;
    }

    public static boolean processCloseTags(PsiBuilder b, int l) {
        if (b.getTokenType() != LiquidElementTypesGenerated.TAG_OPENER) {
            return false;
        }
        IElementType tagTokenType = b.lookAhead(1);
        if (tagTokenType == LiquidElementTypesGenerated.TAG_CLOSER) {
            b.advanceLexer();
            b.mark().error(LiquidBundle.message("parser.error.missing.tag.name", new Object[0]));
            b.advanceLexer();
            return true;
        }
        if (tagTokenType == null || !BLOCK_CLOSERS_MAP.containsKey((Object)tagTokenType)) {
            return false;
        }
        IElementType nearestBlockFrameType = LiquidParserUtil.getNearestBlockFrameType(b);
        if (nearestBlockFrameType != null && BLOCK_CLOSERS_MAP.get((Object)tagTokenType).contains(nearestBlockFrameType)) {
            return false;
        }
        LiquidParserUtil.consumeToken((PsiBuilder)b, (IElementType)LiquidElementTypesGenerated.TAG_OPENER);
        PsiBuilder.Marker mark = b.mark();
        LiquidParserUtil.recoverToToken(b, l, LiquidElementTypesGenerated.TAG_CLOSER);
        if (nearestBlockFrameType == null) {
            mark.error(LiquidBundle.message("parser.error.unexpected.tag", tagTokenType));
        } else {
            LinkedHashSet expectedTokens = new LinkedHashSet();
            BLOCK_CLOSERS_MAP.entrySet().forEach(it -> {
                if (((Collection)it.getValue()).contains(nearestBlockFrameType)) {
                    expectedTokens.add(((IElementType)it.getKey()).toString());
                }
            });
            mark.error(LiquidBundle.message("parser.error.unexpected.tag.expected", tagTokenType, String.join((CharSequence)", ", ContainerUtil.map((Collection)ContainerUtil.sorted(expectedTokens), it -> "`" + it + "`"))));
        }
        LiquidParserUtil.consumeToken((PsiBuilder)b, (IElementType)LiquidElementTypesGenerated.TAG_CLOSER);
        return true;
    }

    @Nullable
    private static IElementType getNearestBlockFrameType(PsiBuilder b) {
        GeneratedParserUtilBase.ErrorState state = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)b);
        GeneratedParserUtilBase.Frame frame = state.currentFrame;
        while (frame != null) {
            if (BLOCK_TOKENS.contains(frame.elementType)) {
                return frame.elementType;
            }
            frame = frame.parentFrame;
        }
        return null;
    }

    public static boolean recoverToToken(PsiBuilder b, int l, IElementType stopTokenType) {
        return LiquidParserUtil.recoverToToken(b, l, false, stopTokenType);
    }

    public static boolean recoverToTokenWithError(PsiBuilder b, int l, IElementType stopTokenType) {
        return LiquidParserUtil.recoverToToken(b, l, true, stopTokenType);
    }

    public static boolean recoverToToken(PsiBuilder b, int l, boolean reportError, IElementType stopTokenType) {
        while (!b.eof() && b.getTokenType() != stopTokenType) {
            if (reportError) {
                String tokenText = b.getTokenText();
                PsiBuilder.Marker marker = b.mark();
                b.advanceLexer();
                marker.error(LiquidBundle.message("parser.error.unexpected.token", stopTokenType, tokenText));
                reportError = false;
                continue;
            }
            b.advanceLexer();
        }
        return true;
    }

    public static boolean recoverCaseTag(PsiBuilder b, int l) {
        PsiBuilder.Marker mark = b.mark();
        boolean advanced = false;
        while (!(b.eof() || b.getTokenType() == LiquidElementTypesGenerated.TAG_OPENER && CASE_RECOVER_TOKENSET.contains(b.lookAhead(1)))) {
            advanced = true;
            b.advanceLexer();
        }
        if (advanced) {
            mark.error(LiquidBundle.message("parser.error.case.recovery.error", new Object[0]));
        } else {
            mark.drop();
        }
        return true;
    }

    static {
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDSCHEMA, (Object)LiquidElementTypesGenerated.SCHEMA_BLOCK);
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDCAPTURE, (Object)LiquidElementTypesGenerated.CAPTURE_BLOCK);
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDRAW, (Object)LiquidElementTypesGenerated.RAW_BLOCK);
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDHIGHLIGHT, (Object)LiquidElementTypesGenerated.HIGHLIGHT_BLOCK);
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDTABLEROW, (Object)LiquidElementTypesGenerated.TABLEROW_BLOCK);
        BLOCK_CLOSERS_MAP.put((Object)LiquidElementTypesGenerated.ENDFOR, Arrays.asList(LiquidElementTypesGenerated.FOR_BRANCH, LiquidElementTypesGenerated.ELSE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)LiquidElementTypesGenerated.ENDCASE, Arrays.asList(LiquidElementTypesGenerated.CASE_BLOCK, LiquidElementTypesGenerated.WHEN_BRANCH, LiquidElementTypesGenerated.ELSE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)LiquidElementTypesGenerated.WHEN, Arrays.asList(LiquidElementTypesGenerated.CASE_BLOCK, LiquidElementTypesGenerated.WHEN_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)LiquidElementTypesGenerated.ELSE, Arrays.asList(LiquidElementTypesGenerated.IF_BRANCH, LiquidElementTypesGenerated.UNLESS_BRANCH, LiquidElementTypesGenerated.ELSIF_BRANCH, LiquidElementTypesGenerated.CASE_BLOCK, LiquidElementTypesGenerated.WHEN_BRANCH, LiquidElementTypesGenerated.FOR_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)LiquidElementTypesGenerated.ELSIF, Arrays.asList(LiquidElementTypesGenerated.IF_BRANCH, LiquidElementTypesGenerated.UNLESS_BRANCH, LiquidElementTypesGenerated.ELSIF_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)LiquidElementTypesGenerated.ENDIF, Arrays.asList(LiquidElementTypesGenerated.IF_BRANCH, LiquidElementTypesGenerated.UNLESS_BRANCH, LiquidElementTypesGenerated.ELSIF_BRANCH, LiquidElementTypesGenerated.ELSE_BRANCH));
        BLOCK_CLOSERS_MAP.put((Object)LiquidElementTypesGenerated.ENDUNLESS, Arrays.asList(LiquidElementTypesGenerated.UNLESS_BRANCH, LiquidElementTypesGenerated.UNLESS_BRANCH, LiquidElementTypesGenerated.ELSIF_BRANCH, LiquidElementTypesGenerated.ELSE_BRANCH));
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDFORM, (Object)LiquidElementTypesGenerated.FORM_BLOCK);
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDPAGINATE, (Object)LiquidElementTypesGenerated.PAGINATE_BLOCK);
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDSTYLE, (Object)LiquidElementTypesGenerated.STYLE_BLOCK);
        BLOCK_CLOSERS_MAP.putValue((Object)LiquidElementTypesGenerated.ENDIFCHANGED, (Object)LiquidElementTypesGenerated.IFCHANGED_BLOCK);
        BLOCK_TOKENS = TokenSet.create((IElementType[])BLOCK_CLOSERS_MAP.values().toArray(IElementType.EMPTY_ARRAY));
        CASE_RECOVER_TOKENSET = TokenSet.create((IElementType[])new IElementType[]{LiquidElementTypesGenerated.WHEN, LiquidElementTypesGenerated.ENDCASE, LiquidElementTypesGenerated.ELSE});
    }
}

