/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.psi;

import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;

public abstract class LiquidBaseLexer
implements FlexLexer {
    private static final Logger LOG = Logger.getInstance(LiquidBaseLexer.class);
    private boolean myLiquidMode = false;
    private int commentDepth = 0;
    private int myInternalLiquidOpenerOffset = -1;

    protected IElementType openLiquidInnerTag() {
        LOG.assertTrue(this.isLiquidMode(), (Object)("Not in liquid mode at " + this.getTokenStart()));
        LOG.assertTrue(this.myInternalLiquidOpenerOffset < 0, (Object)("Brace is already opened at " + this.myInternalLiquidOpenerOffset + ", we are now at " + this.getTokenStart()));
        this.myInternalLiquidOpenerOffset = this.getTokenStart();
        LOG.debug("Opened inner brace at " + this.getTokenStart());
        return LiquidElementTypesGenerated.TAG_OPENER;
    }

    protected IElementType closeLiquidInnerTag() {
        int tokenStart = this.getTokenStart();
        LOG.assertTrue(this.isLiquidMode(), (Object)("Not in liquid mode at " + tokenStart));
        LOG.assertTrue(this.isLiquidInnerTagOpened(), (Object)("Brace is not opened" + tokenStart));
        LOG.debug("Closed inner brace opened at " + this.myInternalLiquidOpenerOffset + " at " + tokenStart);
        this.myInternalLiquidOpenerOffset = -1;
        return LiquidElementTypesGenerated.TAG_CLOSER;
    }

    protected boolean isLiquidInnerTagOpened() {
        return this.myInternalLiquidOpenerOffset >= 0;
    }

    boolean isLiquidMode() {
        return this.myLiquidMode;
    }

    void setLiquidMode(boolean liquidMode) {
        int tokenStart = this.getTokenStart();
        LOG.assertTrue(this.myLiquidMode != liquidMode, (Object)("Already in same liquid mode " + liquidMode + " at " + tokenStart));
        LOG.debug(liquidMode ? "Entering liquid mode at " + tokenStart : "Exiting liquid mode at " + tokenStart);
        this.myLiquidMode = liquidMode;
    }

    boolean hasInternalState() {
        return this.myLiquidMode || this.commentDepth > 0 || this.myInternalLiquidOpenerOffset >= 0;
    }

    void resetInternals() {
        this.commentDepth = 0;
        this.myLiquidMode = false;
        this.myInternalLiquidOpenerOffset = -1;
    }

    protected IElementType startLiquid() {
        this.setLiquidMode(true);
        this.yybegin(54);
        return LiquidElementTypesGenerated.LIQUID;
    }

    protected IElementType processFinalWhiteSpace() {
        if (this.isLiquidMode()) {
            if (this.isLiquidInnerTagOpened()) {
                this.yypushback(this.yylength());
                return this.closeLiquidInnerTag();
            }
            this.setLiquidMode(false);
            this.yybegin(6);
        }
        return TokenType.WHITE_SPACE;
    }

    public abstract CharSequence yytext();

    public abstract void yypushback(int var1);

    public abstract int yylength();

    protected IElementType processWhiteSpace() {
        if (this.isLiquidMode() && StringUtil.indexOf((CharSequence)this.yytext(), (char)'\n') >= 0) {
            if (this.isLiquidInnerTagOpened()) {
                this.yypushback(this.yylength());
                return this.closeLiquidInnerTag();
            }
            this.yybegin(54);
        }
        return TokenType.WHITE_SPACE;
    }

    protected IElementType processTagCloser() {
        if (this.isLiquidMode()) {
            if (this.isLiquidInnerTagOpened()) {
                this.yypushback(this.yylength());
                this.closeLiquidInnerTag();
                return LiquidElementTypesGenerated.TAG_CLOSER;
            }
            this.setLiquidMode(false);
        }
        this.yybegin(0);
        return LiquidElementTypesGenerated.TAG_CLOSER;
    }

    protected void enterComment() {
        ++this.commentDepth;
    }

    protected boolean tryExitComment() {
        return --this.commentDepth == 0;
    }
}

