/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.highlighting;

import com.intellij.lang.liquid.highlighting.LiquidHighlighterColors;
import com.intellij.lang.liquid.psi.LiquidLexerAdapter;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.lang.liquid.psi.tree.LiquidTokenSets;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class LiquidSyntaxHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey[]> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey[]>();
    private static final TextAttributesKey[] BACKGROUND_ONLY = new TextAttributesKey[]{LiquidHighlighterColors.BACKGROUND};

    @NotNull
    public Lexer getHighlightingLexer() {
        return new LiquidLexerAdapter();
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = ATTRIBUTES.getOrDefault(tokenType, BACKGROUND_ONLY);
        if (textAttributesKeyArray == null) {
            LiquidSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    private static void addTokenType(@NotNull IElementType type, @NotNull TextAttributesKey key) {
        if (type == null) {
            LiquidSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        if (key == null) {
            LiquidSyntaxHighlighter.$$$reportNull$$$0(2);
        }
        ATTRIBUTES.put(type, LiquidSyntaxHighlighter.withBackground(key));
    }

    private static void addTokenSet(@NotNull TokenSet tokenSet, @NotNull TextAttributesKey key) {
        if (tokenSet == null) {
            LiquidSyntaxHighlighter.$$$reportNull$$$0(3);
        }
        if (key == null) {
            LiquidSyntaxHighlighter.$$$reportNull$$$0(4);
        }
        for (IElementType type : tokenSet.getTypes()) {
            ATTRIBUTES.put(type, LiquidSyntaxHighlighter.withBackground(key));
        }
    }

    private static TextAttributesKey @NotNull [] withBackground(@NotNull TextAttributesKey key) {
        if (key == null) {
            LiquidSyntaxHighlighter.$$$reportNull$$$0(5);
        }
        TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[]{LiquidHighlighterColors.BACKGROUND, key};
        if (textAttributesKeyArray == null) {
            LiquidSyntaxHighlighter.$$$reportNull$$$0(6);
        }
        return textAttributesKeyArray;
    }

    static {
        LiquidSyntaxHighlighter.addTokenSet(LiquidTokenSets.ALL_TAG_NAMES, LiquidHighlighterColors.TAG_NAME);
        LiquidSyntaxHighlighter.addTokenSet(LiquidTokenSets.BOOLEAN, LiquidHighlighterColors.BOOLEAN);
        LiquidSyntaxHighlighter.addTokenSet(LiquidTokenSets.BOOLEAN_OPERATORS, LiquidHighlighterColors.BOOLEAN_OPERATOR);
        LiquidSyntaxHighlighter.addTokenSet(LiquidTokenSets.COMPARISON_OPERATORS, LiquidHighlighterColors.COMPARISON_OPERATOR);
        LiquidSyntaxHighlighter.addTokenSet(LiquidTokenSets.SECONDARY_KEYWORDS, LiquidHighlighterColors.SECONDARY_KEYWORD);
        LiquidSyntaxHighlighter.addTokenSet(LiquidTokenSets.STRING_PART_TOKENS, LiquidHighlighterColors.STRING);
        LiquidSyntaxHighlighter.addTokenSet(LiquidTokenSets.TAG_BRACES, LiquidHighlighterColors.TAG_BRACE);
        LiquidSyntaxHighlighter.addTokenSet(LiquidTokenSets.VALUE_BRACES, LiquidHighlighterColors.VALUE_BRACE);
        LiquidSyntaxHighlighter.addTokenType(LiquidElementTypesGenerated.COMMENT, LiquidHighlighterColors.COMMENT);
        LiquidSyntaxHighlighter.addTokenType(LiquidElementTypesGenerated.COMMENT_TAG, LiquidHighlighterColors.COMMENT);
        LiquidSyntaxHighlighter.addTokenType(LiquidElementTypesGenerated.FILTER_NAME_IDENTIFIER, LiquidHighlighterColors.FILTER_NAME);
        LiquidSyntaxHighlighter.addTokenType(LiquidElementTypesGenerated.IDENTIFIER, LiquidHighlighterColors.IDENTIFIER);
        LiquidSyntaxHighlighter.addTokenType(LiquidElementTypesGenerated.NUMBER, LiquidHighlighterColors.NUMBER);
        LiquidSyntaxHighlighter.addTokenType(LiquidElementTypesGenerated.OPERATOR_ASSIGN, LiquidHighlighterColors.ASSIGNMENT_OPERATOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/highlighting/LiquidSyntaxHighlighter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/highlighting/LiquidSyntaxHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withBackground";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTokenType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTokenSet";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

