/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.highlighting;

import com.intellij.lang.liquid.LiquidBundle;
import com.intellij.lang.liquid.LiquidFileType;
import com.intellij.lang.liquid.LiquidLanguage;
import com.intellij.lang.liquid.highlighting.LiquidHighlighterColors;
import com.intellij.lang.liquid.highlighting.LiquidSyntaxHighlighter;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

final class LiquidColorSettingsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] ATTRS = new AttributesDescriptor[]{LiquidColorSettingsPage.createDescriptor("highlighting.colors.assignment.operator", LiquidHighlighterColors.ASSIGNMENT_OPERATOR), LiquidColorSettingsPage.createDescriptor("highlighting.colors.boolean", LiquidHighlighterColors.BOOLEAN), LiquidColorSettingsPage.createDescriptor("highlighting.colors.boolean.operator", LiquidHighlighterColors.BOOLEAN_OPERATOR), LiquidColorSettingsPage.createDescriptor("highlighting.colors.comparison.operator", LiquidHighlighterColors.COMPARISON_OPERATOR), LiquidColorSettingsPage.createDescriptor("highlighting.colors.comment", LiquidHighlighterColors.COMMENT), LiquidColorSettingsPage.createDescriptor("highlighting.colors.filter.name", LiquidHighlighterColors.FILTER_NAME), LiquidColorSettingsPage.createDescriptor("highlighting.colors.identifier", LiquidHighlighterColors.IDENTIFIER), LiquidColorSettingsPage.createDescriptor("highlighting.colors.number", LiquidHighlighterColors.NUMBER), LiquidColorSettingsPage.createDescriptor("highlighting.colors.secondary.keyword", LiquidHighlighterColors.SECONDARY_KEYWORD), LiquidColorSettingsPage.createDescriptor("highlighting.colors.string", LiquidHighlighterColors.STRING), LiquidColorSettingsPage.createDescriptor("highlighting.colors.tag.braces", LiquidHighlighterColors.TAG_BRACE), LiquidColorSettingsPage.createDescriptor("highlighting.colors.tag.name", LiquidHighlighterColors.TAG_NAME), LiquidColorSettingsPage.createDescriptor("highlighting.colors.background", LiquidHighlighterColors.BACKGROUND), LiquidColorSettingsPage.createDescriptor("highlighting.colors.value.braces", LiquidHighlighterColors.VALUE_BRACE)};

    LiquidColorSettingsPage() {
    }

    @NotNull
    public String getDisplayName() {
        String string = LiquidLanguage.getInstance().getDisplayName();
        if (string == null) {
            LiquidColorSettingsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return LiquidFileType.INSTANCE.getIcon();
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRS == null) {
            LiquidColorSettingsPage.$$$reportNull$$$0(1);
        }
        return ATTRS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            LiquidColorSettingsPage.$$$reportNull$$$0(2);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new LiquidSyntaxHighlighter();
    }

    @NotNull
    public String getDemoText() {
        String string;
        try {
            String text = ResourceUtil.loadText((InputStream)Objects.requireNonNull(LiquidColorSettingsPage.class.getClassLoader().getResourceAsStream("highlighting/demo.txt")));
            string = StringUtil.convertLineSeparators((String)text);
        }
        catch (IOException e) {
            String string2 = "Error reading demo:\n" + e.getMessage();
            if (string2 == null) {
                LiquidColorSettingsPage.$$$reportNull$$$0(4);
            }
            return string2;
        }
        if (string == null) {
            LiquidColorSettingsPage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return null;
    }

    @NotNull
    private static AttributesDescriptor createDescriptor(@PropertyKey(resourceBundle="messages.LiquidBundle") @NotNull @PropertyKey(resourceBundle="messages.LiquidBundle") @NotNull String bundleKey, @NotNull TextAttributesKey key) {
        if (bundleKey == null) {
            LiquidColorSettingsPage.$$$reportNull$$$0(5);
        }
        if (key == null) {
            LiquidColorSettingsPage.$$$reportNull$$$0(6);
        }
        return new AttributesDescriptor(LiquidBundle.message(bundleKey, new Object[0]), key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/highlighting/LiquidColorSettingsPage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/highlighting/LiquidColorSettingsPage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

