/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.liquid.LiquidFileViewProvider;
import com.intellij.lang.liquid.LiquidLanguage;
import com.intellij.lang.liquid.codeInsight.editorActions.LiquidFoldingBuilder;
import com.intellij.lang.liquid.formatter.LiquidFormattingContext;
import com.intellij.lang.liquid.formatter.LiquidSchemaBodyBlock;
import com.intellij.lang.liquid.formatter.LiquidTemplateBlock;
import com.intellij.lang.liquid.psi.LiquidPsiUtil;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypes;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LiquidXmlFormattingModelBuilder
extends AbstractXmlTemplateFormattingModelBuilder {
    private static final Logger LOG = Logger.getInstance(LiquidFoldingBuilder.class);

    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            LiquidXmlFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        FormattingModel formattingModel = LiquidXmlFormattingModelBuilder.useXmlFormattingModelBuilder(formattingContext.getPsiElement()) ? super.createModel(formattingContext) : new SimpleTemplateLanguageFormattingModelBuilder().createModel(formattingContext);
        if (formattingModel == null) {
            LiquidXmlFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        return formattingModel;
    }

    protected boolean isTemplateFile(PsiFile file) {
        return file.getLanguage().isKindOf(LiquidLanguage.getInstance());
    }

    public boolean isOuterLanguageElement(PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) == LiquidElementTypes.LIQUID_OUTER_BLOCK;
    }

    public boolean isMarkupLanguageElement(PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) == LiquidElementTypes.LIQUID_TEMPLATE_BLOCK && !LiquidPsiUtil.isSchemaBody(element);
    }

    protected Block createTemplateLanguageBlock(ASTNode node, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        return this.createTemplateLanguageBlock(new LiquidFormattingContext(settings), node, settings, xmlFormattingPolicy, indent, alignment, wrap);
    }

    Block createTemplateLanguageBlock(@NotNull LiquidFormattingContext formattingContext, ASTNode node, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent indent, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        if (formattingContext == null) {
            LiquidXmlFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        if (LiquidPsiUtil.isSchemaBody(node)) {
            return new LiquidSchemaBodyBlock(node, formattingContext);
        }
        return new LiquidTemplateBlock(this, formattingContext, node, wrap, alignment, settings, xmlFormattingPolicy, indent);
    }

    private static boolean useXmlFormattingModelBuilder(@NotNull PsiElement element) {
        if (element == null) {
            LiquidXmlFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        LOG.assertTrue(viewProvider instanceof LiquidFileViewProvider, (Object)("Got " + String.valueOf(viewProvider)));
        return ((LiquidFileViewProvider)viewProvider).getTemplateDataLanguage().isKindOf((Language)XMLLanguage.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/formatter/LiquidXmlFormattingModelBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/formatter/LiquidXmlFormattingModelBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateLanguageBlock";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "useXmlFormattingModelBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

