/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.liquid.LiquidLanguage;
import com.intellij.lang.liquid.formatter.LiquidInjectedLanguageBlockBuilder;
import com.intellij.lang.liquid.formatter.LiquidTemplateBlock;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.lang.liquid.psi.tree.LiquidTokenSets;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiquidFormattingContext {
    private static final TokenSet WITH_SPACE_ONLY_AFTER = TokenSet.create((IElementType[])new IElementType[]{LiquidElementTypesGenerated.VALUE_OPENER, LiquidElementTypesGenerated.TAG_OPENER, LiquidElementTypesGenerated.COMMA, LiquidElementTypesGenerated.COLON});
    private static final TokenSet WITH_SPACE_ONLY_BEFORE = TokenSet.create((IElementType[])new IElementType[]{LiquidElementTypesGenerated.VALUE_CLOSER, LiquidElementTypesGenerated.TAG_CLOSER});
    private static final TokenSet WITH_SPACE_AROUND = TokenSet.orSet((TokenSet[])new TokenSet[]{LiquidTokenSets.ALL_TAG_NAMES, LiquidTokenSets.ALL_OPERATORS, LiquidTokenSets.SECONDARY_KEYWORDS, TokenSet.create((IElementType[])new IElementType[]{LiquidElementTypesGenerated.PIPE, LiquidElementTypesGenerated.NAMED_ARGUMENT, LiquidElementTypesGenerated.JEKYLL_NAMED_ARGUMENT, LiquidElementTypesGenerated.SNIPPET_NAME})});
    private static final TokenSet NON_INDENTABLE_ELEMENTS = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{LiquidTokenSets.ALL_BLOCK_TAGS, LiquidTokenSets.BRANCH_ELEMENTS, LiquidTokenSets.VALUE_BRACES, TokenSet.create((IElementType[])new IElementType[]{LiquidElementTypesGenerated.ARGUMENTS_LIST})}), (TokenSet)TokenSet.create((IElementType[])new IElementType[]{LiquidElementTypesGenerated.WHEN_BRANCH, LiquidElementTypesGenerated.ELSE_BRANCH}));
    private static final TokenSet NORMAL_INDENTABLE_CONTAINERS = TokenSet.orSet((TokenSet[])new TokenSet[]{LiquidTokenSets.BLOCK_ELEMENTS, LiquidTokenSets.BRANCH_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{LiquidElementTypesGenerated.TAG_LIQUID})});
    @NotNull
    private final SpacingBuilder mySpacingBuilder;
    @NotNull
    private final InjectedLanguageBlockBuilder myInjectedLanguageBlockBuilder;

    LiquidFormattingContext(CodeStyleSettings codeStyleSettings) {
        this.mySpacingBuilder = LiquidFormattingContext.createSpacingBuilder(codeStyleSettings);
        this.myInjectedLanguageBlockBuilder = new LiquidInjectedLanguageBlockBuilder(codeStyleSettings);
    }

    @Nullable
    Spacing getSpacing(@Nullable LiquidTemplateBlock parent, @Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            LiquidFormattingContext.$$$reportNull$$$0(0);
        }
        return this.mySpacingBuilder.getSpacing((Block)parent, child1, child2);
    }

    @NotNull
    Indent getTemplateChildIndent(@NotNull ASTNode childNode, @NotNull LiquidTemplateBlock templateBlock) {
        IElementType parentElementType;
        if (childNode == null) {
            LiquidFormattingContext.$$$reportNull$$$0(1);
        }
        if (templateBlock == null) {
            LiquidFormattingContext.$$$reportNull$$$0(2);
        }
        if (LiquidTokenSets.BLOCK_OR_BRANCH_ELEMENTS.contains(parentElementType = templateBlock.getNode().getElementType())) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                LiquidFormattingContext.$$$reportNull$$$0(3);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            LiquidFormattingContext.$$$reportNull$$$0(4);
        }
        return indent;
    }

    @NotNull
    Indent getChildIndent(@NotNull ASTNode childNode) {
        IElementType childElementType;
        if (childNode == null) {
            LiquidFormattingContext.$$$reportNull$$$0(5);
        }
        if (NON_INDENTABLE_ELEMENTS.contains(childElementType = PsiUtilCore.getElementType((ASTNode)childNode))) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                LiquidFormattingContext.$$$reportNull$$$0(6);
            }
            return indent;
        }
        ASTNode parentNode = childNode.getTreeParent();
        IElementType parentElementType = PsiUtilCore.getElementType((ASTNode)parentNode);
        if (LiquidTokenSets.TAG_BRACES.contains(childElementType) && LiquidTokenSets.ALL_TAGS.contains(parentElementType)) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                LiquidFormattingContext.$$$reportNull$$$0(7);
            }
            return indent;
        }
        if (childElementType == LiquidElementTypesGenerated.ELSE_BRANCH && parentElementType != LiquidElementTypesGenerated.CASE_BLOCK) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                LiquidFormattingContext.$$$reportNull$$$0(8);
            }
            return indent;
        }
        if (NORMAL_INDENTABLE_CONTAINERS.contains(parentElementType)) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                LiquidFormattingContext.$$$reportNull$$$0(9);
            }
            return indent;
        }
        if (LiquidTokenSets.ALL_TAGS.contains(parentElementType) && parentNode.getStartOffset() != childNode.getStartOffset()) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                LiquidFormattingContext.$$$reportNull$$$0(10);
            }
            return indent;
        }
        if (LiquidElementTypesGenerated.ARGUMENTS_LIST == parentElementType) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                LiquidFormattingContext.$$$reportNull$$$0(11);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            LiquidFormattingContext.$$$reportNull$$$0(12);
        }
        return indent;
    }

    @Nullable
    Alignment getChildAlignment(ASTNode child) {
        return null;
    }

    @Nullable
    Wrap getChildWrap(ASTNode child) {
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
    }

    @NotNull
    InjectedLanguageBlockBuilder getInjectedLanguageBlockBuilder() {
        InjectedLanguageBlockBuilder injectedLanguageBlockBuilder = this.myInjectedLanguageBlockBuilder;
        if (injectedLanguageBlockBuilder == null) {
            LiquidFormattingContext.$$$reportNull$$$0(13);
        }
        return injectedLanguageBlockBuilder;
    }

    private static SpacingBuilder createSpacingBuilder(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            LiquidFormattingContext.$$$reportNull$$$0(14);
        }
        return new SpacingBuilder(codeStyleSettings, LiquidLanguage.getInstance()).before(WITH_SPACE_ONLY_AFTER).spaces(0).after(WITH_SPACE_ONLY_AFTER).spaces(1).before(WITH_SPACE_ONLY_BEFORE).spaces(1).after(WITH_SPACE_ONLY_BEFORE).spaces(0).aroundInside(LiquidElementTypesGenerated.OPERATOR_ASSIGN, LiquidElementTypesGenerated.JEKYLL_NAMED_ARGUMENT).spaces(0).around(WITH_SPACE_AROUND).spaces(1).around(LiquidElementTypesGenerated.PERIOD).spaces(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateBlock";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/formatter/LiquidFormattingContext";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/formatter/LiquidFormattingContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateChildIndent";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedLanguageBlockBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateChildIndent";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSpacingBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

