/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.liquid.LiquidFileViewProvider;
import com.intellij.lang.liquid.LiquidLanguage;
import com.intellij.lang.liquid.psi.LiquidFilterHolder;
import com.intellij.lang.liquid.psi.LiquidPsiUtil;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class LiquidTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        FileViewProvider viewProvider;
        if (project == null) {
            LiquidTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LiquidTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            LiquidTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            LiquidTypedHandler.$$$reportNull$$$0(3);
        }
        if ((viewProvider = file.getViewProvider()) instanceof LiquidFileViewProvider && (c == '{' || c == '%')) {
            return LiquidTypedHandler.handleTagOrValueOpenerChar(c, editor, viewProvider, project);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            LiquidTypedHandler.$$$reportNull$$$0(4);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        FileViewProvider viewProvider;
        if (project == null) {
            LiquidTypedHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            LiquidTypedHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            LiquidTypedHandler.$$$reportNull$$$0(7);
        }
        if ((viewProvider = file.getViewProvider()) instanceof LiquidFileViewProvider && c == '|') {
            return LiquidTypedHandler.handleFilterPipe(editor, viewProvider, project);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            LiquidTypedHandler.$$$reportNull$$$0(8);
        }
        return result;
    }

    @NotNull
    private static TypedHandlerDelegate.Result handleTagOrValueOpenerChar(char c, @NotNull Editor editor, @NotNull FileViewProvider viewProvider, @NotNull Project project) {
        int offset;
        if (editor == null) {
            LiquidTypedHandler.$$$reportNull$$$0(9);
        }
        if (viewProvider == null) {
            LiquidTypedHandler.$$$reportNull$$$0(10);
        }
        if (project == null) {
            LiquidTypedHandler.$$$reportNull$$$0(11);
        }
        if ((offset = editor.getCaretModel().getOffset()) < 1) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                LiquidTypedHandler.$$$reportNull$$$0(12);
            }
            return result;
        }
        IElementType previousElementType = editor.getHighlighter().createIterator(offset - 1).getTokenType();
        if (previousElementType.getLanguage().isKindOf(LiquidLanguage.getInstance()) && previousElementType != LiquidElementTypesGenerated.TAG_OPENER && previousElementType != LiquidElementTypesGenerated.VALUE_OPENER) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                LiquidTypedHandler.$$$reportNull$$$0(13);
            }
            return result;
        }
        if (LiquidPsiUtil.isInsideLiquidTag(viewProvider.findElementAt(offset - 1, LiquidLanguage.getInstance()))) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                LiquidTypedHandler.$$$reportNull$$$0(14);
            }
            return result;
        }
        String text = editor.getDocument().getText();
        if (text.charAt(offset - 1) != '{' || offset > 1 && text.charAt(offset - 2) == '{') {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                LiquidTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        char closerChar = c == '{' ? (char)'}' : (char)c;
        StringBuilder stringToInsert = new StringBuilder().append(c);
        int closerRelativeOffset = LiquidTypedHandler.getCloserRelativeOffset(closerChar, text, offset);
        if (closerRelativeOffset < 2) {
            stringToInsert.append(" ");
            if (closerRelativeOffset < 1) {
                stringToInsert.append(" ");
                if (closerRelativeOffset < 0) {
                    stringToInsert.append(closerChar);
                    if (offset == text.length() || text.charAt(offset) != '}') {
                        stringToInsert.append('}');
                    }
                }
            }
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert.toString(), (boolean)false, (int)2);
        if (c == '%') {
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
        if (result == null) {
            LiquidTypedHandler.$$$reportNull$$$0(16);
        }
        return result;
    }

    private static int getCloserRelativeOffset(char closerChar, @NotNull String text, int offset) {
        int closerOffset;
        if (text == null) {
            LiquidTypedHandler.$$$reportNull$$$0(17);
        }
        if ((closerOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)offset, (int)(text.length() - 1), (String)" ")) + 1 < text.length() && text.charAt(closerOffset) == closerChar && text.charAt(closerOffset + 1) == '}') {
            return closerOffset - offset;
        }
        return -1;
    }

    @NotNull
    private static TypedHandlerDelegate.Result handleFilterPipe(@NotNull Editor editor, @NotNull FileViewProvider viewProvider, @NotNull Project project) {
        int offset;
        if (editor == null) {
            LiquidTypedHandler.$$$reportNull$$$0(18);
        }
        if (viewProvider == null) {
            LiquidTypedHandler.$$$reportNull$$$0(19);
        }
        if (project == null) {
            LiquidTypedHandler.$$$reportNull$$$0(20);
        }
        if ((offset = editor.getCaretModel().getOffset()) < 2) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                LiquidTypedHandler.$$$reportNull$$$0(21);
            }
            return result;
        }
        if (editor.getHighlighter().createIterator(offset - 1).getTokenType() != LiquidElementTypesGenerated.PIPE) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                LiquidTypedHandler.$$$reportNull$$$0(22);
            }
            return result;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)viewProvider.findElementAt(offset, LiquidLanguage.getInstance()), LiquidFilterHolder.class) == null) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                LiquidTypedHandler.$$$reportNull$$$0(23);
            }
            return result;
        }
        String text = editor.getDocument().getText();
        if (!LiquidTypedHandler.rightSideIsAppropriate(text, offset)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                LiquidTypedHandler.$$$reportNull$$$0(24);
            }
            return result;
        }
        if (text.charAt(offset - 2) != ' ') {
            editor.getDocument().insertString(offset - 1, (CharSequence)" ");
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ", (boolean)false, (boolean)true);
        AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
        if (result == null) {
            LiquidTypedHandler.$$$reportNull$$$0(25);
        }
        return result;
    }

    private static boolean rightSideIsAppropriate(@NotNull String text, int offset) {
        if (text == null) {
            LiquidTypedHandler.$$$reportNull$$$0(26);
        }
        return (offset = CharArrayUtil.shiftForward((CharSequence)text, (int)offset, (int)(text.length() - 1), (String)" ")) < text.length() && "|%}\n".indexOf(text.charAt(offset)) > -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 12, 13, 14, 15, 16, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidTypedHandler";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/codeInsight/editorActions/LiquidTypedHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "handleTagOrValueOpenerChar";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "handleFilterPipe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleTagOrValueOpenerChar";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCloserRelativeOffset";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "handleFilterPipe";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "rightSideIsAppropriate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 12, 13, 14, 15, 16, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

