/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypesGenerated;
import com.intellij.lang.liquid.psi.tree.LiquidTokenSets;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;

public final class LiquidQuoteHandler
implements QuoteHandler {
    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        return iterator.getTokenType() == LiquidElementTypesGenerated.CLOSE_QUOTE;
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        return iterator.getTokenType() == LiquidElementTypesGenerated.OPEN_QUOTE;
    }

    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == LiquidElementTypesGenerated.CLOSE_QUOTE || !LiquidTokenSets.STRING_PART_TOKENS.contains(tokenType)) {
                return false;
            }
            iterator.advance();
        }
        return true;
    }

    public boolean isInsideLiteral(HighlighterIterator iterator) {
        return LiquidTokenSets.STRING_PART_TOKENS.contains(iterator.getTokenType());
    }
}

