/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.liquid;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.liquid.LiquidLanguage;
import com.intellij.lang.liquid.psi.tree.LiquidElementTypes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.collections.SetsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiquidFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    @NotNull
    private final Language myTemplatingLanguage;

    public LiquidFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(1);
        }
        super(manager, virtualFile, eventSystemEnabled);
        this.myTemplatingLanguage = LiquidFileViewProvider.computeTemplateLanguage(virtualFile);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(2);
        }
        if (lang != this.getTemplateDataLanguage()) {
            return super.createFile(lang);
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition == null) {
            return null;
        }
        PsiFile psiFile = parserDefinition.createFile((FileViewProvider)this);
        if (psiFile instanceof PsiFileImpl) {
            ((PsiFileImpl)psiFile).setContentElementType(LiquidElementTypes.LIQUID_TEMPLATE_DATA);
        }
        return psiFile;
    }

    @Nullable
    public IElementType getContentElementType(@NotNull Language language) {
        if (language == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(3);
        }
        return language == this.getTemplateDataLanguage() ? LiquidElementTypes.LIQUID_TEMPLATE_DATA : null;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = LiquidLanguage.getInstance();
        if (language == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(4);
        }
        return language;
    }

    @NotNull
    protected MultiplePsiFilesPerDocumentFileViewProvider cloneInner(@NotNull VirtualFile fileCopy) {
        if (fileCopy == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(5);
        }
        return new LiquidFileViewProvider((PsiManager)this.getManager(), fileCopy, false);
    }

    @NotNull
    public Set<Language> getLanguages() {
        HashSet hashSet = SetsKt.hashSetOf((Object[])new Language[]{this.getBaseLanguage(), this.getTemplateDataLanguage()});
        if (hashSet == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplatingLanguage;
        if (language == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(7);
        }
        return language;
    }

    @NotNull
    public static Language computeTemplateLanguage(@NotNull VirtualFile virtualFile) {
        FileType fileType;
        if (virtualFile == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(8);
        }
        if (!((fileType = LiquidFileViewProvider.getTemplateFileType(virtualFile)) instanceof LanguageFileType)) {
            HTMLLanguage hTMLLanguage = HTMLLanguage.INSTANCE;
            if (hTMLLanguage == null) {
                LiquidFileViewProvider.$$$reportNull$$$0(9);
            }
            return hTMLLanguage;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        Object object = language instanceof TemplateLanguage ? HTMLLanguage.INSTANCE : language;
        if (object == null) {
            LiquidFileViewProvider.$$$reportNull$$$0(10);
        }
        return object;
    }

    @Nullable
    private static FileType getTemplateFileType(@Nullable VirtualFile virtualFile) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (virtualFile == null) {
            return null;
        }
        List nameChunks = StringUtil.split((String)virtualFile.getName(), (String)".");
        if (nameChunks.size() < 3) {
            return null;
        }
        FileType fileType = fileTypeManager.getFileTypeByExtension((String)nameChunks.get(nameChunks.size() - 2));
        return fileType == UnknownFileType.INSTANCE ? null : fileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/liquid/LiquidFileViewProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/liquid/LiquidFileViewProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTemplateLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContentElementType";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

