/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlTagDelegate;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CharTable;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.psi.HAMLAttributeProvider;
import org.jetbrains.plugins.haml.psi.HAMLElementTypes;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLClassOrIdImpl;

public class HAMLTagImpl
extends XmlTagImpl
implements HtmlTag,
PsiLanguageInjectionHost {
    public HAMLTagImpl() {
        super(HAMLElementTypes.HAML_TAG);
    }

    @NotNull
    public String getName() {
        String name = super.getName();
        return !StringUtil.isEmpty((String)name) ? name : "div";
    }

    public boolean isTagNameEmpty() {
        String name = super.getName();
        return StringUtil.isEmpty((String)name);
    }

    public String toString() {
        return "HAMLTag:" + this.getName();
    }

    public String getAttributeValue(String qname) {
        for (HAMLAttributeProvider provider : (HAMLAttributeProvider[])HAMLAttributeProvider.EP_NAME.getExtensions()) {
            String attribute = provider.getAttribute(this, qname);
            if (attribute == null) continue;
            return attribute;
        }
        return super.getAttributeValue(qname);
    }

    @NotNull
    public String getNamespace() {
        String xmlNamespace = super.getNamespace();
        if (!this.getNamespacePrefix().isEmpty()) {
            String string = xmlNamespace;
            if (string == null) {
                HAMLTagImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (xmlNamespace.isEmpty() || xmlNamespace.equals("http://www.w3.org/1999/xhtml")) {
            return "http://www.w3.org/1999/html";
        }
        String string = xmlNamespace;
        if (string == null) {
            HAMLTagImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getRealNs(@Nullable String value) {
        if ("http://www.w3.org/1999/xhtml".equals(value)) {
            return "http://www.w3.org/1999/html";
        }
        return value;
    }

    public String getPrefixByNamespace(String namespace) {
        if ("http://www.w3.org/1999/html".equals(namespace)) {
            namespace = "http://www.w3.org/1999/xhtml";
        }
        return super.getPrefixByNamespace(namespace);
    }

    public XmlAttribute getAttribute(String qname) {
        if (qname == null) {
            return null;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)this);
        XmlAttribute[] attributes = this.getAttributes();
        CharSequence charTableIndex = charTableByTree.intern((CharSequence)qname);
        boolean caseSensitive = this.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            CharSequence name;
            ASTNode attrNameElement = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            CharSequence charSequence = attrNameElement instanceof HAMLClassOrIdImpl ? charTableByTree.intern((CharSequence)attribute.getLocalName()) : (name = attrNameElement != null ? attrNameElement.getChars() : null);
            if (name == null || (!caseSensitive || !name.equals(charTableIndex)) && (caseSensitive || !Comparing.equal((CharSequence)name, (CharSequence)charTableIndex, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    public XmlElementDescriptor getDescriptor() {
        XmlTag parentTag;
        TreeElement node = this.getFirstChildNode();
        if (node != null && node.getElementType() == HAMLTokenTypes.RUBY_CODE_MARKER && (parentTag = this.getParentTag()) != null) {
            return parentTag.getDescriptor();
        }
        return super.getDescriptor();
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            HAMLTagImpl.$$$reportNull$$$0(2);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            HAMLTagImpl.$$$reportNull$$$0(3);
        }
        return literalTextEscaper;
    }

    @NotNull
    protected XmlTagDelegate createDelegate() {
        return new HAMLTagImplDelegate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/haml/psi/impl/HAMLTagImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/haml/psi/impl/HAMLTagImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private class HAMLTagImplDelegate
    extends XmlTagImpl.XmlTagImplDelegate {
        private HAMLTagImplDelegate() {
            super((XmlTagImpl)HAMLTagImpl.this);
        }

        protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
            if ("class".equals(name)) {
                XmlAttribute[] attributes = HAMLTagImpl.this.getAttributes();
                StringBuilder attributeValue = new StringBuilder();
                for (XmlAttribute attribute : attributes) {
                    if (!"class".equals(attribute.getName())) continue;
                    attributeValue.append(attribute.getValue()).append(' ');
                }
                attributesValueMap.put(name, attributeValue.toString().trim());
            } else {
                super.cacheOneAttributeValue(name, value, attributesValueMap);
            }
        }
    }
}

