/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.highlighter.HAMLHighlighter;
import org.jetbrains.plugins.haml.lexer.HAMLLexer;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;

public final class HAMLSyntaxHighlighter
extends SyntaxHighlighterBase
implements HAMLTokenTypes {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = HAMLSyntaxHighlighter.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            HAMLSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new HAMLLexer();
    }

    static {
        ATTRIBUTES.put(HAMLTokenTypes.TAG_START, HAMLHighlighter.TAG);
        ATTRIBUTES.put(HAMLTokenTypes.CLOSE_TAG, HAMLHighlighter.TAG);
        ATTRIBUTES.put(HAMLTokenTypes.TAG_NAME, HAMLHighlighter.TAG_NAME);
        ATTRIBUTES.put(HAMLTokenTypes.EQUALS, HAMLHighlighter.TAG_NAME);
        ATTRIBUTES.put(HAMLTokenTypes.CLASS, HAMLHighlighter.CLASS);
        ATTRIBUTES.put(HAMLTokenTypes.CLASS_START, HAMLHighlighter.TAG);
        ATTRIBUTES.put(HAMLTokenTypes.ID, HAMLHighlighter.ID);
        ATTRIBUTES.put(HAMLTokenTypes.ID_START, HAMLHighlighter.TAG);
        ATTRIBUTES.put(HAMLTokenTypes.LINE_COMMENT, HAMLHighlighter.COMMENT);
        ATTRIBUTES.put(HAMLTokenTypes.CONDITIONAL_COMMENT, HAMLHighlighter.COMMENT);
        ATTRIBUTES.put(HAMLTokenTypes.HTML_COMMENT, HAMLHighlighter.COMMENT);
        ATTRIBUTES.put(HAMLTokenTypes.HAML_COMMENT, HAMLHighlighter.COMMENT);
        ATTRIBUTES.put(HAMLTokenTypes.XHTML, HAMLHighlighter.XHTML);
        ATTRIBUTES.put(HAMLTokenTypes.TEXT, HAMLHighlighter.TEXT);
        ATTRIBUTES.put(HAMLTokenTypes.INJECTION_CODE, HAMLHighlighter.INJECTED_CODE);
        ATTRIBUTES.put(HAMLTokenTypes.LINE_CONTINUATION, HAMLHighlighter.LINE_CONTINUATION);
        ATTRIBUTES.put(HAMLTokenTypes.RUBY_CODE_MARKER, HAMLHighlighter.RUBY_START);
        ATTRIBUTES.put(HAMLTokenTypes.RUBY_STRING_MARKER, HAMLHighlighter.RUBY_START);
        ATTRIBUTES.put(HAMLTokenTypes.FILTER, HAMLHighlighter.FILTER);
        ATTRIBUTES.put(HAMLTokenTypes.FILTER_CONTENT, HAMLHighlighter.FILTER_CONTENT);
        ATTRIBUTES.put(XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, HAMLHighlighter.STRING);
        ATTRIBUTES.put(XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, HAMLHighlighter.STRING);
        ATTRIBUTES.put(XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, HAMLHighlighter.STRING);
        ATTRIBUTES.put(HAMLTokenTypes.OP_BRACE, HAMLHighlighter.PARENTHS);
        ATTRIBUTES.put(HAMLTokenTypes.CL_BRACE, HAMLHighlighter.PARENTHS);
        ATTRIBUTES.put(HAMLTokenTypes.SPACE_EATER, HAMLHighlighter.SPACES_EATER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/highlighter/HAMLSyntaxHighlighter", "getTokenHighlights"));
    }
}

