/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.css;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.util.CssInHtmlClassOrIdReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.plugins.haml.psi.HAMLFile;

public class CssInHAMLClassOrIdReferenceProvider
extends CssInHtmlClassOrIdReferenceProvider {
    public ElementFilter getFilter() {
        return new CssInHamlElementFilter();
    }

    private static class CssInHamlElementFilter
    implements ElementFilter {
        private CssInHamlElementFilter() {
        }

        public boolean isAcceptable(Object element, PsiElement context) {
            XmlAttribute xmlAttribute;
            String attrName;
            PsiElement parent;
            PsiElement psiElement = (PsiElement)element;
            return psiElement.getContainingFile() instanceof HAMLFile && (parent = psiElement.getParent()) instanceof XmlAttribute && CssInHamlElementFilter.isSuitableAttribute(attrName = (xmlAttribute = (XmlAttribute)parent).getName(), xmlAttribute) && StringUtil.isEmpty((String)xmlAttribute.getParent().getNamespacePrefix());
        }

        private static boolean isSuitableAttribute(String attrName, XmlAttribute xmlAttribute) {
            return "class".equalsIgnoreCase(attrName) || "id".equalsIgnoreCase(attrName);
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }
}

