/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby.rails.associations;

import com.intellij.diagram.ruby.RubyUmlBundle;
import com.intellij.diagram.ruby.rails.associations.AssociationManager;
import com.intellij.diagram.ruby.rails.associations.AssociationProperty;
import com.intellij.diagram.ruby.rails.associations.AssociationRelationship;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.AssociatedItem;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.mongoid.MongoField;
import org.jetbrains.plugins.ruby.mongoid.MongoModel;
import org.jetbrains.plugins.ruby.mongoid.associations.MongoAssociation;
import org.jetbrains.plugins.ruby.mongoid.associations.MongoAssociationFactory;
import org.jetbrains.plugins.ruby.rails.associations.AssociationType;
import org.jetbrains.plugins.ruby.rails.associations.AssociationsParser;
import org.jetbrains.plugins.ruby.rails.associations.RailsAssociationFactory;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;

public final class AssociationManagerImpl
extends AssociationManager {
    private static final Logger LOG = Logger.getInstance(AssociationManagerImpl.class);
    private final Module myModule;
    private Map<FQN, RClass> myFirstClassMap = new HashMap<FQN, RClass>();
    private final List<RClass> myClasses = new ArrayList<RClass>();
    private volatile boolean myInitialized = false;
    private Set<AssociationRelationship> myRelationships = new HashSet<AssociationRelationship>();
    private Map<RClass, List<AssociationRelationship>> myClass2Relationships;
    @Nullable
    private final RailsApp myApp;
    private final AssociationsParser myAssociationsParser;

    public AssociationManagerImpl(Module module) {
        this.myModule = module;
        this.myApp = RailsApp.fromModule((Module)module);
        this.myAssociationsParser = AssociationsParser.getInstance((Module)this.myModule);
        this.initializeMaps();
    }

    @Override
    @NotNull
    public Collection<RClass> getModelClasses() {
        List<RClass> list = this.myClasses;
        if (list == null) {
            AssociationManagerImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public List<AssociationProperty> getProperties(RClass rClass) {
        MongoModel mongoModel;
        Collection dbFields;
        HashSet<AssociationProperty> properties = new HashSet<AssociationProperty>();
        ActiveRecordModel model = ActiveRecordModel.fromClass((RClass)rClass);
        if (model != null && (dbFields = model.getDBFields()) != null) {
            for (MigrationField migrationField : dbFields) {
                AssociationProperty property = new AssociationProperty(this.myModule, migrationField);
                String dataType = migrationField.getDataType();
                if (dataType == null) continue;
                property.setDataType(dataType);
                properties.add(property);
            }
        }
        if ((mongoModel = MongoModel.fromClass((RClass)rClass)) != null) {
            mongoModel.processFields(field -> {
                AssociationProperty property = new AssociationProperty(this.myModule, (MongoField)field);
                properties.add(property);
            });
        }
        for (RClass aClass : this.myClasses) {
            List<AssociationRelationship> to = this.getRelationships(rClass, aClass);
            List<AssociationRelationship> from = this.getRelationships(aClass, rClass);
            to.addAll(from);
            for (AssociationRelationship relationship : to) {
                Association association = relationship.getAssociation();
                if (association == null) continue;
                AssociationProperty property = new AssociationProperty(this.myModule, association.getName());
                for (AssociatedItem resolvedItem : association.getResolvedItems()) {
                    RClass resolvedModel = resolvedItem.getRClass();
                    property.setDataType(resolvedModel.getName());
                    properties.add(property);
                }
            }
        }
        ArrayList<AssociationProperty> result = new ArrayList<AssociationProperty>(properties);
        result.sort((o1, o2) -> {
            if (o1 == null || o2 == null || o1.getName() == null || o2.getName() == null) {
                return 0;
            }
            return o1.getName().compareTo(o2.getName());
        });
        return result;
    }

    @Override
    public List<AssociationRelationship> getRelationships(RClass source, RClass target) {
        ArrayList<AssociationRelationship> relationships = new ArrayList<AssociationRelationship>();
        for (AssociationRelationship edge : this.myRelationships) {
            if (!source.isEquivalentTo((PsiElement)edge.getSourceClass()) || !target.isEquivalentTo((PsiElement)edge.getTargetClass())) continue;
            relationships.add(edge);
        }
        return relationships;
    }

    @Override
    public void refresh() {
        this.myClasses.clear();
        this.myFirstClassMap.clear();
        this.myClass2Relationships.clear();
        this.myRelationships.clear();
        this.myInitialized = false;
        this.initializeMaps();
    }

    private void initializeMaps() {
        if (this.myInitialized) {
            return;
        }
        this.myFirstClassMap = new HashMap<FQN, RClass>();
        this.myRelationships = new HashSet<AssociationRelationship>();
        this.myClass2Relationships = new HashMap<RClass, List<AssociationRelationship>>();
        List roots = RailsPaths.getInstance((Module)this.myModule).findFiles("app/models");
        long start = System.currentTimeMillis();
        AssociationManagerImpl.setProgress(-1.0, RubyUmlBundle.message("progress.text.building.nodes", new Object[0]));
        roots.forEach(this::addAllNodes);
        AssociationManagerImpl.setProgress(0.1, RubyUmlBundle.message("progress.text.building.edges", new Object[0]));
        this.addAllEdges();
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Creating association data model took " + (System.currentTimeMillis() - start) + " ms");
        }
        this.myInitialized = true;
    }

    private void addAllNodes(@Nullable VirtualFile root) {
        if (root == null) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

            public boolean visitFile(@NotNull VirtualFile file) {
                PsiFile psiFile;
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (!file.isDirectory() && (psiFile = PsiManager.getInstance((Project)AssociationManagerImpl.this.myModule.getProject()).findFile(file)) instanceof RFile) {
                    AssociationManagerImpl.this.addNodes((RContainer)((RFile)psiFile));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diagram/ruby/rails/associations/AssociationManagerImpl$1", "visitFile"));
            }
        });
    }

    private void addAllEdges() {
        HashSet used = new HashSet();
        HashSet<Association> unusedBelongs = new HashSet<Association>();
        HashMap<RClass, Set<RClass>> modelsCache = new HashMap<RClass, Set<RClass>>();
        PairConsumer hasOneOrManyAction = (association, reverseAssociation) -> {
            used.add(association);
            if (reverseAssociation != null) {
                used.add(reverseAssociation);
                unusedBelongs.remove(reverseAssociation);
            }
        };
        PairConsumer habtmAction = (association, reverseAssociation) -> {
            used.add(association);
            if (reverseAssociation != null) {
                used.add(reverseAssociation);
            }
        };
        for (RClass rClass : this.myClasses) {
            Set<RClass> models = this.getMyDeclarations(rClass, modelsCache);
            Condition<Association> habtmCondition = AssociationManagerImpl.createHABTMCondition(models);
            for (Association association2 : this.myAssociationsParser.getAllAssociations(rClass)) {
                ProgressManager.checkCanceled();
                if (association2.getFactory() == RailsAssociationFactory.getInstance()) {
                    if (used.contains(association2)) continue;
                    Condition<Association> associationCondition = AssociationManagerImpl.createHasOneOrManyCondition(models, association2);
                    AssociationType type = association2.getType();
                    if (type == AssociationType.HAS_AND_BELONGS_TO_MANY) {
                        this.createEdgeForHas(rClass, association2, habtmCondition, (PairConsumer<Association, Association>)habtmAction, modelsCache);
                        continue;
                    }
                    if (type == AssociationType.HAS_MANY || type == AssociationType.HAS_ONE) {
                        this.createEdgeForHas(rClass, association2, associationCondition, (PairConsumer<Association, Association>)hasOneOrManyAction, modelsCache);
                        continue;
                    }
                    if (type != AssociationType.BELONGS_TO) continue;
                    List resolvedItems = association2.getResolvedItems();
                    for (AssociatedItem resolvedItem : resolvedItems) {
                        Association reverseAssociation2 = this.findReverseRec(associationCondition, modelsCache, resolvedItem.getRClass(), new HashSet<RClass>());
                        if (reverseAssociation2 != null) continue;
                        this.createEdgeForHas(rClass, association2, habtmCondition, (PairConsumer<Association, Association>)habtmAction, modelsCache);
                    }
                    if (!resolvedItems.isEmpty()) continue;
                    unusedBelongs.add(association2);
                    continue;
                }
                if (association2.getFactory() != MongoAssociationFactory.getInstance()) continue;
                this.createMongoEdge((MongoAssociation)association2);
            }
        }
        double i = 0.0;
        for (Association belongs : unusedBelongs) {
            AssociatedItem model = belongs.getItem();
            for (AssociatedItem resolvedModel : belongs.getResolvedItems()) {
                if (model == null) continue;
                AssociationRelationship edge = new AssociationRelationship(model.getRClass(), resolvedModel.getRClass(), belongs, null);
                this.registerEdge(edge);
            }
            double d = i;
            i = d + 1.0;
            double progress = 0.9 + d / (double)unusedBelongs.size() * 0.1;
            AssociationManagerImpl.setProgress(progress, RubyUmlBundle.message("progress.text.finishing.edges", new Object[0]));
        }
        this.addInheritanceEdges();
    }

    private void createMongoEdge(MongoAssociation association) {
        AssociatedItem item = association.getItem();
        for (AssociatedItem resolvedItem : association.getResolvedItems()) {
            if (association.getType() != AssociationType.EMBEDDED_IN) continue;
            List reverseAssociations = resolvedItem.getAssociations();
            for (Association reverseAssociation : reverseAssociations) {
                if (!item.equals((Object)resolvedItem) || reverseAssociation.getType() != AssociationType.EMBEDS_ONE && reverseAssociation.getType() != AssociationType.EMBEDS_MANY) continue;
                AssociationRelationship relationship = new AssociationRelationship(item.getRClass(), resolvedItem.getRClass(), (Association)association, reverseAssociation);
                this.registerEdge(relationship);
            }
        }
    }

    private void addInheritanceEdges() {
        for (RClass rClass : this.myClasses) {
            RClass parentClazz = this.getSuperClass(rClass);
            if (parentClazz == null) continue;
            AssociationRelationship edge = new AssociationRelationship(rClass, parentClazz, null, null);
            this.registerEdge(edge);
        }
    }

    @Nullable
    private RClass getSuperClass(RClass typeDefinition) {
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)typeDefinition);
        if (!(symbol instanceof ClassModuleSymbol)) {
            return null;
        }
        Symbol superClassSymbol = ((ClassModuleSymbol)symbol).getSuperClassSymbol(null);
        FQN fullName = superClassSymbol != null ? superClassSymbol.getFQNWithNesting() : FQN.INVALID;
        return this.myFirstClassMap.get(fullName);
    }

    private static void setProgress(double progress, @NlsContexts.ProgressText @Nullable String text) {
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            if (progress < 0.0) {
                progressIndicator.setIndeterminate(true);
            } else {
                progressIndicator.setIndeterminate(false);
                progressIndicator.setFraction(progress);
            }
            progressIndicator.setText(text);
        }
    }

    private static Condition<Association> createHABTMCondition(Set<RClass> models) {
        return o -> o.getResolvedItems().stream().anyMatch(resolvedItem -> models.contains(resolvedItem.getRClass()) && o.getType() == AssociationType.HAS_AND_BELONGS_TO_MANY);
    }

    private static Condition<Association> createHasOneOrManyCondition(Set<RClass> models, Association association) {
        return o -> o.getResolvedItems().stream().anyMatch(resolvedItem -> {
            if (models.contains(resolvedItem.getRClass())) {
                return o.getType() == AssociationType.BELONGS_TO || o.getType() == association.getType() && o.getThroughModels().equals(association.getThroughModels());
            }
            String as = association.getAs();
            if (as != null) {
                return o.getType() == AssociationType.BELONGS_TO && o.isPolymorphic() && Comparing.strEqual((String)o.getName(), (String)as);
            }
            return false;
        });
    }

    private Set<RClass> getMyDeclarations(RClass typeDefinition, Map<RClass, Set<RClass>> cache) {
        if (typeDefinition == null) {
            return Collections.emptySet();
        }
        Set<RClass> models = cache.get(typeDefinition);
        if (models != null) {
            return models;
        }
        HashSet<RClass> partials = new HashSet<RClass>();
        List classes = RubyFQNUtil.getFQNBasedPartialDeclarations((RContainer)typeDefinition, (boolean)false, null);
        partials.add(typeDefinition);
        for (RContainer aClass : classes) {
            PsiFile file = aClass.getContainingFile();
            ModuleFileIndex index = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
            VirtualFile vFile = file.getVirtualFile();
            if (!(aClass instanceof RClass) || this.myApp != null && this.myApp.isEdgeRailsFile(file) || vFile == null || !index.isInContent(vFile)) continue;
            partials.add((RClass)aClass);
        }
        cache.put(typeDefinition, partials);
        return partials;
    }

    private void createEdgeForHas(RClass rClass, Association association, Condition<Association> condition, PairConsumer<Association, Association> postAddAction, Map<RClass, Set<RClass>> modelsCache) {
        for (AssociatedItem resolvedItem : association.getResolvedItems()) {
            RClass resolvedClass = resolvedItem.getRClass();
            Association reverseAssociation = this.findReverseRec(condition, modelsCache, resolvedClass, new HashSet<RClass>());
            Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)resolvedClass);
            FQN fqn = symbol != null ? symbol.getFQNWithNesting() : resolvedClass.getFQN();
            RClass first = this.myFirstClassMap.get(fqn);
            if (first != null) {
                AssociationRelationship edge = new AssociationRelationship(rClass, first, association, reverseAssociation);
                this.registerEdge(edge);
            }
            if (reverseAssociation == null) continue;
            postAddAction.consume((Object)association, (Object)reverseAssociation);
        }
    }

    @Nullable
    private Association findReverseRec(Condition<Association> condition, Map<RClass, Set<RClass>> modelsCache, RClass resolvedModel, Set<RClass> visited) {
        RClass cl;
        RClass superClass;
        visited.add(resolvedModel);
        Set<RClass> classes = this.getMyDeclarations(resolvedModel, modelsCache);
        Association reverseAssociation = this.findReverse(condition, classes);
        if (reverseAssociation == null && !classes.isEmpty() && !visited.contains(superClass = this.getSuperClass(cl = classes.iterator().next()))) {
            return this.findReverseRec(condition, modelsCache, superClass, visited);
        }
        return reverseAssociation;
    }

    @Nullable
    private Association findReverse(Condition<Association> condition, Set<RClass> classes) {
        for (RClass current : classes) {
            Association reverseAssociation = (Association)ContainerUtil.find((Iterable)this.myAssociationsParser.getAllAssociations(current), condition);
            if (reverseAssociation == null) continue;
            return reverseAssociation;
        }
        return null;
    }

    private void registerEdge(AssociationRelationship relationship) {
        AssociationManagerImpl.addRelationshipToMap(relationship, relationship.getSourceClass(), this.myClass2Relationships);
        if (!relationship.getSourceClass().equals((Object)relationship.getTargetClass())) {
            AssociationManagerImpl.addRelationshipToMap(relationship, relationship.getTargetClass(), this.myClass2Relationships);
        }
        this.myRelationships.add(relationship);
    }

    private static void addRelationshipToMap(AssociationRelationship edge, RClass key, Map<RClass, List<AssociationRelationship>> map) {
        List<AssociationRelationship> relationships = map.get(key);
        if (relationships == null) {
            relationships = new ArrayList<AssociationRelationship>();
            map.put(key, relationships);
        }
        relationships.add(edge);
    }

    private void addNodes(RContainer container) {
        for (RClass clazz : RContainerUtil.getTopLevelClasses((RContainer)container)) {
            if (clazz == null || clazz instanceof RObjectClass) {
                return;
            }
            Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)clazz);
            FQN fqn = symbol != null ? symbol.getFQNWithNesting() : clazz.getFQN();
            RClass first = this.myFirstClassMap.get(fqn);
            if (first != null) {
                this.myClasses.add(clazz);
                continue;
            }
            this.myFirstClassMap.put(fqn, clazz);
            this.myClasses.add(clazz);
            this.addNodes((RContainer)clazz);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diagram/ruby/rails/associations/AssociationManagerImpl", "getModelClasses"));
    }
}

