/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby.rails;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.diagram.ruby.rails.RailsAddElementAction;
import com.intellij.diagram.ruby.rails.RailsUmlDnDSupport;
import com.intellij.diagram.ruby.rails.RailsUmlRelationship;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.associations.Association;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RailsDiagramExtras
extends DiagramExtras<RClass> {
    private final RailsUmlDnDSupport dndSupport = new RailsUmlDnDSupport();

    public DiagramDnDProvider<RClass> getDnDProvider() {
        return this.dndSupport;
    }

    public boolean useDefaultLayouter() {
        return true;
    }

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull List<DiagramNode<RClass>> nodes, @NotNull DiagramBuilder builder) {
        if (sink == null) {
            RailsDiagramExtras.$$$reportNull$$$0(0);
        }
        if (nodes == null) {
            RailsDiagramExtras.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            RailsDiagramExtras.$$$reportNull$$$0(2);
        }
        if (!nodes.isEmpty()) {
            return;
        }
        List edges = DiagramSelectionService.getInstance().getSelectedEdges(builder);
        DiagramEdge edge = (DiagramEdge)ContainerUtil.getOnlyItem((Collection)edges);
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            RailsUmlRelationship relationship = (RailsUmlRelationship)edge.getRelationship();
            Object fromClass = edge.getIdentifyingElement();
            Association association = relationship.getAssociation();
            if (association == null && fromClass instanceof Navigatable) {
                Navigatable o = (Navigatable)fromClass;
                return o;
            }
            if (association != null) {
                RCall reverse;
                RCall associationCall = association.getRCall();
                Association reverseAssociation = relationship.getReverseAssociation();
                RCall rCall = reverse = reverseAssociation != null ? reverseAssociation.getRCall() : null;
                if (associationCall.isValid()) {
                    if (reverse != null && reverse.isValid()) {
                        return RailsDiagramExtras.getNavigatable(builder, new Navigatable[]{associationCall, (NavigatablePsiElement)reverse});
                    }
                    return associationCall;
                }
            }
            return null;
        });
    }

    @Nullable
    private static Navigatable getNavigatable(final DiagramBuilder builder, final Navigatable ... navigatables) {
        if (navigatables == null || navigatables.length == 0) {
            return null;
        }
        if (navigatables.length == 1) {
            return navigatables[0];
        }
        List edges = DiagramSelectionService.getInstance().getSelectedEdges(builder);
        assert (edges.size() == 1);
        DiagramEdge edge = (DiagramEdge)edges.get(0);
        final DiagramNode src = edge.getSource();
        return new NavigatableAdapter(){

            public void navigate(boolean requestFocus) {
                JBList list = new JBList();
                list.setModel(new CollectionListModel((Object[])navigatables));
                list.setCellRenderer(new NavigationItemListCellRenderer());
                list.setSelectedIndex(0);
                JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setRequestFocus(requestFocus).setItemChosenCallback(() -> 1.lambda$navigate$1((JList)list, navigatables, requestFocus)).createPopup();
                GraphCanvasLocationService.getInstance().showPopupBeneathNode(popup, builder.getGraphBuilder(), Objects.requireNonNull(builder.getNode(src)));
            }

            private static /* synthetic */ void lambda$navigate$1(JList list, Navigatable[] navigatables2, boolean requestFocus) {
                int index = list.getSelectedIndex();
                ApplicationManager.getApplication().invokeLater(() -> navigatables2[index].navigate(requestFocus));
            }
        };
    }

    public DiagramAddElementAction getAddElementHandler() {
        return new RailsAddElementAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
        }
        objectArray[1] = "com/intellij/diagram/ruby/rails/RailsDiagramExtras";
        objectArray[2] = "uiDataSnapshot";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

