/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby.gems;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;

public final class GemsUmlUtil {
    public static String getExactGemName(String libraryName) {
        int spacePos = libraryName.indexOf(" ");
        return libraryName.substring(0, spacePos);
    }

    @Nullable
    public static VirtualFile getModelsFolder(GemInfo gem) {
        VirtualFile gemFile = gem.getFile();
        if (gemFile == null) {
            return null;
        }
        for (String path : (List)RailsPaths.getDefaultPaths().get("app/models")) {
            VirtualFile file = gemFile.findFileByRelativePath(path);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public static Set<GemInfo> getDependentGems(GemInfo gem, Collection<GemInfo> sdkGems) {
        GemDependency[] dependencies;
        HashSet<GemInfo> dependentGems = new HashSet<GemInfo>();
        for (GemDependency dependency : dependencies = gem.getDependencies()) {
            GemInfo g = RubyGemSearchUtil.findGem(sdkGems, arg_0 -> ((GemDependency)dependency).isSatisfied(arg_0));
            if (g == null) continue;
            dependentGems.add(g);
        }
        return dependentGems;
    }

    public static Set<RFile> getModelFilesFromDirectory(VirtualFile modelDir, Project project) {
        HashSet<RFile> files = new HashSet<RFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (modelDir.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile child : children = modelDir.getChildren()) {
                PsiFile file = psiManager.findFile(child);
                if (!(file instanceof RFile)) continue;
                files.add((RFile)file);
            }
        }
        return files;
    }

    public static void addRelationInGemModelsMap(@NotNull Map<GemInfo, Set<RClass>> map, @NotNull GemInfo gem, @NotNull Project project) {
        Set<RFile> modelFiles;
        VirtualFile modelsDirectory;
        if (map == null) {
            GemsUmlUtil.$$$reportNull$$$0(0);
        }
        if (gem == null) {
            GemsUmlUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GemsUmlUtil.$$$reportNull$$$0(2);
        }
        if ((modelsDirectory = GemsUmlUtil.getModelsFolder(gem)) != null && !(modelFiles = GemsUmlUtil.getModelFilesFromDirectory(modelsDirectory, project)).isEmpty()) {
            HashSet classes = new HashSet();
            for (RFile modelFile : modelFiles) {
                classes.addAll(RContainerUtil.getTopLevelClasses((RContainer)modelFile));
            }
            map.put(gem, classes);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "map";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "gem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/diagram/ruby/gems/GemsUmlUtil";
        objectArray[2] = "addRelationInGemModelsMap";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

