/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.ruby;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RConstantHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RFieldHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

final class RubyUmlElementManager
extends AbstractDiagramElementManager<RContainer> {
    RubyUmlElementManager() {
    }

    @Nullable
    public RContainer findInDataContext(@NotNull DataContext context) {
        VirtualFile virtualFile;
        PsiFile psiFile;
        Project project;
        if (context == null) {
            RubyUmlElementManager.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (element instanceof RClass || element instanceof RModule) {
            return (RContainer)element;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null && (element = PsiTreeUtil.getParentOfType((PsiElement)PsiUtilBase.getElementAtCaret((Editor)editor), (Class[])new Class[]{RClass.class, RModule.class})) != null) {
            return (RContainer)element;
        }
        PsiFile psiFile2 = psiFile = element instanceof PsiFile ? (PsiFile)element : (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (psiFile instanceof RFile && (virtualFile = psiFile.getVirtualFile()) != null) {
            RContainer container = (RContainer)psiFile;
            String fileNameWithoutExtension = virtualFile.getNameWithoutExtension();
            return RContainerUtil.getTopLevelClasses((RContainer)container).stream().filter(s -> s.getName().equals(NamingConventions.toCamelCase((String)fileNameWithoutExtension))).findFirst().orElse(null);
        }
        return null;
    }

    public Object @NotNull [] getNodeItems(RContainer container) {
        if (container instanceof RClass || container instanceof RModule) {
            ArrayList<RField> elements = new ArrayList<RField>();
            elements.addAll(((RMethodHolder)container).getMethods());
            List declarations = ((RFieldHolder)container).getFieldsDeclarations();
            elements.addAll(RubyUmlElementManager.filterDuplicatedFields(declarations));
            elements.addAll(((RConstantHolder)container).getConstantDeclarations());
            Object[] objectArray = elements.isEmpty() ? PsiElement.EMPTY_ARRAY : elements.toArray();
            if (objectArray == null) {
                RubyUmlElementManager.$$$reportNull$$$0(1);
            }
            return objectArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            RubyUmlElementManager.$$$reportNull$$$0(2);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof RClass || element instanceof RModule;
    }

    public String getElementTitle(RContainer element) {
        return element.getName();
    }

    public SimpleColoredText getItemName(@Nullable Object element, @NotNull DiagramState presentation) {
        if (presentation == null) {
            RubyUmlElementManager.$$$reportNull$$$0(3);
        }
        String text = null;
        if (element instanceof RContainer && ((RContainer)element).isValid()) {
            if (element instanceof RClass || element instanceof RModule) {
                Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)element));
                if (symbol != null) {
                    text = symbol.getFQNWithNesting().toString();
                }
            } else {
                text = ((RContainer)element).getName();
            }
        } else {
            text = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : "";
        }
        if (text == null) {
            String stringifiedElement;
            text = stringifiedElement = element.toString();
        }
        return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @Nullable
    @Nls
    public String getNodeTooltip(RContainer element) {
        return null;
    }

    private static List<RField> filterDuplicatedFields(@NotNull List<RField> source) {
        if (source == null) {
            RubyUmlElementManager.$$$reportNull$$$0(4);
        }
        HashSet<String> names = new HashSet<String>();
        ArrayList<RField> result = new ArrayList<RField>();
        for (RField field : source) {
            if (names.contains(field.getName())) continue;
            names.add(field.getName());
            result.add(field);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/ruby/RubyUmlElementManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/ruby/RubyUmlElementManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterDuplicatedFields";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

