/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ruby.performanceTesting;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Argument;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.concurrent.atomic.LongAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.ruby.performanceTesting.RubyAbstractCommand;

public class GetSymbolMembers
extends RubyAbstractCommand<Options> {
    public static final String PREFIX = "%rubyGetSymbolMembers";
    public static final String SPAN_NAME = "getSymbolMembers";

    public GetSymbolMembers(@NotNull String text, int line) {
        if (text == null) {
            GetSymbolMembers.$$$reportNull$$$0(0);
        }
        super(text, line, PREFIX, new Options(), false);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            GetSymbolMembers.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ApplicationManager.getApplication().runReadAction(Context.current().wrap(() -> this.lambda$_execute$2(context, (ActionCallback)actionCallback)));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            GetSymbolMembers.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private /* synthetic */ void lambda$_execute$2(PlaybackContext context, ActionCallback actionCallback) {
        Options options = (Options)this.getOptions();
        if (options.clearCache) {
            this.clearCaches(context.getProject());
        }
        TraceUtil.runWithSpanThrows((SpanBuilder)PerformanceTestSpan.TRACER.spanBuilder(SPAN_NAME), span -> {
            long time = System.currentTimeMillis();
            Symbol symbol = SymbolUtil.findConstantByFQN((Project)context.getProject(), (TypeSet)Types.MODULE_OR_CLASS_OR_CONSTANT, (FQN)FQN.Builder.create(Collections.singletonList(options.fqn), (boolean)false), null);
            RType type = RTypeFactory.createTypeBySymbol((Symbol)symbol);
            LongAdder counter = new LongAdder();
            type.processMembers(Symbol.Filter.ACCEPT_ALL, null, __ -> counter.increment());
            span.setAttribute("number", (long)counter.intValue());
            context.message(String.format("Got %d for %s with %dms", counter.intValue(), options.fqn, System.currentTimeMillis() - time), this.getLine());
        });
        actionCallback.setDone();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/ruby/performanceTesting/GetSymbolMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/ruby/performanceTesting/GetSymbolMembers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class Options {
        @Argument
        public String fqn;
        @Argument
        public boolean clearCache;
    }
}

