/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ruby.performanceTesting;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.ResultsToFileProcessor;
import com.sampullara.cli.Argument;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.ruby.performanceTesting.RubyAbstractCommand;

public class GetAncestors
extends RubyAbstractCommand<Options> {
    public static final String PREFIX = "%rubyGetAncestors";

    public GetAncestors(@NotNull String text, int line) {
        if (text == null) {
            GetAncestors.$$$reportNull$$$0(0);
        }
        super(text, line, PREFIX, new Options(), false);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            GetAncestors.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ReadAction.run(() -> this.lambda$_execute$0(context, (ActionCallback)actionCallback));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            GetAncestors.$$$reportNull$$$0(2);
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$_execute$0(PlaybackContext context, ActionCallback actionCallback) throws RuntimeException {
        try {
            Options options = (Options)this.getOptions();
            Symbol symbol = SymbolUtil.findConstantByFQN((Project)context.getProject(), (String)options.fqn);
            if (symbol == null) {
                context.error("fqn not found", this.getLine());
                return;
            }
            if (options.clearCache) {
                this.clearCaches(context.getProject());
            }
            long time = System.currentTimeMillis();
            List ancestors = SymbolHierarchy.getAncestorsCaching((Symbol)symbol, null);
            context.message(String.format("Got %d for %s with %dms", ancestors.size(), options.fqn, System.currentTimeMillis() - time), this.getLine());
            if (ApplicationManagerEx.isInIntegrationTest()) {
                Path perfMetricsPath = Paths.get(PathManager.getLogPath(), new String[0]).resolve("performance-metrics").resolve("getAncestorsMetrics.json");
                ResultsToFileProcessor.writeMetricsToJson((Path)perfMetricsPath, (String)(options.fqn.toLowerCase(Locale.ROOT) + "_" + options.clearCache), (Integer)ancestors.size(), (Long)time);
            }
        }
        finally {
            actionCallback.setDone();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/ruby/performanceTesting/GetAncestors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/ruby/performanceTesting/GetAncestors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class Options {
        @Argument
        public String fqn;
        @Argument
        public boolean clearCache;
    }
}

