/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi.i18n;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordList;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;
import org.jetbrains.plugins.cucumber.steps.CucumberStepHelper;

@NotNullByDefault
public final class JsonGherkinKeywordProvider
implements GherkinKeywordProvider {
    private final Map<String, GherkinKeywordList> myLanguageKeywords = new HashMap<String, GherkinKeywordList>();
    private final Set<String> myAllStepKeywords = new HashSet<String>();
    @Nullable
    private static GherkinKeywordProvider myKeywordProvider;
    @Nullable
    private static GherkinKeywordProvider myGherkin6KeywordProvider;

    public static GherkinKeywordProvider getKeywordProvider() {
        if (myKeywordProvider == null) {
            myKeywordProvider = JsonGherkinKeywordProvider.createKeywordProviderFromJson("gherkin-languages-old.json");
        }
        return myKeywordProvider;
    }

    public static GherkinKeywordProvider getKeywordProvider(boolean gherkin6) {
        if (!gherkin6) {
            return JsonGherkinKeywordProvider.getKeywordProvider();
        }
        if (myGherkin6KeywordProvider == null) {
            myGherkin6KeywordProvider = JsonGherkinKeywordProvider.createKeywordProviderFromJson("gherkin-languages.json");
        }
        return myGherkin6KeywordProvider;
    }

    public static GherkinKeywordProvider getKeywordProvider(PsiElement context) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        boolean gherkin6Enabled = module != null && CucumberStepHelper.isGherkin6Supported(module);
        return JsonGherkinKeywordProvider.getKeywordProvider(gherkin6Enabled);
    }

    private static GherkinKeywordProvider createKeywordProviderFromJson(String jsonFileName) {
        GherkinKeywordProvider result = null;
        ClassLoader classLoader = JsonGherkinKeywordProvider.class.getClassLoader();
        if (classLoader != null) {
            InputStream gherkinKeywordStream = Objects.requireNonNull(classLoader.getResourceAsStream(jsonFileName));
            result = new JsonGherkinKeywordProvider(gherkinKeywordStream);
        }
        return result != null ? result : new PlainGherkinKeywordProvider();
    }

    public JsonGherkinKeywordProvider(InputStream inputStream) {
        try (InputStreamReader in2 = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            Map fromJson = (Map)new Gson().fromJson((Reader)in2, new TypeToken<Map<String, HashMap<String, Object>>>(this){}.getType());
            for (Map.Entry entry : fromJson.entrySet()) {
                Map translation = (Map)entry.getValue();
                GherkinKeywordList keywordList = new GherkinKeywordList(translation);
                this.myLanguageKeywords.put((String)entry.getKey(), keywordList);
                for (String keyword : keywordList.getAllKeywords()) {
                    if (keywordList.getTokenType(keyword) != GherkinTokenTypes.STEP_KEYWORD) continue;
                    this.myAllStepKeywords.add(keyword);
                }
            }
        }
        catch (MalformedJsonException in2) {
        }
        catch (IOException e) {
            Logger.getInstance((String)JsonGherkinKeywordProvider.class.getName()).error((Throwable)e);
        }
    }

    @Override
    public Collection<String> getAllKeywords(String language) {
        return this.getKeywordList(language).getAllKeywords();
    }

    @Override
    public IElementType getTokenType(String language, String keyword) {
        return this.getKeywordList(language).getTokenType(keyword);
    }

    @Override
    public String getBaseKeyword(String language, String keyword) {
        return this.getKeywordList(language).getBaseKeyword(keyword);
    }

    @Override
    public boolean isSpaceRequiredAfterKeyword(String language, String keyword) {
        return this.getKeywordList(language).isSpaceAfterKeyword(keyword);
    }

    @Override
    public boolean isStepKeyword(String keyword) {
        return this.myAllStepKeywords.contains(keyword);
    }

    @Override
    public GherkinKeywordTable getKeywordsTable(@Nullable String language) {
        return this.getKeywordList(language).getKeywordsTable();
    }

    private GherkinKeywordList getKeywordList(@Nullable String language) {
        GherkinKeywordList keywordList = this.myLanguageKeywords.get(language);
        if (keywordList == null) {
            keywordList = Lazy.myEmptyKeywordList;
        }
        return keywordList;
    }

    private static final class Lazy {
        static final GherkinKeywordList myEmptyKeywordList = new GherkinKeywordList();

        private Lazy() {
        }
    }
}

