/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.database.impl;

import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.database.MigrationField;
import org.jetbrains.plugins.ruby.rails.database.RailsSchemaParser;
import org.jetbrains.plugins.ruby.rails.database.RailsTableDefinition;
import org.jetbrains.plugins.ruby.rails.database.impl.RailsSqlSchemaVersionIndex;

final class RailsSqlSchemaParser
implements RailsSchemaParser {
    RailsSqlSchemaParser() {
    }

    @NotNull
    public Map<String, RailsTableDefinition> parseSchema(@NotNull PsiFile file) {
        if (file == null) {
            RailsSqlSchemaParser.$$$reportNull$$$0(0);
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (!(file instanceof SqlFile)) {
                return new CachedValueProvider.Result(Collections.emptyMap(), new Object[]{file});
            }
            SqlFile sqlFile = (SqlFile)file;
            LinkedHashMap<String, RailsTableDefinition> definitions = new LinkedHashMap<String, RailsTableDefinition>();
            for (SqlElement element : sqlFile.getDdl()) {
                String nameWithSchema;
                ProgressManager.checkCanceled();
                if (!(element instanceof SqlCreateTableStatement)) continue;
                SqlCreateTableStatement statement = (SqlCreateTableStatement)element;
                RailsTableDefinition tableDefinition = new RailsTableDefinition((PsiElement)statement);
                for (SqlColumnDefinition column : statement.getDeclaredColumns()) {
                    tableDefinition.addField(new MigrationField(column.getName(), RailsSqlSchemaParser.getFieldDataType(column), (PsiElement)column));
                }
                String name = statement.getName();
                if (name != null) {
                    definitions.putIfAbsent(name, tableDefinition);
                }
                if ((nameWithSchema = RailsSqlSchemaParser.getTableNameWithSchema(statement)) == null) continue;
                definitions.putIfAbsent(nameWithSchema, tableDefinition);
            }
            return new CachedValueProvider.Result(definitions, new Object[]{file});
        });
        if (map == null) {
            RailsSqlSchemaParser.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Nullable
    public String parseSchemaVersion(@NotNull PsiFile file) {
        if (file == null) {
            RailsSqlSchemaParser.$$$reportNull$$$0(2);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        if (virtualFile == null) {
            return null;
        }
        return (String)FileBasedIndex.getInstance().getSingleEntryIndexData(RailsSqlSchemaVersionIndex.KEY, virtualFile, project);
    }

    @Nullable
    private static String getFieldDataType(@NotNull SqlColumnDefinition column) {
        if (column == null) {
            RailsSqlSchemaParser.$$$reportNull$$$0(3);
        }
        DasType type = DasTypeUtilsKt.unwrap((DasType)((DasType)ObjectUtils.coalesce((Object)((DasType)ObjectUtils.doIfNotNull((Object)column.getTypeElement(), DasTypeAwareObject::getDasType)), (Object)DasTypeSystemBase.UNKNOWN)));
        return switch (DasTypeUtilsKt.getCategoryOrUnknown((DasType)type)) {
            case DasTypeCategory.BOOLEAN -> "boolean";
            case DasTypeCategory.DATE -> "date";
            case DasTypeCategory.DATE_TIME -> "datetime";
            case DasTypeCategory.INTEGER -> "integer";
            case DasTypeCategory.REAL -> "float";
            case DasTypeCategory.STRING -> "string";
            case DasTypeCategory.TIME -> "time";
            case DasTypeCategory.TIMESTAMP -> "timestamp";
            default -> null;
        };
    }

    @Nullable
    private static String getTableNameWithSchema(@NotNull SqlCreateTableStatement statement) {
        if (statement == null) {
            RailsSqlSchemaParser.$$$reportNull$$$0(4);
        }
        String schema = statement.getDasParent() != null ? statement.getDasParent().getName() : null;
        return schema == null || schema.isEmpty() ? null : schema + "." + statement.getDasObject().getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/database/impl/RailsSqlSchemaParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/impl/RailsSqlSchemaParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSchema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseSchema";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseSchemaVersion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFieldDataType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTableNameWithSchema";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

