/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.database.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.SelectInDatabaseView;
import com.intellij.ide.FileEditorSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.callTypes.RailsActiveRecordAttributeCallType;
import org.jetbrains.plugins.ruby.rails.database.impl.RailsDatabaseUtil;
import org.jetbrains.plugins.ruby.rails.model.ActiveRecordModel;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;

public final class RailsSelectInDatabaseViewProvider
implements SelectInDatabaseView.Extension {
    @Nullable
    public PsiElement findTarget(@NotNull SelectInContext context, boolean strict, boolean fast) {
        if (context == null) {
            RailsSelectInDatabaseViewProvider.$$$reportNull$$$0(0);
        }
        if (fast) {
            return null;
        }
        Project project = context.getProject();
        VirtualFile virtualFile = context.getVirtualFile();
        if (DumbService.isDumb((Project)project) || virtualFile.isDirectory()) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(virtualFile);
        ActiveRecordModel model = ActiveRecordModel.fromFile((PsiFile)file);
        if (model != null) {
            return RailsSelectInDatabaseViewProvider.findTargetFromModel(project, model);
        }
        RailsApp app = (RailsApp)ObjectUtils.doIfNotNull((Object)file, RailsApp::fromPsiElement);
        if (app != null && app.getPaths().findFiles("db", new String[]{"schema.rb"}).contains(virtualFile)) {
            return RailsSelectInDatabaseViewProvider.findTargetFromSchemaElement(project, (PsiElement)ObjectUtils.doIfCast((Object)context, FileEditorSelectInContext.class, it -> it.getElementAtCaret(false)));
        }
        return null;
    }

    @Nullable
    private static PsiElement findTargetFromModel(@NotNull Project project, @NotNull ActiveRecordModel model) {
        String tableName;
        if (project == null) {
            RailsSelectInDatabaseViewProvider.$$$reportNull$$$0(1);
        }
        if (model == null) {
            RailsSelectInDatabaseViewProvider.$$$reportNull$$$0(2);
        }
        if ((tableName = model.getTableName()) == null) {
            return null;
        }
        for (DbDataSource source : RailsDatabaseUtil.getDataSources(project)) {
            ProgressManager.checkCanceled();
            DbElement element = DasUtil.getTables((DasDataSource)source).toStream().filter(it -> tableName.equals(it.getName())).flatMap(it -> Stream.ofNullable(source.findElement((DasObject)it))).findFirst().orElse(null);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findTargetFromSchemaElement(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            RailsSelectInDatabaseViewProvider.$$$reportNull$$$0(3);
        }
        if (element != null) {
            RPossibleCall tableCall = (RPossibleCall)PsiTreeUtil.findFirstParent((PsiElement)element, parent -> RubyPsiUtil.isCallWithCommand((PsiElement)parent, (String[])new String[]{"create_table"}));
            RPossibleCall columnCall = (RPossibleCall)PsiTreeUtil.findFirstParent((PsiElement)element, parent -> RubyPsiUtil.isCallOfType((PsiElement)parent, it -> it instanceof RailsActiveRecordAttributeCallType));
            String tableName = Optional.ofNullable(tableCall).map(it -> (RPsiElement)ContainerUtil.getFirstItem((List)it.getArguments())).map(RubyInterpretUtil::evaluateStringOrSymbolElement).orElse("");
            String columnName = Optional.ofNullable(columnCall).map(it -> (RPsiElement)ContainerUtil.getFirstItem((List)it.getArguments())).map(RubyInterpretUtil::evaluateStringOrSymbolElement).orElse("");
            for (DbDataSource source : RailsDatabaseUtil.getDataSources(project)) {
                ProgressManager.checkCanceled();
                DasTable table = (DasTable)DasUtil.getTables((DasDataSource)source).find(it -> tableName.equals(it.getName()));
                DasColumn column = (DasColumn)DasUtil.getColumns((DasObject)table).find(it -> columnName.equals(it.getName()));
                DbElement target = source.findElement((DasObject)ObjectUtils.coalesce((Object)column, (Object)table));
                if (target == null) continue;
                return target;
            }
        }
        return (PsiElement)ContainerUtil.getFirstItem(RailsDatabaseUtil.getDataSources(project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/database/impl/RailsSelectInDatabaseViewProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTarget";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetFromModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetFromSchemaElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

